/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.billconvert.bizcase;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AutoFixLinkSample {
    public void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcBillTypeFld, String srcBillNoFld, String srcEntryFld, String srcRowSeqFld, Object targetBillId) {
        DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
        TableDefine srcTableDefine = this.loadSrcTableDefine(targetBillObj, srcBillTypeFld, srcEntryFld);
        String srcBillNo = targetBillObj.getString(srcBillNoFld);
        if (srcTableDefine != null) {
            DynamicObject[] sourceBillObjs = this.loadSourceBill(srcTableDefine, srcBillNo);
            this.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObjs, srcRowSeqFld);
        }
        SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
    }

    private TableDefine loadSrcTableDefine(DynamicObject targetBillObj, String srcBillTypeFld, String srcEntryFld) {
        Object srcBillTypeFldValue = targetBillObj.get(srcBillTypeFld);
        String srcEntityNumber = "";
        srcEntityNumber = srcBillTypeFldValue instanceof DynamicObject ? (String)((DynamicObject)srcBillTypeFldValue).getPkValue() : (String)srcBillTypeFldValue;
        String srcEntryKey = targetBillObj.getString(srcEntryFld);
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return null;
        }
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryKey);
        return srcTableDefine;
    }

    private DynamicObject[] loadSourceBill(TableDefine srcTableDefine, String srcBillNo) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRowSeqFld) {
        Object[] srcRowId;
        HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
        for (DynamicObject srcObj : sourceBillObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
            for (DynamicObject srcRow : srcRows) {
                Integer srcRowSeq = srcRow.getInt("seq");
                srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            Integer srcRowSeq;
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty() || !srcRowIds.containsKey(srcRowSeq = Integer.valueOf(targetRow.getInt(srcRowSeqFld)))) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
        }
    }
}

