/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.billconvert.bizcase;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AutoLinkSample
extends AbstractBillPlugIn {
    private String KEY_SOURCEBILLTYPE = "srcbilltype";
    private String KEY_SOURCEBILLNO = "srcbillno";
    private String KEY_SOURCEENTRYKEY = "srcentrykey";
    private String KEY_SOURCEROWSEQ = "srcrowseq";

    public void afterImportData(ImportDataEventArgs e) {
        this.linkSourceRow(this.getModel().getDataEntityType().getName(), "entryentity");
    }

    private void linkSourceRow(String targetEntityNumber, String targetEntryKey) {
        Object srcEntityFldValue = this.getModel().getValue(this.KEY_SOURCEBILLTYPE);
        String srcEntityNumber = "";
        srcEntityNumber = srcEntityFldValue instanceof DynamicObject ? (String)((DynamicObject)srcEntityFldValue).getPkValue() : (String)srcEntityFldValue;
        String srcBillNo = (String)this.getModel().getValue(this.KEY_SOURCEBILLNO);
        String srcEntryKey = (String)this.getModel().getValue(this.KEY_SOURCEENTRYKEY);
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || StringUtils.isBlank((CharSequence)srcBillNo) || StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return;
        }
        DynamicObject[] srcObjs = this.loadSourceBill(srcEntityNumber, srcEntryKey, srcBillNo);
        if (srcObjs.length == 0) {
            return;
        }
        HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
        for (DynamicObject srcObj : srcObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcEntryKey);
            for (DynamicObject srcRow : srcRows) {
                Integer srcRowSeq = srcRow.getInt("seq");
                Object[] srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryKey);
        Long srcTableId = tableDefine.getTableId();
        String lkEntryKey = StringUtils.equals((CharSequence)targetEntityNumber, (CharSequence)targetEntryKey) ? "billhead_lk" : targetEntryKey + "_lk";
        DynamicObject targetObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection targetRows = targetObj.getDynamicObjectCollection(targetEntryKey);
        for (DynamicObject targetRow : targetRows) {
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty()) continue;
            linkRows.clear();
            Integer srcRowSeq = targetRow.getInt(this.KEY_SOURCEROWSEQ);
            if (!srcRowIds.containsKey(srcRowSeq)) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            Object[] srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
        }
    }

    private DynamicObject[] loadSourceBill(String srcEntityNumber, String srcEntryKey, String srcBillNo) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcEntryKey + ".id");
        selectFields.add(srcEntryKey + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcEntityNumber, (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }
}

