/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.bizoperation.bizcase;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class BeginOperationTransactionSample
extends AbstractOperationServicePlugIn {
    boolean throwErr = false;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            try {
                this.doBizLogic(obj);
                successObjs.add(obj);
            }
            catch (KDBizException exp) {
                this.addValidateError(obj, exp);
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private void addErrorInfo(DynamicObject obj, KDBizException exp) {
        ValidationErrorInfo errInfo = this.buildErrMessage(obj, exp);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }

    private void addValidateError(DynamicObject obj, KDBizException exp) {
        ValidateResult validateResult = new ValidateResult();
        ValidationErrorInfo errInfo = this.buildErrMessage(obj, exp);
        validateResult.addErrorInfo((OperateErrorInfo)errInfo);
        validateResult.setSuccess(false);
        this.operationResult.getValidateResult().getErrorPkIds().add(obj.getPkValue());
        this.operationResult.getValidateResult().getValidateErrors().add(validateResult);
    }

    private void doBizLogic(DynamicObject obj) {
        boolean bl = this.throwErr = !this.throwErr;
        if (this.throwErr) {
            throw new KDBizException(new ErrorCode("Sample_BeginOperationTransaction_AddErrorInfo", "\u94f6\u4f01\u4e92\u8054\uff0c\u629b\u51fa\u7684\u968f\u673a\u9519\u8bef"), new Object[0]);
        }
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, exp.getErrorCode().getCode(), "\u94f6\u4f01\u4e92\u8054", msg, errorLevel);
        return info;
    }
}

