/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.list.bizcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class FilterContainerInitSample
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String CACHEKEY_ORGCOMBOITEMS = "orgcomboitems";
    private static final String ORG_ENTITY = "bos_org";
    private boolean isClickSearch = false;
    private long orgId = 0L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        if (!this.isBillHasMainOrg()) {
            return;
        }
        CommonFilterColumn orgColumn = this.buildOrgFilterColumn();
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (!filterColumnList.contains(orgColumn)) {
            filterColumnList.add(orgColumn);
            if (!this.isClickSearch) {
                this.orgId = RequestContext.get().getOrgId();
                HashSet<Long> hasPermOrgs = new HashSet<Long>();
                if (orgColumn.getComboItems() != null) {
                    for (ComboItem item : orgColumn.getComboItems()) {
                        hasPermOrgs.add(Long.valueOf(item.getId()));
                    }
                }
                if (!hasPermOrgs.contains(RequestContext.get().getOrgId())) {
                    this.orgId = (Long)hasPermOrgs.iterator().next();
                }
            }
            orgColumn.setDefaultValue(String.valueOf(this.orgId));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.isClickSearch = true;
        if (!this.isBillHasMainOrg()) {
            return;
        }
        String orgFldName = this.getBillEntityType().getMainOrg() + ".id";
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        this.orgId = 0L;
        for (int i = customFiterList.size() - 1; i >= 0; --i) {
            List orgIds;
            Map customFiter = (Map)customFiterList.get(i);
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.isEmpty() || !StringUtils.equals((CharSequence)orgFldName, (CharSequence)((String)fieldNames.get(0))) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.isEmpty()) continue;
            this.orgId = Long.parseLong((String)orgIds.get(0));
            customFiterList.remove(customFiter);
            break;
        }
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        if (this.orgId == 0L) {
            return;
        }
        BaseDataServiceHelper helper = new BaseDataServiceHelper();
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)this.getBillEntityId(), (Long)this.orgId);
        if (qfilter != null) {
            List filters = e.getQFilters();
            filters.add(qfilter);
            e.setQFilters(filters);
        }
        super.setFilter(e);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        if (!this.isBillHasMainOrg()) {
            return;
        }
        String orgFldName = this.getBillEntityType().getMainOrg() + ".id";
        if (StringUtils.equals((CharSequence)orgFldName, (CharSequence)arg0.getFieldName())) {
            arg0.setRefEntityId(ORG_ENTITY);
            arg0.setRefPropKey("id");
        }
    }

    private String getBillEntityId() {
        return ((IListView)this.getView()).getEntityId();
    }

    private BillEntityType getBillEntityType() {
        return (BillEntityType)((IListView)this.getView()).getListModel().getDataEntityType();
    }

    private boolean isBillHasMainOrg() {
        return StringUtils.isNotBlank((CharSequence)this.getBillEntityType().getMainOrg());
    }

    private CommonFilterColumn buildOrgFilterColumn() {
        String mainOrgKey = this.getBillEntityType().getMainOrg();
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setKey(mainOrgKey + ".id");
        orgColumn.setCaption(new LocaleString("\u4e1a\u52a1\u5355\u5143"));
        orgColumn.setFieldName(mainOrgKey + ".id");
        orgColumn.setMustInput(true);
        List<ComboItem> combos = this.buildOrgComboItems();
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        return orgColumn;
    }

    private List<ComboItem> buildOrgComboItems() {
        String cacheString = this.getPageCache().get(CACHEKEY_ORGCOMBOITEMS);
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            return SerializationUtils.fromJsonStringToList((String)cacheString, ComboItem.class);
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List hasPermOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)this.getBillEntityId(), (String)"47150e89000000ac");
        if (!hasPermOrgs.isEmpty()) {
            ORM orm = ORM.create();
            DynamicObjectCollection col = orm.query(ORG_ENTITY, "id,name", new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)});
            for (DynamicObject org : col) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getPkValue()));
                item.setCaption(new LocaleString(org.getString("name")));
                item.setValue(String.valueOf(org.getPkValue()));
                combos.add(item);
            }
        }
        cacheString = SerializationUtils.toJsonString(combos);
        this.getPageCache().put(CACHEKEY_ORGCOMBOITEMS, cacheString);
        return combos;
    }
}

