/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.list.bizcase;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;

public class ListRowDoubleClickSample
extends AbstractListPlugin {
    private static final String ENTITYID_MATERIAL = "bd_material";
    private static final String KEY_MATERIALID = "material";

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (!this.isLookup()) {
            evt.setCancel(true);
            if (!evt.getCurrentListSelectedRow().getDataMap().containsKey(KEY_MATERIALID)) {
                return;
            }
            long materialId = (Long)evt.getCurrentListSelectedRow().getDataMap().get(KEY_MATERIALID);
            if (materialId == 0L) {
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(ENTITYID_MATERIAL);
            showParameter.setPkId((Object)materialId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }
}

