/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.bill.list.bizcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class RefreshNodeSample
extends AbstractTreeListPlugin {
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String KEY_BIZAPPID = "bizappid";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TREEBUTTONPANEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 10);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            e.setChildNodes(this.loadAppNodes());
        } else {
            e.setChildNodes(null);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        QFilter filter = this.buildAppQFilter(KEY_BIZAPPID, (String)e.getNodeId());
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<TreeNode> loadAppNodes() {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        List<TreeNode> cloudNode4 = this.getCloudData();
        for (TreeNode node : cloudNode4) {
            allNodes.put(node.getId(), node);
        }
        List<TreeNode> appNode4 = RefreshNodeSample.getAppData();
        for (TreeNode node : appNode4) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return cloudNode4;
    }

    private List<TreeNode> getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        ORM orm = ORM.create();
        String fields = "id, number, name";
        String orderby = "";
        QFilter[] filters = new QFilter[]{};
        try (DataSet ds = orm.queryDataSet("bos_devportal_bizcloud", "bos_devportal_bizcloud", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = "cloud/" + row.getString("number");
                node.setText(row.getString("name"));
                node.setParentid("0");
                node.setId(nodeID);
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private static List<TreeNode> getAppData() {
        ArrayList<TreeNode> appNode = new ArrayList<TreeNode>();
        ORM orm = ORM.create();
        String fields = "id,number, name, bizcloud.id, bizcloud.number";
        String orderby = "";
        QFilter[] filters = new QFilter[]{};
        try (DataSet ds = orm.queryDataSet("bos_devportal_bizapp", "bos_devportal_bizapp", fields, filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String parentId = "cloud/" + row.getString("bizcloud.number");
                String nodeID = row.getString("id");
                node.setId(nodeID);
                node.setParentid(parentId);
                node.setText(row.getString("name"));
                appNode.add(node);
            }
        }
        return appNode;
    }

    private QFilter buildAppQFilter(String appIdFldKey, String nodeId) {
        ArrayList<String> appIds = new ArrayList<String>();
        TreeNode root = this.getTreeModel().getRoot();
        List bizCloudNodes = root.getChildren();
        if (bizCloudNodes != null) {
            TreeNode bizCloudNode;
            Iterator iterator = bizCloudNodes.iterator();
            while (iterator.hasNext() && !this.matchCloudNode(nodeId, bizCloudNode = (TreeNode)iterator.next(), appIds)) {
            }
        }
        if (appIds.isEmpty()) {
            return null;
        }
        if (appIds.size() == 0) {
            return new QFilter(appIdFldKey, "=", appIds.get(0));
        }
        return new QFilter(appIdFldKey, "in", (Object)appIds.toArray(new String[appIds.size()]));
    }

    private boolean matchCloudNode(String nodeId, TreeNode bizCloudNode, List<String> outAppIds) {
        if (StringUtils.equals((CharSequence)nodeId, (CharSequence)bizCloudNode.getId())) {
            if (bizCloudNode.getChildren() != null) {
                for (TreeNode appNode : bizCloudNode.getChildren()) {
                    outAppIds.add(appNode.getId());
                }
            }
            if (outAppIds.isEmpty()) {
                outAppIds.add(nodeId);
            }
            return true;
        }
        if (this.matchAppNode(nodeId, bizCloudNode)) {
            outAppIds.add(nodeId);
            return true;
        }
        return false;
    }

    private boolean matchAppNode(String nodeId, TreeNode bizCloudNode) {
        if (bizCloudNode.getChildren() != null) {
            for (TreeNode appNode : bizCloudNode.getChildren()) {
                if (!StringUtils.equals((CharSequence)appNode.getId(), (CharSequence)nodeId)) continue;
                return true;
            }
        }
        return false;
    }
}

