/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.utils.LogPrintUtil;

public class AttachmentPanelSample
extends AbstractFormPlugin
implements UploadListener {
    private static final String KEY_ATTACHMENTPANEL1 = "attachmentpanelap1";
    private static final String KEY_CODEEDIT1 = "codeeditap1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL1);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        for (String fileUrl : fileUrls) {
            String text = this.loadTextFileString(fileUrl);
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_CODEEDIT1);
            codeEdit.setText(text);
        }
    }

    public void remove(UploadEvent evt) {
    }

    public void afterRemove(UploadEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTextFileString(String fileUrl) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        int temp = 0;
        int len = 0;
        byte[] bt = null;
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>();
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            bt = new byte[0x500000];
            while ((temp = inStream.read()) != -1) {
                bt[len] = (byte)temp;
                ++len;
            }
        }
        catch (Exception e) {
            LogPrintUtil.printExceptionMessage((Exception)e, (String)e.getMessage());
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                LogPrintUtil.printExceptionMessage((Exception)e, (String)e.getMessage());
            }
        }
        return new String(bt, 0, len);
    }
}

