/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ComboEditDynItemSample
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COMBO_FIELD = "combofield";
    private static final String MUL_COMBO_FIELD = "mulcombofield3";
    private static final String FILTER = "filter";
    private static final String SORT = "sort";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addPackageDataListener(this::handlePackageDataEvent);
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ENTRY_ENTITY, "setColEditorProp", new Object[]{COMBO_FIELD, "isDynamicOption", true});
        clientViewProxy.invokeControlMethod(ENTRY_ENTITY, "setColEditorProp", new Object[]{MUL_COMBO_FIELD, "isDynamicOption", true});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setColumnProperty(COMBO_FIELD, SORT, (Object)false);
        grid.setColumnProperty(COMBO_FIELD, FILTER, (Object)false);
        grid.setColumnProperty(MUL_COMBO_FIELD, SORT, (Object)false);
        grid.setColumnProperty(MUL_COMBO_FIELD, FILTER, (Object)false);
    }

    private void handlePackageDataEvent(PackageDataEvent packageDataEvent) {
        Object ctl = packageDataEvent.getSource();
        int rowIndex = packageDataEvent.getRowIndex();
        if (ctl instanceof ComboEdit && COMBO_FIELD.equals(((ComboEdit)ctl).getKey())) {
            packageDataEvent.setComboList(this.getComboItemsForComboEdit(rowIndex));
        } else if (ctl instanceof Control && MUL_COMBO_FIELD.equals(((Control)ctl).getKey())) {
            packageDataEvent.setComboList(this.getComboItemsForMultiCombo(rowIndex));
        }
    }

    private List<Object> getComboItemsForComboEdit(int rowIndex) {
        if (rowIndex == 1) {
            return Arrays.asList(new ComboItem(new LocaleString("\u6211\u662fA"), "A"), new ComboItem(new LocaleString("\u6211\u662fB"), "B"), new ComboItem(new LocaleString("\u6211\u662fC"), "C"));
        }
        return Collections.emptyList();
    }

    private List<Object> getComboItemsForMultiCombo(int rowIndex) {
        switch (rowIndex) {
            case 0: {
                return Arrays.asList(new ComboItem(new LocaleString("\u591a\u9009\u4e0b\u62c91"), "A"), this.createComboItem("\u591a\u9009\u4e0b\u62c92", "B", true, true), this.createComboItem("\u591a\u9009\u4e0b\u62c93", "C", true, false));
            }
            case 2: {
                return Arrays.asList(this.createComboItem("\u591a\u9009\u4e0b\u62c93", "C", true, true), new ComboItem(new LocaleString("\u591a\u9009\u4e0b\u62c92"), "B"), this.createComboItem("\u591a\u9009\u4e0b\u62c91", "A", true, true));
            }
        }
        return Collections.emptyList();
    }

    private ComboItem createComboItem(String localeString, String value, boolean disable, boolean visible) {
        ComboItem item = new ComboItem(new LocaleString(localeString), value);
        item.setDisable(disable);
        item.setItemVisible(visible);
        return item;
    }
}

