/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class FilterGridSample
extends AbstractFormPlugin {
    private static final String FORMID_MATERIAL = "bd_material";
    private static final String KEY_FILTERGRID1 = "filtergridap1";
    private static final String KEY_BUTTON_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button ok = (Button)this.getView().getControl(KEY_BUTTON_OK);
        ok.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID1);
        filterGrid.setEntityNumber(FORMID_MATERIAL);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("number");
        filterGrid.setFilterFieldKeys(keys);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID1);
        FilterCondition filterCondition = this.loadFilter();
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_OK)) {
            FilterCondition filterCondition = this.getFilter();
            String filter = this.saveFilter(filterCondition);
            this.getView().returnDataToParent((Object)filter);
            this.getView().close();
        }
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(KEY_FILTERGRID1);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private FilterCondition loadFilter() {
        String filter = "";
        if (StringUtils.isBlank((CharSequence)filter)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        return filterCondition;
    }

    private String saveFilter(FilterCondition filterCondition) {
        String filter = "";
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filter);
        }
        return filter;
    }

    private void parseFilterCondition(MainEntityType mainType, FilterCondition filterCondition) {
        FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
        TimeService timeService = new TimeService();
        filterBuilder.setTimeService((ITimeService)timeService);
        UserService userService = new UserService();
        filterBuilder.setUserService((IUserService)userService);
        filterBuilder.buildFilter(false);
        List qFilters = filterBuilder.getQFilters();
        String[] filterScripts = filterBuilder.buildFilterScript();
        String formula = filterScripts[0];
        String formulaDesc = filterScripts[1];
    }
}

