/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.control.bizcase;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SearchSample
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String KEY_SEARCH = "searchap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public List<String> getSearchList(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = arg0.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = arg0.getText();
            this.doSearch(searchText);
        }
    }

    private List<String> doSearchList(String searchText) {
        ORM orm = ORM.create();
        QFilter f = new QFilter("number", "like", (Object)("%" + searchText + "%"));
        QFilter f2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter filters = f.or(f2);
        DynamicObjectCollection collection = orm.query("bd_settlementtype", new QFilter[]{filters});
        HashMap<String, String> searchList = new HashMap<String, String>();
        for (DynamicObject obj : collection) {
            searchList.put("bd_settlementtype " + obj.get("id").toString(), "\u7ed3\u7b97\u65b9\u5f0f\uff1a" + obj.get("number") + obj.get("name"));
        }
        f = new QFilter("number", "like", (Object)("%" + searchText + "%"));
        f2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        filters = f.or(f2);
        collection = orm.query("bd_currency", new QFilter[]{filters});
        for (DynamicObject obj : collection) {
            searchList.put("bd_currency " + obj.get("id").toString(), "\u5e01\u522b\uff1a" + obj.get("number") + obj.get("name"));
        }
        this.getPageCache().put("searchList", SerializationUtils.toJsonString(searchList));
        return new ArrayList<String>(searchList.values());
    }

    private void doSearch(String searchText) {
        if (this.getPageCache().get("searchList") != null) {
            Map searchList = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("searchList"), Map.class);
            searchList.forEach((key, value) -> {
                if (searchText.equals(value)) {
                    String[] arr = key.split(" ");
                    BillShowParameter param = new BillShowParameter();
                    param.setPkId((Object)arr[1]);
                    param.setFormId(arr[0]);
                    param.getOpenStyle().setShowType(ShowType.Modal);
                    param.setBillStatus(BillOperationStatus.EDIT);
                    this.getView().showForm((FormShowParameter)param);
                }
            });
        }
    }
}

