/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.field.bizcase;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;

public class CreateRadioSample
extends AbstractFormPlugin {
    private static final String KEY_PANELRADIO = "panelradio";
    private static final String KEY_RADIOGROUP = "radiogroup";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_RADIOA = "radioa";
    private static final String KEY_RADIOB = "radiob";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Container radioPanel = (Container)this.getView().getControl(KEY_PANELRADIO);
        FlexPanelAp dynamicPanel = this.createRadioPanel();
        Map runtimeMeta = dynamicPanel.createControl();
        List runtimeRadios = (List)runtimeMeta.get("items");
        radioPanel.addControls(runtimeRadios);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_BTNOK)) {
            this.getView().showMessage(String.format("\u5355\u9009\u6309\u94ae\u7ec4\u5f53\u524d\u9009\u62e9\u7684\u9009\u9879\u662f\uff1a%s", this.getModel().getValue(KEY_RADIOGROUP)));
        }
    }

    private FlexPanelAp createRadioPanel() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(KEY_PANELRADIO);
        FieldAp radioApA = this.createRadioField(KEY_RADIOA, new LocaleString("\u52a8\u6001\u5355\u9009\u6309\u94ae A"), "A", KEY_RADIOGROUP);
        headPanelAp.getItems().add(radioApA);
        FieldAp radioApB = this.createRadioField(KEY_RADIOB, new LocaleString("\u52a8\u6001\u5355\u9009\u6309\u94ae B"), "B", KEY_RADIOGROUP);
        headPanelAp.getItems().add(radioApB);
        return headPanelAp;
    }

    private FieldAp createRadioField(String key, LocaleString caption, String value, String radiogroup) {
        FieldAp radioAp = new FieldAp();
        radioAp.setId(key);
        radioAp.setKey(key);
        radioAp.setName(caption);
        radioAp.setWidth(new LocaleString("120px"));
        radioAp.setHeight(new LocaleString("32px"));
        radioAp.setFireUpdEvt(true);
        RadioField radioFld = new RadioField();
        radioFld.setId(key);
        radioFld.setKey(key);
        radioFld.setGroup(radiogroup);
        radioFld.setItems(value);
        radioAp.setField((Field)radioFld);
        return radioAp;
    }
}

