/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.dynamicform.pcform.field.bizcase;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SetDecimalScaleSample
extends AbstractFormPlugin {
    private static final String Key_Scale = "scale";
    private static final String Key_Length = "length";
    private static final String Key_Entry = "entryentity";
    private static final String Key_EntryScale = "entryscale";
    private static final String Key_EntryLength = "entrylength";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int scale = (Integer)this.getModel().getValue(Key_Scale);
        this.setClientFieldScale(Key_Length, scale);
        this.setEntryScaleField(Key_Entry, Key_EntryLength, Key_EntryScale);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)Key_Scale, (CharSequence)e.getProperty().getName())) {
            int scale = (Integer)e.getChangeSet()[0].getNewValue();
            this.setClientFieldScale(Key_Length, scale);
            this.setServerFieldScale(Key_Length, scale);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)Key_Length, (CharSequence)e.getProperty().getName()) || StringUtils.equalsIgnoreCase((CharSequence)Key_EntryScale, (CharSequence)e.getProperty().getName())) {
            // empty if block
        }
    }

    private void setClientFieldScale(String key, int scale) {
        HashMap<String, Integer> editorProps = new HashMap<String, Integer>();
        editorProps.put("sc", scale);
        HashMap<String, HashMap<String, Integer>> ctrlProps = new HashMap<String, HashMap<String, Integer>>();
        ctrlProps.put("item", editorProps);
        this.getView().updateControlMetadata(key, ctrlProps);
    }

    private void setEntryScaleField(String entryKey, String decimalFldKey, String scaleFldKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", new Object[]{decimalFldKey, "sf", scaleFldKey});
    }

    private void setServerFieldScale(String key, int scale) {
        BigDecimal oldValue = (BigDecimal)this.getModel().getValue(key);
        BigDecimal newValue = oldValue.setScale(scale, RoundingMode.HALF_UP);
        this.getModel().setValue(key, (Object)newValue);
    }
}

