/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.report.queryplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.MulComboReportColumn;
import kd.bos.entity.report.PictureReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.ComboItem;

public class DemoAllColTypeRptListDataPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        demoDataSet.setRowCount(5000);
        return demoDataSet.createDataSet();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        return demoDataSet.createColumns(columns);
    }

    public static class DemoDataSet {
        public static final String LONG_ROWKEY = "rowkey";
        public static final String TEXT_BILLNO = "billno";
        public static final String COMBO_BILLSTATUS = "billstatus";
        public static final String DATE_BIZDATE = "bizdate";
        public static final String DATETIME_CREATETIME = "createtime";
        public static final String TIME_BEGINTIME = "begintime";
        public static final String INT_AGE = "age";
        public static final String NUM_RECORD = "record";
        public static final String PIC_USERHEAD = "userhead";
        public static final String MULCOMBO_CONVERTTYPE = "converttype";
        public static final String CHECK_ENABLE = "enable";
        public static final String BD_CURRENCY = "currency";
        public static final String BD_MATERIAL = "material";
        public static final String BD_PURMATERAIL = "purmaterial";
        public static final String BD_UNIT = "unit";
        public static final String QTY = "qty";
        public static final String PRICE = "price";
        public static final String AMOUNT = "amount";
        public static final String BD_ACCOUNT = "account";
        public static final String FLEX_ITME = "item";
        public static final String MULBD_CURRENCY = "mulcurrency";
        public static final String ITEMTYPE_CONTACTTYPE = "contacttype";
        public static final String ITEMCLASS_CONTACT = "contact";
        public static final String COMBO_CONVERTTYPE = "combo";
        public static final String BD_MATERIAL_NUMBER = "material_number";
        public static final String BD_MATERIAL_BASEUNIT = "material_baseunit";
        public static final String BD_MATERIAL_STATUE = "material_status";
        public static final String BD_MATERIAL_ENABLEPUR = "material_enablepur";
        public static final String BD_MATERIAL_CREATETIME = "material_createtime";
        public static final String BD_MATERIAL_VOLUME = "material_volume";
        private static final long[] CURRENCYIDS = new long[]{1L, 2L, 3L, 7L, 8L};
        private static final long[] MATERIALIDS = new long[]{346149301916796928L, 346149503897700352L, 346149661830024192L, 346149991837861888L, 346150116148643840L};
        private static final long[] PUR_MATERIALIDS = new long[]{601838096362769408L, 601838701265292288L, 601838899278382080L, 601837507356658688L, 604889377704794112L};
        private static final long[] UNITIDS = new long[]{2L, 307799561337060352L, 307799689833634816L, 5L, 10L};
        private static final long[] SUPPLIERS = new long[]{346159251409862656L, 346159428292050944L, 346159755422597120L, 346159919512159232L, 383185833244491776L};
        private static final long[] ACCOUNTIDS = new long[]{445334648793369600L, 445334737041502208L, 445336530869848064L, 445335056739765248L, 445335750116936704L};
        private static final long ACCOUNTID_ITEMS = 1531050300532595712L;
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private int rowCount = 500;

        public int getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public List<ReportColumn> createColumns() {
            ArrayList<AbstractReportColumn> abstractCols = new ArrayList<AbstractReportColumn>(0);
            this.createColumns(abstractCols);
            ArrayList<ReportColumn> columns = new ArrayList<ReportColumn>(abstractCols.size());
            for (AbstractReportColumn col : abstractCols) {
                columns.add((ReportColumn)col);
            }
            return columns;
        }

        public List<AbstractReportColumn> createColumns(List<AbstractReportColumn> columns) {
            ArrayList<Object> comboItems;
            HashSet<String> keys = new HashSet<String>(columns.size());
            this.findColKeys(columns, keys);
            if (!keys.contains(LONG_ROWKEY)) {
                // empty if block
            }
            if (!keys.contains(TEXT_BILLNO)) {
                columns.add(DemoDataSet.buildTextColumn(TEXT_BILLNO, "\u5355\u636e\u7f16\u53f7", null));
            }
            if (!keys.contains(COMBO_BILLSTATUS)) {
                comboItems = new ArrayList<ComboItem>(3);
                comboItems.add(new ComboItem(new LocaleString("\u6682\u5b58"), "A"));
                comboItems.add(new ComboItem(new LocaleString("\u5df2\u63d0\u4ea4"), "B"));
                comboItems.add(new ComboItem(new LocaleString("\u5df2\u5ba1\u6838"), "C"));
                columns.add(DemoDataSet.buildComboColumn(COMBO_BILLSTATUS, "\u5355\u636e\u72b6\u6001", comboItems, null));
            }
            if (!keys.contains(DATE_BIZDATE)) {
                columns.add(DemoDataSet.buildDateColumn(DATE_BIZDATE, "\u4e1a\u52a1\u65e5\u671f", null));
            }
            if (!keys.contains(DATETIME_CREATETIME)) {
                columns.add(DemoDataSet.buildDateTimeColumn(DATETIME_CREATETIME, "\u521b\u5efa\u65f6\u95f4", null));
            }
            if (!keys.contains(TIME_BEGINTIME)) {
                columns.add(DemoDataSet.buildIntColumn(TIME_BEGINTIME, "\u5f00\u59cb\u65f6\u95f4", null));
            }
            if (!keys.contains(INT_AGE)) {
                columns.add(DemoDataSet.buildIntColumn(INT_AGE, "\u5e74\u7eaa", null));
            }
            if (!keys.contains(NUM_RECORD)) {
                columns.add(DemoDataSet.buildDecimalColumn(NUM_RECORD, "\u8bb0\u5f55", null));
            }
            if (!keys.contains(PIC_USERHEAD)) {
                columns.add(DemoDataSet.buildPicutureColumn(PIC_USERHEAD, "\u521b\u5efa\u4eba", null));
            }
            if (!keys.contains(MULCOMBO_CONVERTTYPE)) {
                comboItems = new ArrayList(3);
                comboItems.add(new ComboItem(new LocaleString("\u4e00\u5bf9\u4e00"), "0"));
                comboItems.add(new ComboItem(new LocaleString("\u591a\u5bf9\u4e00"), "1"));
                comboItems.add(new ComboItem(new LocaleString("\u6309\u89c4\u5219\u5408\u5e76"), "2"));
                columns.add(DemoDataSet.buildMulComboColumn(MULCOMBO_CONVERTTYPE, "\u5408\u5e76\u65b9\u5f0f", comboItems, null));
            }
            if (!keys.contains(CHECK_ENABLE)) {
                columns.add(DemoDataSet.buildBooleanColumn(CHECK_ENABLE, "\u542f\u7528", null));
            }
            if (!keys.contains(BD_CURRENCY)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_CURRENCY, "\u5e01\u522b", "bd_currency", "name", null));
            }
            if (!keys.contains(BD_MATERIAL)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_MATERIAL, "\u4e3b\u7269\u6599", "bd_material", "name", null));
            }
            if (!keys.contains(BD_MATERIAL_NUMBER)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_NUMBER, "\u4e3b\u7269\u6599_\u7f16\u7801", BD_MATERIAL, "number", null));
            }
            if (!keys.contains(BD_MATERIAL_BASEUNIT)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_BASEUNIT, "\u4e3b\u7269\u6599_\u57fa\u672c\u5355\u4f4d", BD_MATERIAL, "baseunit", null));
            }
            if (!keys.contains(BD_MATERIAL_STATUE)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_STATUE, "\u4e3b\u7269\u6599_\u72b6\u6001", BD_MATERIAL, "status", null));
            }
            if (!keys.contains(BD_MATERIAL_ENABLEPUR)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_ENABLEPUR, "\u4e3b\u7269\u6599_\u53ef\u91c7\u8d2d", BD_MATERIAL, "enablepur", null));
            }
            if (!keys.contains(BD_MATERIAL_CREATETIME)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_CREATETIME, "\u4e3b\u7269\u6599_\u521b\u5efa\u65f6\u95f4", BD_MATERIAL, DATETIME_CREATETIME, null));
            }
            if (!keys.contains(BD_MATERIAL_VOLUME)) {
                columns.add(DemoDataSet.buildBasedataPropColumn(BD_MATERIAL_VOLUME, "\u4e3b\u7269\u6599_\u4f53\u79ef", BD_MATERIAL, "volume", null));
            }
            if (!keys.contains(BD_PURMATERAIL)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_PURMATERAIL, "\u91c7\u8d2d\u653f\u7b56", "bd_materialpurchaseinfo", "name", null));
            }
            if (!keys.contains(BD_UNIT)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_UNIT, "\u5355\u4f4d", "bd_measureunits", "number", null));
            }
            if (!keys.contains(QTY)) {
                columns.add(DemoDataSet.buildQtyColumn(QTY, "\u6570\u91cf", BD_UNIT, null));
            }
            if (!keys.contains(PRICE)) {
                columns.add(DemoDataSet.buildPriceColumn(PRICE, "\u5355\u4ef7", BD_CURRENCY, null));
            }
            if (!keys.contains(AMOUNT)) {
                columns.add(DemoDataSet.buildAmountColumn(AMOUNT, "\u91d1\u989d", BD_CURRENCY, null));
            }
            if (!keys.contains(BD_ACCOUNT)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_ACCOUNT, "\u79d1\u76ee", "bd_accountview", "name", null));
            }
            if (!keys.contains(FLEX_ITME)) {
                columns.add(DemoDataSet.buildFlexColumn(FLEX_ITME, "\u6838\u7b97\u7ef4\u5ea6", BD_ACCOUNT, 2, null));
            }
            if (!keys.contains(MULBD_CURRENCY)) {
                columns.add(DemoDataSet.buildMulBasedataColumn(MULBD_CURRENCY, "\u591a\u9009\u5e01\u522b", "bd_currency", "name", null));
            }
            if (!keys.contains(ITEMTYPE_CONTACTTYPE)) {
                comboItems = new ArrayList(3);
                comboItems.add(new ComboItem(new LocaleString("\u5ba2\u6237"), "bd_customer"));
                comboItems.add(new ComboItem(new LocaleString("\u4f9b\u5e94\u5546"), "bd_supplier"));
                columns.add(DemoDataSet.buildItemTypeColumn(ITEMTYPE_CONTACTTYPE, "\u8054\u7cfb\u4eba\u7c7b\u578b", comboItems, null));
            }
            if (!keys.contains(ITEMCLASS_CONTACT)) {
                columns.add(DemoDataSet.buildItemClassColumn(ITEMCLASS_CONTACT, "\u8054\u7cfb\u4eba", ITEMTYPE_CONTACTTYPE, "name", null));
            }
            if (!keys.contains(COMBO_CONVERTTYPE)) {
                comboItems = new ArrayList(3);
                comboItems.add(new ComboItem(new LocaleString("\u4e00\u5bf9\u4e00"), "0"));
                comboItems.add(new ComboItem(new LocaleString("\u591a\u5bf9\u4e00"), "1"));
                comboItems.add(new ComboItem(new LocaleString("\u6309\u89c4\u5219\u5408\u5e76"), "2"));
                columns.add(DemoDataSet.buildComboColumn(COMBO_CONVERTTYPE, "\u4e0b\u62c9\u9009\u9879", comboItems, null));
            }
            return columns;
        }

        private void findColKeys(List<AbstractReportColumn> columns, Set<String> keys) {
            if (columns == null || columns.isEmpty()) {
                return;
            }
            for (AbstractReportColumn col : columns) {
                if (col instanceof ReportColumn) {
                    keys.add(((ReportColumn)col).getFieldKey());
                }
                if (!(col instanceof ReportColumnGroup)) continue;
                this.findColKeys(((ReportColumnGroup)col).getChildren(), keys);
            }
        }

        public DataSet createDataSet() {
            String algoKey = this.getClass().getName() + "#create";
            Input input = this.createCollInput();
            return Algo.create((String)algoKey).createDataSet(new Input[]{input});
        }

        private Input createCollInput() {
            Field field_Id = new Field(LONG_ROWKEY, (DataType)DataType.LongType);
            Field field_billno = new Field(TEXT_BILLNO, (DataType)DataType.StringType);
            Field field_billstatus = new Field(COMBO_BILLSTATUS, (DataType)DataType.StringType);
            Field field_bizdate = new Field(DATE_BIZDATE, (DataType)DataType.DateType);
            Field field_createtime = new Field(DATETIME_CREATETIME, (DataType)DataType.DateType);
            Field field_begintime = new Field(TIME_BEGINTIME, (DataType)DataType.IntegerType);
            Field field_age = new Field(INT_AGE, (DataType)DataType.IntegerType);
            Field field_record = new Field(NUM_RECORD, (DataType)DataType.BigDecimalType);
            Field field_userhead = new Field(PIC_USERHEAD, (DataType)DataType.StringType);
            Field field_converttype = new Field(MULCOMBO_CONVERTTYPE, (DataType)DataType.StringType);
            Field field_enable = new Field(CHECK_ENABLE, (DataType)DataType.BooleanType);
            Field field_currency = new Field(BD_CURRENCY, (DataType)DataType.LongType);
            Field field_material = new Field(BD_MATERIAL, (DataType)DataType.LongType);
            Field field_purmaterial = new Field(BD_PURMATERAIL, (DataType)DataType.LongType);
            Field field_unit = new Field(BD_UNIT, (DataType)DataType.LongType);
            Field field_qty = new Field(QTY, (DataType)DataType.BigDecimalType);
            Field field_price = new Field(PRICE, (DataType)DataType.BigDecimalType);
            Field field_amount = new Field(AMOUNT, (DataType)DataType.BigDecimalType);
            Field field_account = new Field(BD_ACCOUNT, (DataType)DataType.LongType);
            Field field_item = new Field(FLEX_ITME, (DataType)DataType.LongType);
            Field field_mulcurrency = new Field(MULBD_CURRENCY, (DataType)DataType.LongType);
            Field field_contacttype = new Field(ITEMTYPE_CONTACTTYPE, (DataType)DataType.StringType);
            Field field_contact = new Field(ITEMCLASS_CONTACT, (DataType)DataType.LongType);
            Field field_combo = new Field(COMBO_CONVERTTYPE, (DataType)DataType.StringType);
            RowMeta rowMeta = new RowMeta(new Field[]{field_Id, field_billno, field_billstatus, field_bizdate, field_createtime, field_begintime, field_age, field_record, field_userhead, field_converttype, field_enable, field_currency, field_material, field_purmaterial, field_unit, field_qty, field_price, field_amount, field_account, field_item, field_mulcurrency, field_contacttype, field_contact, field_combo});
            ArrayList<Object[]> rows = new ArrayList<Object[]>(500);
            long id = 1L;
            int loopTime = this.getRowCount() / 5;
            if (loopTime <= 0) {
                loopTime = 1;
            } else if (loopTime > 20000) {
                loopTime = 20000;
            }
            Date currDate = new Date();
            for (int i = 0; i < 5; ++i) {
                String convType;
                String billStatus = i == 0 ? "A" : (i == 1 ? "B" : "C");
                Date bizDate = this.createDate(currDate, i);
                Date createTime = this.createDateTime(currDate, i);
                int time = 360 + i * 60 * 60;
                int age = 30 + i;
                String userpicture = "";
                String string = i == 0 ? ",0,1," : (convType = i == 1 ? ",1,2" : "0,2,");
                String combo = i == 0 ? "0" : (i == 1 ? "1" : "2");
                boolean enable = i != 0;
                long currency = CURRENCYIDS[i];
                long material = MATERIALIDS[i];
                long purMaterial = PUR_MATERIALIDS[i];
                long unit = UNITIDS[i];
                BigDecimal qty = new BigDecimal("1.0000000000");
                BigDecimal price = new BigDecimal("100.0000000000");
                BigDecimal amount = new BigDecimal("100.0000000000");
                long account = ACCOUNTIDS[i];
                long itemId = 0L;
                long mulCurrency = 0L;
                for (int j = 0; j < loopTime; ++j) {
                    String billNo = "TEST-" + String.valueOf(100000000L + id).substring(1);
                    BigDecimal record = new BigDecimal(id);
                    String contacttype = j / 2 == 0 ? "bd_customer" : "bd_supplier";
                    long contact = j / 2 == 0 ? 0L : SUPPLIERS[i];
                    Object[] row = new Object[]{id, billNo, billStatus, bizDate, createTime, time, age, record, userpicture, convType, enable, currency, material, purMaterial, unit, qty, price, amount, account, itemId, mulCurrency, contacttype, contact, combo};
                    rows.add(row);
                    ++id;
                }
            }
            CollectionInput input = new CollectionInput(rowMeta, rows);
            return input;
        }

        private Date createDate(Date date, int type) {
            try {
                Date currDate = this.createDateTime(date, type);
                String str = dateFormat.format(currDate);
                return dateFormat.parse(str);
            }
            catch (ParseException exp) {
                return null;
            }
        }

        private Date createDateTime(Date date, int type) {
            if (type == 0) {
                return date;
            }
            if (type == 1) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, 1);
                return calendar.getTime();
            }
            if (type == 2) {
                return this.getLastMonth(date, -1);
            }
            return this.getLastMonth(date, -3);
        }

        private Date getLastMonth(Date date, int month) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(2, month);
            return c.getTime();
        }

        public static AbstractReportColumn buildTextColumn(String fieldKey, String caption, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("text");
            return col;
        }

        public static AbstractReportColumn buildIntColumn(String fieldKey, String caption, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("integer");
            col.setSummary(0);
            col.setNoDisplayScaleZero(true);
            return col;
        }

        public static AbstractReportColumn buildBigIntColumn(String fieldKey, String caption, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("bigint");
            col.setSummary(0);
            col.setNoDisplayScaleZero(true);
            return col;
        }

        public static AbstractReportColumn buildDecimalColumn(String fieldKey, String caption, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("decimal");
            col.setSummary(1);
            col.setNoDisplayScaleZero(false);
            return col;
        }

        public static AbstractReportColumn buildPriceColumn(String fieldKey, String caption, String currField, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType(PRICE);
            col.setSummary(0);
            col.setNoDisplayScaleZero(false);
            col.setCurrencyField(currField);
            return col;
        }

        public static AbstractReportColumn buildAmountColumn(String fieldKey, String caption, String currField, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType(AMOUNT);
            col.setSummary(1);
            col.setNoDisplayScaleZero(false);
            col.setCurrencyField(currField);
            return col;
        }

        public static AbstractReportColumn buildQtyColumn(String fieldKey, String caption, String unitField, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType(QTY);
            col.setSummary(1);
            col.setNoDisplayScaleZero(false);
            col.setMeasureUnitField(unitField);
            return col;
        }

        public static AbstractReportColumn buildDateColumn(String fieldKey, String caption, Map<String, Object> option) {
            DateTimeReportColumn col = new DateTimeReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("date");
            col.setMask("yyyy-MM-dd");
            return col;
        }

        public static AbstractReportColumn buildDateTimeColumn(String fieldKey, String caption, Map<String, Object> option) {
            DateTimeReportColumn col = new DateTimeReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("date");
            col.setMask("yyyy-MM-dd HH:mm:ss");
            return col;
        }

        public static AbstractReportColumn buildBooleanColumn(String fieldKey, String caption, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("checkbox");
            col.setXTitleReport("\u662f");
            col.setOTitleReport("\u5426");
            return col;
        }

        public static AbstractReportColumn buildComboColumn(String fieldKey, String caption, List<ComboItem> items, Map<String, Object> option) {
            ComboReportColumn col = new ComboReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("combofield");
            ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
            for (ComboItem item : items) {
                ValueMapItem valueMapItem = new ValueMapItem(item.getImageKey(), item.getValue(), item.getCaption());
                valueItems.add(valueMapItem);
            }
            col.setComboItems(valueItems);
            return col;
        }

        public static AbstractReportColumn buildStatusColumn(String fieldKey, String caption, List<ComboItem> items, Map<String, Object> option) {
            return DemoDataSet.buildComboColumn(fieldKey, caption, items, option);
        }

        public static AbstractReportColumn buildMulComboColumn(String fieldKey, String caption, List<ComboItem> items, Map<String, Object> option) {
            MulComboReportColumn col = new MulComboReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("combofield");
            ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
            for (ComboItem item : items) {
                ValueMapItem valueMapItem = new ValueMapItem(item.getImageKey(), item.getValue(), item.getCaption());
                valueItems.add(valueMapItem);
            }
            col.setComboItems(valueItems);
            return col;
        }

        public static AbstractReportColumn buildBasedataColumn(String fieldKey, String caption, String refType, String dispProp, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("basedata");
            col.setEntityId(refType);
            col.setDisplayProp(dispProp);
            return col;
        }

        public static AbstractReportColumn buildBasedataPropColumn(String fieldKey, String caption, String bdColKey, String dispProp, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setRefBasedataProp(bdColKey);
            col.setDisplayProp(dispProp);
            return col;
        }

        public static AbstractReportColumn buildMulBasedataColumn(String fieldKey, String caption, String refType, String dispProp, Map<String, Object> option) {
            return DemoDataSet.buildTextColumn(fieldKey, caption, option);
        }

        public static AbstractReportColumn buildItemTypeColumn(String fieldKey, String caption, List<ComboItem> items, Map<String, Object> option) {
            return DemoDataSet.buildComboColumn(fieldKey, caption, items, option);
        }

        public static AbstractReportColumn buildItemClassColumn(String fieldKey, String caption, String itemTypeField, String dispProp, Map<String, Object> option) {
            return DemoDataSet.buildTextColumn(fieldKey, caption, option);
        }

        public static AbstractReportColumn buildPicutureColumn(String fieldKey, String caption, Map<String, Object> option) {
            PictureReportColumn col = new PictureReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("picture");
            col.setPicture(true);
            col.setEntryLockPreview(true);
            return col;
        }

        public static AbstractReportColumn buildFlexColumn(String fieldKey, String caption, String refBasedataField, int flexType, Map<String, Object> option) {
            return DemoDataSet.buildTextColumn(fieldKey, caption, option);
        }
    }
}

