/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.report.queryplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;

public class DemoBigDataRptListDataPlugin
extends AbstractReportListDataPlugin {
    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(1000);
        byBatchInfo.setMaxRowCountCached(20000);
        DemoDataSet demoDataSet = new DemoDataSet();
        demoDataSet.setRowCount(20000);
        return demoDataSet.createBatchByDataSet();
    }

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        List currentBatchRows = byBatchInfo.getCurrentBatchRows();
        DemoDataSet demoDataSet = new DemoDataSet();
        return demoDataSet.createDetailDataSet(currentBatchRows);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        return demoDataSet.createColumns(columns);
    }

    public static class DemoDataSet {
        public static final String LONG_ROWKEY = "rowkey";
        public static final String TEXT_BILLNO = "billno";
        public static final String QTY_QTY = "qty";
        private int rowCount = 10000;

        public int getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public List<ReportColumn> createColumns() {
            ArrayList<AbstractReportColumn> abstractCols = new ArrayList<AbstractReportColumn>(0);
            this.createColumns(abstractCols);
            ArrayList<ReportColumn> columns = new ArrayList<ReportColumn>(abstractCols.size());
            for (AbstractReportColumn col : abstractCols) {
                columns.add((ReportColumn)col);
            }
            return columns;
        }

        public List<AbstractReportColumn> createColumns(List<AbstractReportColumn> columns) {
            HashSet<String> keys = new HashSet<String>(columns.size());
            for (AbstractReportColumn col : columns) {
                if (!(col instanceof ReportColumn)) continue;
                keys.add(((ReportColumn)col).getFieldKey());
            }
            if (!keys.contains(LONG_ROWKEY)) {
                // empty if block
            }
            if (!keys.contains(TEXT_BILLNO)) {
                columns.add(DemoDataSet.buildTextColumn(TEXT_BILLNO, "\u5355\u636e\u7f16\u53f7", null));
            }
            if (!keys.contains(QTY_QTY)) {
                columns.add(DemoDataSet.buildDecimalColumn(QTY_QTY, "\u6570\u91cf", null));
            }
            return columns;
        }

        public DataSet createBatchByDataSet() {
            Field field_Id = new Field(LONG_ROWKEY, (DataType)DataType.LongType);
            RowMeta rowMeta = new RowMeta(new Field[]{field_Id});
            ArrayList<Object[]> rows = new ArrayList<Object[]>(this.rowCount);
            long id = 1L;
            for (int i = 0; i < this.rowCount; ++i) {
                Object[] row = new Object[]{id};
                rows.add(row);
                ++id;
            }
            String algoKey = this.getClass().getName() + "#createBatchByDataSet";
            return Algo.create((String)algoKey).createDataSet(rows, rowMeta);
        }

        public DataSet createDetailDataSet(List<Row> currentBatchRows) {
            Field field_Id = new Field(LONG_ROWKEY, (DataType)DataType.LongType);
            Field field_billNo = new Field(TEXT_BILLNO, (DataType)DataType.StringType);
            Field field_qty = new Field(QTY_QTY, (DataType)DataType.BigDecimalType);
            RowMeta rowMeta = new RowMeta(new Field[]{field_Id, field_billNo, field_qty});
            ArrayList<Object[]> rows = new ArrayList<Object[]>(this.rowCount);
            BigDecimal qty = new BigDecimal("1.00");
            if (currentBatchRows != null && !currentBatchRows.isEmpty()) {
                for (Row batchRow : currentBatchRows) {
                    Long id = batchRow.getLong(0);
                    String billNo = "TEST-" + String.valueOf(100000000L + id).substring(1);
                    Object[] row = new Object[]{id, billNo, qty};
                    rows.add(row);
                }
            } else {
                Object[] row = new Object[]{0L, "\u672a\u5206\u6279"};
                rows.add(row);
            }
            String algoKey = this.getClass().getName() + "#createDetailDataSet";
            return Algo.create((String)algoKey).createDataSet(rows, rowMeta);
        }

        public static AbstractReportColumn buildTextColumn(String fieldKey, String caption, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("text");
            return col;
        }

        public static AbstractReportColumn buildDecimalColumn(String fieldKey, String caption, Map<String, Object> option) {
            DecimalReportColumn col = new DecimalReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("decimal");
            col.setSummary(1);
            col.setNoDisplayScaleZero(false);
            return col;
        }
    }
}

