/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.report.queryplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;

public class DemoGroupRptLeftListDataPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        return demoDataSet.createDataSet();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        return demoDataSet.createColumns(columns);
    }

    public static class DemoDataSet {
        public static final String LONG_ROWKEY = "rowkey";
        public static final String BD_ORG = "org";
        private static final long[] ORG_IDS = new long[]{100000L, 486095482586692608L, 1L, 40L, 45L};

        public List<ReportColumn> createColumns() {
            ArrayList<AbstractReportColumn> abstractCols = new ArrayList<AbstractReportColumn>(0);
            this.createColumns(abstractCols);
            ArrayList<ReportColumn> columns = new ArrayList<ReportColumn>(abstractCols.size());
            for (AbstractReportColumn col : abstractCols) {
                columns.add((ReportColumn)col);
            }
            return columns;
        }

        public List<AbstractReportColumn> createColumns(List<AbstractReportColumn> columns) {
            HashSet<String> keys = new HashSet<String>(columns.size());
            for (AbstractReportColumn col : columns) {
                if (!(col instanceof ReportColumn)) continue;
                keys.add(((ReportColumn)col).getFieldKey());
            }
            if (!keys.contains(LONG_ROWKEY)) {
                // empty if block
            }
            if (!keys.contains(BD_ORG)) {
                columns.add(DemoDataSet.buildBasedataColumn(BD_ORG, "\u7ec4\u7ec7", "bos_org", "name", null));
            }
            return columns;
        }

        public DataSet createDataSet() {
            String algoKey = this.getClass().getName() + "#create";
            Input input = this.createCollInput();
            return Algo.create((String)algoKey).createDataSet(new Input[]{input});
        }

        private Input createCollInput() {
            Field field_Id = new Field(LONG_ROWKEY, (DataType)DataType.LongType);
            Field field_org = new Field(BD_ORG, (DataType)DataType.LongType);
            RowMeta rowMeta = new RowMeta(new Field[]{field_Id, field_org});
            ArrayList<Object[]> rows = new ArrayList<Object[]>(500);
            long id = 1L;
            for (int i = 0; i < 5; ++i) {
                Object[] row = new Object[]{id, ORG_IDS[i]};
                rows.add(row);
                ++id;
            }
            CollectionInput input = new CollectionInput(rowMeta, rows);
            return input;
        }

        public static AbstractReportColumn buildBasedataColumn(String fieldKey, String caption, String refType, String dispProp, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("basedata");
            col.setEntityId(refType);
            col.setDisplayProp(dispProp);
            return col;
        }
    }
}

