/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.report.queryplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.plugin.sample.report.queryplugin.DemoGroupRptRightListDataPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DemoTreeRptRightListDataPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DemoDataSet demoDataSet = new DemoDataSet();
        if (selectedObj instanceof DynamicObject) {
            demoDataSet.setOrgId((Long)((DynamicObject)selectedObj).getPkValue());
        }
        return demoDataSet.createDataSet();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        DemoGroupRptRightListDataPlugin.DemoDataSet demoDataSet = new DemoGroupRptRightListDataPlugin.DemoDataSet();
        return demoDataSet.createColumns(columns);
    }

    public static class DemoDataSet {
        public static final String LONG_ROWKEY = "rowkey";
        public static final String TEXT_ORGNUMBER = "orgnumber";
        private Long orgId = 0L;

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public List<ReportColumn> createColumns() {
            ArrayList<AbstractReportColumn> abstractCols = new ArrayList<AbstractReportColumn>(0);
            this.createColumns(abstractCols);
            ArrayList<ReportColumn> columns = new ArrayList<ReportColumn>(abstractCols.size());
            for (AbstractReportColumn col : abstractCols) {
                columns.add((ReportColumn)col);
            }
            return columns;
        }

        public List<AbstractReportColumn> createColumns(List<AbstractReportColumn> columns) {
            HashSet<String> keys = new HashSet<String>(columns.size());
            for (AbstractReportColumn col : columns) {
                if (!(col instanceof ReportColumn)) continue;
                keys.add(((ReportColumn)col).getFieldKey());
            }
            if (!keys.contains(LONG_ROWKEY)) {
                // empty if block
            }
            if (!keys.contains(TEXT_ORGNUMBER)) {
                columns.add(DemoDataSet.buildTextColumn(TEXT_ORGNUMBER, "\u7ec4\u7ec7\u5185\u7801", null));
            }
            return columns;
        }

        public DataSet createDataSet() {
            DynamicObject org;
            Field field_Id = new Field(LONG_ROWKEY, (DataType)DataType.LongType);
            Field field_orgNumber = new Field(TEXT_ORGNUMBER, (DataType)DataType.StringType);
            RowMeta rowMeta = new RowMeta(new Field[]{field_Id, field_orgNumber});
            ArrayList<Object[]> rows = new ArrayList<Object[]>(500);
            long id = 1L;
            String orgNumber = String.valueOf(this.getOrgId());
            if (this.getOrgId() != null && Long.compare(0L, this.getOrgId()) != 0 && (org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getOrgId())})) != null) {
                orgNumber = org.getString("number");
            }
            Object[] row = new Object[]{id, orgNumber};
            rows.add(row);
            String algoKey = this.getClass().getName() + "#create";
            return Algo.create((String)algoKey).createDataSet(rows, rowMeta);
        }

        public static AbstractReportColumn buildTextColumn(String fieldKey, String caption, Map<String, Object> option) {
            ReportColumn col = new ReportColumn();
            col.setFieldKey(fieldKey);
            col.setCaption(new LocaleString(caption));
            col.setFieldType("text");
            return col;
        }
    }
}

