/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.schedule;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.server.JobDispatcherProxy;

public class CreateJobPlanPlugIn
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("kdtest_createplan")) {
            JobDispatcherProxy proxy = new JobDispatcherProxy();
            JobInfo jobInfo = this.getJobInfo();
            proxy.dispatch(jobInfo);
            PlanInfo planInfo = this.getPlanInfo(jobInfo);
            proxy.createPlan(planInfo);
        }
    }

    private JobInfo getJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.BIZ);
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        jobInfo.setName("pjf\u63d2\u4ef6\u4f5c\u4e1a_" + sf.format(now));
        jobInfo.setNumber("kdf_job_pjf_p_" + sf.format(now));
        jobInfo.setTaskClassname("kd.bos.plugin.sample.schedule.KDFLogTask");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("time", 10);
        jobInfo.setParams(params);
        return jobInfo;
    }

    private PlanInfo getPlanInfo(JobInfo jobInfo) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobInfo.getId());
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date now = new Date();
        planInfo.setName("pjf\u63d2\u4ef6\u8ba1\u5212_" + sf.format(now));
        planInfo.setNumber("kdf_plan_pjf_p_" + sf.format(now));
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(new Date(now.getTime() + 60000L));
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(new Date(now.getTime() + 300000L));
        planInfo.setStartTime(startCalendar);
        planInfo.setEndTime(endCalendar);
        planInfo.setRepeatMode(RepeatModeEnum.NONE);
        planInfo.setCronExpression("0 0 0 * * ?");
        return planInfo;
    }
}

