/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.plugin.sample.schedule;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.bos.schedule.api.StopTask;
import kd.bos.schedule.executor.AbstractTask;

public class MyTask
extends AbstractTask
implements StopTask {
    private static final Log log = LogFactory.getLog(MyTask.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        Object skipTask = params.get("skipTask");
        if (skipTask instanceof String && StringUtils.endsWithIgnoreCase((String)((String)skipTask), (String)"true")) {
            throw new KDException(new ErrorCode("TASK_SKIP", "\u8df3\u8fc7\u4efb\u52a1\u6267\u884c"), new Object[0]);
        }
        Object taskStatusObj = params.get("taskStatus");
        if (taskStatusObj instanceof String) {
            String taskStatus;
            switch (taskStatus = (String)taskStatusObj) {
                case "skipTask": {
                    throw new KDException(new ErrorCode("TASK_SKIP", "\u8df3\u8fc7\u4efb\u52a1\u6267\u884c"), new Object[0]);
                }
                case "abortTask": {
                    this.stop();
                    break;
                }
                case "timeoutTask": {
                    throw new KDException(new ErrorCode("TASK_TIMEOUT", "\u4efb\u52a1\u8d85\u65f6"), new Object[0]);
                }
                case "failTask": {
                    throw new KDException("\u4efb\u52a1\u5931\u8d25\u6d4b\u8bd5");
                }
            }
        }
        this.feedbackProgress(0, "\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", null);
        int time = 20;
        if (params.containsKey("time")) {
            time = (Integer)params.get("time");
        }
        if (time > 100 || time <= 0) {
            throw new KDBizException("\u8bbe\u7f6e\u7684\u6b21\u6570\u4e0d\u5408\u7406\uff0c\u5408\u7406\u8303\u56f4\u662f[1,100]");
        }
        try {
            int progress = 0;
            for (int i = 0; i < time; ++i) {
                String desc = String.format("\u5f00\u59cb\u8fdb\u884c\u7b2c  %s / %s \u6b21\u5faa\u73af", i + 1, time);
                progress = 100 * i / time;
                this.feedbackProgress(progress, desc, null);
                if (this.isStop()) {
                    this.stop();
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("success", "true");
        this.feedbackCustomdata(result);
    }
}

