/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.model;

import kd.bos.ai.model.NumberCardModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.ai.model.UiNameModel;
import kd.bos.ai.model.UrlModel;

public class ResponseModel {
    private String type;
    private Object content;

    private ResponseModel(String type, Object content) {
        this.type = type;
        this.content = content;
    }

    public static ResponseModel createTextResponse(String content) {
        return new ResponseModel(Type.TEXT.toString(), content);
    }

    public static ResponseModel createSelectsResponse(SelectsModel selects) {
        return new ResponseModel(Type.SELECTS.toString(), selects);
    }

    public static ResponseModel createUrlResponse(UrlModel urlModel) {
        return new ResponseModel(Type.URL.toString(), urlModel);
    }

    public static ResponseModel createNumberCardResponse(NumberCardModel numberCardModel) {
        return new ResponseModel(Type.NUMBER_CARD.toString(), numberCardModel);
    }

    public static ResponseModel createUiNameResponse(UiNameModel uiNameModel) {
        return new ResponseModel(Type.UI_NAME.toString(), uiNameModel);
    }

    public String getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public static enum Type {
        TEXT,
        SELECTS,
        URL,
        NUMBER_CARD,
        UI_NAME;

    }
}

