/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ai.model.AICommandType;
import kd.bos.ai.model.CommandModel;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UiNameModel;
import kd.bos.ai.util.AICommandUtil;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SessionQuery;

public class BillNoSearchPlugin
extends AbstractBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(BillNoSearchPlugin.class);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void doAICommand(AICommandEvent e) {
        Map parameter = e.getCommand().getParameter();
        String billNo = (String)parameter.get("billNo");
        String formId = (String)parameter.get("formId");
        String pkId = (String)parameter.get("pkId");
        String limit = (String)parameter.get("billNoSearchLimit");
        List<Object> newBillNoDtos = new ArrayList();
        boolean hasError = false;
        Object data = null;
        ApiResult ret = null;
        try {
            newBillNoDtos = this.queryBillByNo(formId, billNo, pkId);
        }
        catch (Exception e1) {
            hasError = true;
            log.error((Throwable)e1);
            e.setResult(ApiResult.ex((Throwable)e1));
        }
        if (hasError) {
            log.info(String.format("\u5c0fK\u5355\u636e\u7f16\u53f7\u641c\u7d22\uff1a \u4f20\u53c2 %s %s %s", billNo, formId, limit));
            return;
        }
        if (newBillNoDtos.isEmpty()) {
            ret = ApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5355\u636e", (String)"BillNoSearchPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else if (newBillNoDtos.size() == 1) {
            this.sendOpenFormAICommand(parameter, newBillNoDtos, formId);
            ret = ApiResult.success((Object)this.formMutiData(newBillNoDtos, formId));
        } else {
            ret = ApiResult.success((Object)this.formMutiData(newBillNoDtos, formId));
        }
        e.setResult(ret);
        log.info("\u5c0fK\u5355\u636e\u7f16\u53f7\u641c\u7d22\uff1a \u4f20\u53c2 {} {} {}, \u5c0fK\u5355\u636e\u7f16\u53f7\u641c\u7d22\u7ed3\u679c\u5982\u4e0b\uff1a{}", new Object[]{billNo, formId, limit, SerializationUtils.toJsonString(newBillNoDtos)});
    }

    private List<Map<String, Object>> queryBillByNo(String formId, String billNo, String pkId) {
        ArrayList<Map<String, Object>> newBillNoDtos = new ArrayList<Map<String, Object>>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        if (!(dt instanceof BillEntityType)) {
            throw new KDException(ResManager.loadKDString((String)"\u975e\u5355\u636e\u7c7b\u578b\u7684\u8868\u5355", (String)"BillNoSearchPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        BillEntityType billEntityType = (BillEntityType)dt;
        QFilter[] filters = new QFilter[1];
        String billNoField = billEntityType.getBillNo();
        filters[0] = StringUtils.isBlank((CharSequence)pkId) ? new QFilter(billNoField, "like", (Object)("%" + billNo + "%")) : new QFilter("id", "=", (Object)pkId);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)formId, (String)("id," + billNoField), (QFilter[])filters, null);
        for (DynamicObject bill : bills) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pkId", bill.getString("Id"));
            map.put("billNo", bill.getString(billNoField));
            newBillNoDtos.add(map);
        }
        return newBillNoDtos;
    }

    private void sendOpenFormAICommand(Map<String, Object> parameter, List<Map<String, Object>> newBillNoDtos, String formId) {
        long aitokenStart = System.currentTimeMillis();
        String aitoken = this.getAIToken(parameter);
        long aitokenEnd = System.currentTimeMillis();
        CommandModel command = new CommandModel();
        command.setType(AICommandType.OPEN_MENU.getCommand());
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("pkId", newBillNoDtos.get(0).get("pkId"));
        para.put("formId", formId);
        command.setPara(para);
        if (StringUtils.isBlank((CharSequence)aitoken)) {
            long getUserSessionsStart = System.currentTimeMillis();
            RequestContext requestContext = RequestContext.get();
            List sessionIds = SessionQuery.getUserSessions((String)requestContext.getAccountId(), (String)requestContext.getUserId());
            long getUserSessionsEnd = System.currentTimeMillis();
            for (String id : sessionIds) {
                AICommandUtil.sendOpenMenuCommand(id, command);
            }
            long sendOpenMenuCommandEnd = System.currentTimeMillis();
            log.info("getAiTokenFromCache take times:{}, aitoken==null || aitoken.isEmpty() = true, getUserSessions take times: {}, sessionids len {}, sendOpenMenuCommand take times: {}", new Object[]{aitokenEnd - aitokenStart, getUserSessionsEnd - getUserSessionsStart, sessionIds.size(), sendOpenMenuCommandEnd - getUserSessionsEnd});
            return;
        }
        log.info("getAiTokenFromCache take times:{}, aitoken==null || aitoken.isEmpty() = false", (Object)(aitokenEnd - aitokenStart));
        AICommandUtil.sendOpenMenuCommand(aitoken, command);
    }

    private ResponseModel formMutiData(List<Map<String, Object>> newBillNoDtos, String formId) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)formId);
        String number = dt.getAppId();
        if (StringUtils.isEmpty((CharSequence)number)) {
            log.warn("formId:" + formId + " \u5e94\u7528\u7f16\u7801\u4e3a\u7a7a\uff1a" + number);
        }
        String bizAppId = StringUtils.isEmpty((CharSequence)number) ? "" : AppReader.getAppIdByNumber((String)number);
        Map bizappMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{bizAppId}, (String)"bos_devportal_bizapp");
        DynamicObject bizAppObj = (DynamicObject)bizappMap.get(bizAppId);
        String formName = dt.getName() == null ? "" : dt.getName();
        String logo = bizAppObj.get("image") == null ? "icons/pc/application/gongyingxietong_48_48.png" : (String)bizAppObj.get("image");
        String appName = StringUtils.isBlank((CharSequence)formName) ? bizAppObj.getLocaleString("name").getLocaleValue() : formName;
        ArrayList<UiNameModel.SelectItem> items = new ArrayList<UiNameModel.SelectItem>(10);
        for (Map<String, Object> map : newBillNoDtos) {
            UiNameModel.SelectItem item = new UiNameModel.SelectItem((String)map.get("pkId"), (String)map.get("billNo"));
            items.add(item);
        }
        ArrayList<UiNameModel.AppItem> appItems = new ArrayList<UiNameModel.AppItem>();
        appItems.add(new UiNameModel.AppItem(appName, logo, formName, items));
        String title = ResManager.loadKDString((String)"\u60a8\u8981\u6253\u5f00\u54ea\u4e2a\u5355\u636e\uff1f", (String)"BillNoSearchPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        if (newBillNoDtos.size() == 1) {
            title = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u6253\u5f00", (String)"BillNoSearchPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
        }
        UiNameModel uiNameModel = new UiNameModel(title, appItems);
        return ResponseModel.createUiNameResponse(uiNameModel);
    }

    private String getAIToken(Map<String, Object> parameter) {
        RequestContext requestContext = RequestContext.get();
        String aitoken = requestContext.getGlobalSessionId();
        aitoken = parameter.get("kdSessionId") != null ? parameter.get("kdSessionId").toString() : this.getAiTokenFromCache(requestContext.getUserOpenId());
        return aitoken;
    }

    private String getAiTokenFromCache(String openId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
        String key = "aitoken_" + openId;
        return (String)cache.get(this.getType4Command(), key);
    }

    private String getType4Command() {
        return "ai_command";
    }
}

