/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.plugin;

import java.util.List;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.UrlModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.webapi.OperationWebApi;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class NewObjectServiceByKeyPlugin
extends AbstractBillWebApiPlugin {
    private Log logger = LogFactory.getLog(NewObjectServiceByKeyPlugin.class);
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void doAICommand(AICommandEvent e) {
        ResponseModel responseData;
        AICommand cmd = e.getCommand();
        Map params = cmd.getParameter();
        this.applyDefaultValue(params);
        Map bizData = this.parseAIObjectByKey(params);
        String formId = this.getFormId();
        String jsondata = SerializationUtils.toJsonString((Object)bizData);
        ApiResult ret = this.executeSaveOperation(formId, jsondata);
        if (!ret.getSuccess()) {
            String errMsg = ret.getMessage();
            if (errMsg == null || errMsg.isEmpty()) {
                errMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5e73\u53f0\u521b\u5efa\u8868\u5355\u5931\u8d25\u3002", (String)"NewObjectServiceByKeyPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            }
            responseData = ResponseModel.createTextResponse(errMsg);
            this.logger.error("\u521b\u5efa\u8868\u5355\u5931\u8d25\u3002formId=" + formId + params);
        } else {
            String pkId = this.parsePkId(ret);
            if (pkId == null) {
                responseData = ResponseModel.createTextResponse(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e73\u53f0\u521b\u5efa\u8868\u5355\u5931\u8d25,pkId\u4e3a\u7a7a", (String)"NewObjectServiceByKeyPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                this.logger.error("\u521b\u5efa\u8868\u5355\u5931\u8d25,save\u5f97\u5230pkId\u4e3a\u7a7a,formId=" + formId + params);
            } else {
                StringBuilder url = new StringBuilder("/mobile.html#/form/").append(formId).append("_mob").append("?");
                url.append("billStatusValue=1&").append("pkId=").append(pkId);
                url.append("&returnDefaultHome=true");
                UrlModel urlModel = new UrlModel();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
                urlModel.setTitle(dataEntityType.getDisplayName().getLocaleValue());
                urlModel.setUrl(url.toString());
                urlModel.setContent(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\uff0c\u60a8\u53ef\u4ee5\u767b\u5f55PC\u7aef\u4fee\u6539\u6216\u63d0\u4ea4\u3002", (String)"NewObjectServiceByKeyPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                responseData = ResponseModel.createUrlResponse(urlModel);
            }
        }
        ret.setData((Object)responseData);
        e.setResult(ret);
    }

    private ApiResult executeSaveOperation(String formId, String data) {
        String appId = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)appId, (String)OperationWebApi.class.getSimpleName(), (String)"save", (Object[])new Object[]{formId, data});
        Map ret = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return ApiResult.fromMap((Map)ret);
    }

    private String parsePkId(ApiResult ret) {
        Object data = ret.getData();
        if (data == null || !(data instanceof Map)) {
            return null;
        }
        List pkIds = (List)((Map)data).get("successPkIds");
        if (pkIds == null || pkIds.isEmpty()) {
            return null;
        }
        return pkIds.get(0).toString();
    }

    protected DynamicObjectCollection query(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
    }

    protected void applyDefaultValue(Map<String, Object> bizData) {
    }
}

