/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.uiplugins;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class UserPerformanceListPlugin
extends AbstractListPlugin {
    private static final String SEPARATOR = "\\s+";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String orgName = (String)this.getView().getFormShowParameter().getCustomParam("orgName");
        String userName = (String)this.getView().getFormShowParameter().getCustomParam("userName");
        if (orgName == null && userName == null) {
            return;
        }
        List<Object> orgIds = this.getOrgIds(orgName);
        List<Object> userIds = this.getUserIds(orgIds, userName);
        List defFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn fc : defFilters) {
            if (fc.getFieldName().equals("org.name")) {
                fc.setDefaultValues(orgIds);
                continue;
            }
            if (!fc.getFieldName().equals("user.name")) continue;
            fc.setDefaultValues(userIds);
        }
    }

    private DynamicObjectCollection getOrg(String orgName) {
        if (orgName == null || orgName.isEmpty()) {
            return null;
        }
        String[] subParams = orgName.split(SEPARATOR);
        QFilter[] filters = new QFilter[subParams.length];
        for (int i = 0; i < subParams.length; ++i) {
            filters[i] = new QFilter("name", "=", (Object)subParams[i]);
        }
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])filters);
        return queryResult;
    }

    private List<Object> getOrgIds(String orgName) {
        DynamicObjectCollection orgDos = this.getOrg(orgName);
        return this.getFieldValues(orgDos, "id");
    }

    private DynamicObjectCollection getUser(String userName) {
        if (userName == null || userName.isEmpty()) {
            return null;
        }
        String[] subParams = userName.split(SEPARATOR);
        QFilter[] filters = new QFilter[subParams.length];
        for (int i = 0; i < subParams.length; ++i) {
            filters[i] = new QFilter("name", "=", (Object)subParams[i]);
        }
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])filters);
        return queryResult;
    }

    private List<Object> getUserIds(List<Object> orgIds, String userName) {
        List<Object> userIds = this.getUserIds(userName);
        if (userIds == null || userIds.isEmpty()) {
            return userIds;
        }
        if (orgIds == null || orgIds.isEmpty()) {
            return userIds;
        }
        QFilter[] filters = new QFilter[]{new QFilter("user", "in", userIds)};
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bos_userposition", (String)"user,org", (QFilter[])filters);
        ArrayList<Object> filteredUserIds = new ArrayList<Object>();
        int size = queryResult.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dt = (DynamicObject)queryResult.get(i);
            Object value = dt.get("org");
            if (value == null) continue;
            String sValue = value.toString();
            for (Object orgId : orgIds) {
                if (!sValue.equals(orgId.toString())) continue;
                filteredUserIds.add(dt.get("user").toString());
            }
        }
        return filteredUserIds;
    }

    private List<Object> getUserIds(String userName) {
        DynamicObjectCollection doc = this.getUser(userName);
        return this.getFieldValues(doc, "id");
    }

    private List<Object> getFieldValues(DynamicObjectCollection doc, String fieldName) {
        if (doc == null || doc.isEmpty()) {
            return new ArrayList<Object>(0);
        }
        int size = doc.size();
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object value = ((DynamicObject)doc.get(i)).get(fieldName);
            if (value == null) continue;
            values.add(value.toString());
        }
        return values;
    }
}

