/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import kd.bos.ai.AISystemTokenService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class AIPlatformUtil {
    private static final Log logger = LogFactory.getLog(AIPlatformUtil.class);
    private static final String SCENE = "scene";

    @KSMethod
    public static void invokeAIRobot(AbstractFormPlugin form, String scene) {
        try {
            String url = AIPlatformUtil.getUrl(scene);
            form.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("invokeYunRobot() occurs an exception. " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    @KSMethod
    public static void invokeAIRobot(AbstractFormPlugin form) {
        AIPlatformUtil.invokeAIRobot(form, form.getPluginName());
    }

    @Deprecated
    @KSMethod
    public static void invokeAIRobot(IFormView view) {
        AIPlatformUtil.invokeAIRobot(view, "");
    }

    @KSMethod
    public static void invokeAIRobot(IFormView view, String scene) {
        String url = AIPlatformUtil.getUrl(scene);
        view.openUrl(url);
    }

    @KSMethod
    public static void invokeAIRobot(IFormView view, Map<String, Object> param) {
        String scene = "";
        if (param != null && !StringUtils.isBlank((Object)param.get(SCENE))) {
            scene = (String)param.get(SCENE);
        }
        String url = AIPlatformUtil.getUrl(scene, param);
        view.openUrl(url);
    }

    private static String getUrl(String scene) {
        return AIPlatformUtil.getUrl(scene, null);
    }

    private static String getUrl(String scene, Map<String, Object> param) {
        RequestContext requestContext = RequestContext.get();
        String aiServer = AISystemTokenService.getPublicParameter((String)"aiserver");
        String appId = AISystemTokenService.getPublicParameter((String)"aiappid");
        if (StringUtils.isBlank((CharSequence)aiServer) || StringUtils.isBlank((CharSequence)appId)) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ResManager.loadKDString((String)"aiConfig.aiServer \u6216 aiConfig.appId \u672a\u914d\u7f6e", (String)"AIPlatformUtil_0", (String)"bos-form-business", (Object[])new Object[0])});
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(aiServer).append("/chatbot/index.html?");
        String openId = requestContext.getUserOpenId();
        String token = AISystemTokenService.getToken((boolean)false);
        urlBuilder.append("token=").append(token);
        urlBuilder.append("&kdSessionId=").append(requestContext.getGlobalSessionId());
        urlBuilder.append("&scene=").append(scene);
        urlBuilder.append("&appid=").append(appId);
        try {
            urlBuilder.append("&uname=").append(StringUtils.isEmpty((CharSequence)requestContext.getUserName()) ? "" : URLEncoder.encode(requestContext.getUserName(), "UTF-8"));
            String avatar = AIPlatformUtil.getAvatar(openId);
            urlBuilder.append("&avatar=").append(StringUtils.isEmpty((CharSequence)avatar) ? "" : URLEncoder.encode(avatar, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (param != null) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                if (SCENE.equals(entry.getKey())) continue;
                urlBuilder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        String result = urlBuilder.toString();
        logger.info("\u521b\u5efaAI\u8f7b\u5e94\u7528\u7684URL: " + result);
        return result;
    }

    private static String getAvatar(String openId) {
        String sql = "select favatar from t_sec_user where fopenid='%s'";
        DynamicObjectCollection queryResult = AIPlatformUtil.queryData(sql, openId);
        if (queryResult == null || queryResult.isEmpty()) {
            return "";
        }
        if (queryResult.size() > 1) {
            logger.warn("avatar has found more than 1 record. openId is " + openId);
        }
        return ((DynamicObject)queryResult.get(0)).getString("favatar");
    }

    private static DynamicObjectCollection queryData(String sql, String id) {
        DynamicObjectCollection data;
        String exeSql = String.format(sql, id);
        try {
            data = SingleORM.query(null, (String)exeSql, null);
        }
        catch (Throwable ex) {
            throw new KDException(ex, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", ex.getMessage(), exeSql)});
        }
        return data;
    }
}

