/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.util;

import java.net.URLEncoder;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log log = LogFactory.getLog(HttpUtil.class);
    private static final String UTF8 = "UTF-8";

    public static String postByJson(String url, Map<String, String> headers, Map<String, Object> params) {
        return HttpUtil.postByJson(url, headers, JsonUtil.encodeToString(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postByJson(String url, Map<String, String> headers, String json) {
        CloseableHttpClient httpclient = null;
        String respStr = null;
        try {
            httpclient = HttpClientBuilder.create().build();
            HttpPost httppost = new HttpPost(url);
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httppost.setHeader(entry.getKey(), HttpUtil.urlEncode(entry.getValue()));
                }
            }
            StringEntity stringEntity = new StringEntity(json, UTF8);
            stringEntity.setContentType("application/json");
            httppost.setEntity((HttpEntity)stringEntity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                respStr = EntityUtils.toString((HttpEntity)entity, (String)UTF8);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return respStr;
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, UTF8);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return str;
        }
    }
}

