/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.EntryViewType;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.util.CollectionUtils;

public class BatchFillEntry
extends EntryGridOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private String entryKey;
    private int currentRow;
    private IDataModel model;

    @Override
    protected OperationResult invokeOperation() {
        this.entryKey = this.getEntryKey();
        this.model = (IDataModel)this.getView().getService(IDataModel.class);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        AbstractGrid.GridState entryState = entryGrid.getEntryState();
        if (entryState == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"BatchFillEntry_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return new OperationResult();
        }
        Object row = entryState.get("row");
        this.currentRow = row == null ? -1 : (Integer)row;
        Control control = this.getView().getControl(entryState.getFocusField());
        if (this.currentRow < 0 || !(control instanceof FieldEdit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"BatchFillEntry_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return new OperationResult();
        }
        EntryViewType entryViewType = entryState.getEntryViewType();
        if (EntryViewType.TiledView.equals((Object)entryViewType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e73\u94fa\u89c6\u56fe\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"BatchFillEntry_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return new OperationResult();
        }
        List<IDataEntityProperty> selProps = null;
        Object[] values = null;
        FieldEdit fieldEdit = (FieldEdit)control;
        try {
            selProps = this.getSelPropertys(fieldEdit);
            if (selProps.isEmpty()) {
                return new OperationResult();
            }
            this.model.getDataEntity(true);
            values = new Object[selProps.size()];
            for (int i = 0; i < selProps.size(); ++i) {
                values[i] = this.model.getValue(selProps.get(i).getName(), this.currentRow);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u503c\u586b\u5145\u3002", (String)"BatchFillEntry_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return new OperationResult();
        }
        String userId = RequestContext.get().getUserId();
        String formId = this.getEntityId();
        Object resultValue = ParameterHelper.getUserOption((long)Long.parseLong(userId), (String)formId, null, (String)"batchfillnull");
        boolean batchFillNull = resultValue != null && (Boolean)resultValue != false;
        ArrayList<Integer> rowkeyList = new ArrayList<Integer>(1);
        rowkeyList.add(this.currentRow);
        List filterCurrentRow = this.model.getFilterIndexByRowKeys(this.entryKey, rowkeyList);
        if (CollectionUtils.isEmpty((Collection)filterCurrentRow)) {
            return new OperationResult();
        }
        this.currentRow = (Integer)filterCurrentRow.get(0);
        int realFillCount = this.getView().getModel().batchFillEntry(this.entryKey, this.currentRow, selProps, values, batchFillNull);
        int rowCount = this.model.getFilterEntryRowCount(this.entryKey);
        boolean isSplitPage = this.model.getDataEntity().getDataEntityState().isSplitPage();
        int endRowIndex = this.currentRow + 1 + realFillCount;
        if (isSplitPage && rowCount - endRowIndex > 0) {
            String tip = String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011-\u3010%2$s\u3011\u6279\u91cf\u586b\u5145\u5904\u7406\u6210\u529f\uff0c\u5269\u4f59\u3010%3$s\u3011\u884c\u56e0\u8d85\u51fa\u884c\u6570\u9650\u5236\u672a\u586b\u5145\u3002", (String)"BatchFillEntry_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.currentRow + 1, endRowIndex, rowCount - endRowIndex);
            this.getView().showTipNotification(tip);
        }
        return new OperationResult();
    }

    private List<IDataEntityProperty> getSelPropertys(FieldEdit fieldEdit) {
        String caption = fieldEdit.getFieldKey();
        ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>();
        if (fieldEdit instanceof DateRangeEdit || fieldEdit instanceof TimeRangeEdit) {
            String startDateFieldKey = fieldEdit instanceof DateRangeEdit ? ((DateRangeEdit)fieldEdit).getStartDateFieldKey() : ((TimeRangeEdit)fieldEdit).getStartDateFieldKey();
            String endDateFieldKey = fieldEdit instanceof DateRangeEdit ? ((DateRangeEdit)fieldEdit).getEndDateFieldKey() : ((TimeRangeEdit)fieldEdit).getEndDateFieldKey();
            list.add(this.model.getProperty(startDateFieldKey));
            list.add(this.model.getProperty(endDateFieldKey));
            if (((DynamicProperty)list.get(0)).getDisplayName() != null) {
                caption = ((DynamicProperty)list.get(0)).getDisplayName().toString();
            }
            if (caption.indexOf(".") >= 0) {
                caption = caption.substring(0, caption.indexOf("."));
            }
        } else {
            list.add(this.getView().getModel().getProperty(fieldEdit.getFieldKey()));
            if (((DynamicProperty)list.get(0)).getDisplayName() != null) {
                caption = ((DynamicProperty)list.get(0)).getDisplayName().toString();
            }
        }
        ArrayList<IDataEntityProperty> selProps = new ArrayList<IDataEntityProperty>();
        ArrayList<String> captions = new ArrayList<String>();
        for (IDataEntityProperty property : list) {
            if (property instanceof IFieldHandle && ((IFieldHandle)property).isMultiFillable()) {
                selProps.add(property);
                continue;
            }
            if (property instanceof DynamicProperty && ((DynamicProperty)property).getDisplayName() != null) {
                captions.add(((DynamicProperty)property).getDisplayName().toString());
                continue;
            }
            captions.add(property.getName());
        }
        if (selProps.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u6279\u91cf\u586b\u5145\u3002", (String)"BatchFillEntry_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), caption));
        }
        return selProps;
    }
}

