/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.MutexValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.IFormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.View;
import kd.bos.form.operate.listop.Navigation;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;

public class DefaultBillFormOperate
extends DefaultDynamicFormOperate
implements IFormOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    protected boolean isMutexLocked = false;
    protected String lockInfoStr = null;
    protected boolean existMutexNetGroup = true;
    protected String viewBillFormId;
    CloseCallBack closeCallBack;
    List<Consumer<FormShowParameter>> beforeShowBillListeners = new ArrayList<Consumer<FormShowParameter>>();
    boolean isCancelShowBill;
    protected Object pkValue = null;
    private String permissionEntityId;

    public String getViewBillFormId() {
        return this.viewBillFormId;
    }

    public void setViewBillFormId(String viewBillFormId) {
        this.viewBillFormId = viewBillFormId;
    }

    public CloseCallBack getCloseCallBack() {
        return this.closeCallBack;
    }

    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }

    public void addBeforeShowBillListener(Consumer<FormShowParameter> beforeShowBillListener) {
        this.beforeShowBillListeners.add(beforeShowBillListener);
    }

    public boolean isCancelShowBill() {
        return this.isCancelShowBill;
    }

    public void setCancelShowBill(boolean isCancelShowBill) {
        this.isCancelShowBill = isCancelShowBill;
    }

    protected void initPkValue() {
        ListSelectedRow row = this.getListFocusRow();
        if (row != null) {
            this.mainOrgId = row.getMainOrgId();
            this.pkValue = row.getPrimaryKeyValue();
        } else {
            String selectview = this.getView().getPageCache().get("selectview");
            if (StringUtils.isNotBlank((CharSequence)selectview) && selectview.contains("cardview") && this.getListFocusRow() == null && this.getListSelectedData() != null && !this.getListSelectedData().isEmpty()) {
                ListSelectedRow selectedRow = this.getListSelectedData().get(0);
                this.setListFocusRow(selectedRow);
                this.mainOrgId = selectedRow.getMainOrgId();
                this.pkValue = selectedRow.getPrimaryKeyValue();
            }
        }
    }

    protected Object getPKValue() {
        return this.pkValue;
    }

    protected boolean checkPKId(Object pkValue) {
        if (this.getView() == null || !(this.getView().getModel().getDataEntityType().getPrimaryKey() instanceof PKFieldProp)) {
            return pkValue == null;
        }
        PKFieldProp pkProp = (PKFieldProp)this.getView().getModel().getDataEntityType().getPrimaryKey();
        return pkProp.getValueComparator().compareValue(pkValue);
    }

    protected boolean existPKId(Object pkValue) {
        ORM orm = ORM.create();
        return orm.exists(this.getEntityId(), pkValue);
    }

    protected List<ListSelectedRow> getCheckRightRowsInList() {
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        if (this.getListFocusRow() != null) {
            list.add(this.getListFocusRow());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beforeInvokeOperation(OperationResult result) {
        this.initPkValue();
        OperateOption option = this.getOption();
        if (option != null && "false".equalsIgnoreCase(option.getVariableValue("tip.continue", "true"))) {
            return false;
        }
        try {
            boolean bl = super.beforeInvokeOperation(result);
            return bl;
        }
        finally {
            if (!result.isSuccess() && this.isMutexLocked && this.pkValue != null) {
                MutexHelper.release((String)this.getEntityId(), (String)this.getMutexOperateKey(), (String)this.pkValue.toString());
            }
        }
    }

    protected int hasRight(OperationResult result) {
        int ret = 1;
        StringBuilder errorInfo = new StringBuilder();
        if (super.hasRight(result) == 0) {
            ret = 0;
        } else if (!this.checkSpecialDataPerm(errorInfo)) {
            if (this instanceof Navigation) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().getPageCache().put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)this.getView().getFormShowParameter()));
                return 1;
            }
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "002", "", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7279\u6b8a\u6570\u636e\u6743\u9650(%s)\u3002", (String)"DefaultBillFormOperate_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[]{errorInfo}), ErrorLevel.Error);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError("specialDataPermission", validateResult);
            ret = 0;
        } else if (!this.existPKId(this.getPKValue())) {
            ValidateResult validateResult = new ValidateResult();
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "notexists", "", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"DefaultBillFormOperate_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), ErrorLevel.Error);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError("billExists", validateResult);
            ret = 0;
        } else if (!MutexHelper.isOpenIntentLocks() && !this.checkDataMutex()) {
            MutexValidateResult validateResult = new MutexValidateResult(false);
            if (this.enableReentrantMutex()) {
                validateResult.setEnableReentrant(true);
            }
            if (this.lockInfoStr == null) {
                this.lockInfoStr = ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"DefaultBillFormOperate_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            }
            ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "003", "", this.lockInfoStr, ErrorLevel.Error);
            validateResult.addErrorInfo((OperateErrorInfo)info);
            result.setSuccess(false);
            result.getValidateResult().addValidateError("dataMutex", (ValidateResult)validateResult);
            ret = 0;
        }
        return ret;
    }

    protected boolean checkSpecialDataPerm(StringBuilder errorInfo) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getRealPermissionEntityId());
        if (!mainEntityType.getPermissionControlType().isControlFunction()) {
            return true;
        }
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            appId = this.getView().getFormShowParameter().getAppId();
        }
        String ctrlType = mainEntityType.getPermissionControlType().getDimension();
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)ctrlType) && ctrlType.equalsIgnoreCase("DIM_ORG")) {
            DynamicProperty dp;
            String ctrlOrg = mainEntityType.getPermissionControlType().getDataDimensionField();
            if (StringUtils.isBlank((CharSequence)ctrlOrg)) {
                ctrlOrg = mainEntityType.getMainOrg();
            }
            if (StringUtils.isNotBlank((CharSequence)ctrlOrg) && (dp = mainEntityType.getProperty(ctrlOrg)) != null) {
                String id = mainEntityType.getPrimaryKey().getName();
                ORM orm = ORM.create();
                QFilter q = new QFilter(id, "=", this.pkValue);
                QFilter[] filters = new QFilter[]{q};
                String selectFields = id + "," + ctrlOrg;
                DynamicObject org = orm.queryOne(this.getRealPermissionEntityId(), selectFields, filters);
                if (org != null) {
                    Object orgObj = org.get(ctrlOrg);
                    orgId = orgObj instanceof String ? Long.valueOf((String)orgObj) : (Long)orgObj;
                }
            }
        }
        String operateType = this.getType();
        QFilter qFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)this.getRealPermissionEntityId(), (String)operateType, (ITimeService)new TimeService(), (IUserService)new UserService(), (StringBuilder)errorInfo, orgId);
        if (qFilter != null) {
            String pkPropName = mainEntityType.getPrimaryKey().getName();
            qFilter = qFilter.and(new QFilter(pkPropName, "=", this.pkValue));
            ORM orm = ORM.create();
            return orm.exists(this.getRealPermissionEntityId(), new QFilter[]{qFilter});
        }
        return true;
    }

    protected String getMutexOperateKey() {
        return this.getOperateKey();
    }

    protected boolean checkDataMutex() {
        String mutexOperateKey = this.getMutexOperateKey();
        this.isMutexLocked = false;
        if (View.class.isAssignableFrom(((Object)((Object)this)).getClass()) && this.getOption().getVariables().containsKey("isListViewOp4Mutex") && Boolean.parseBoolean(this.getOption().getVariableValue("isListViewOp4Mutex"))) {
            String pageId = this.generatePage4ListOp(this.getView(), this.getViewBillFormId(), this.getPKValue());
            FormShowParameter fs = SessionManager.getCurrent().getFormShowParameter(pageId);
            if (fs != null && fs.getSessionId().equals(RequestContext.get().getGlobalSessionId())) {
                this.isMutexLocked = true;
                return true;
            }
        }
        if (StringUtils.isBlank((CharSequence)MutexHelper.getMutexGroupId((String)this.getEntityId(), (String)mutexOperateKey))) {
            this.isMutexLocked = true;
            this.existMutexNetGroup = false;
            return this.isMutexLocked;
        }
        boolean isStrict = true;
        if (this.getOption() != null && this.getOption().containsVariable("isStrict")) {
            isStrict = Boolean.parseBoolean(this.getOption().getVariableValue("isStrict"));
        }
        StringBuilder failInfo = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(this.pkValue), this.getBillNo(), null, this.getEntityId(), mutexOperateKey, isStrict, "default");
        this.isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
        if (!this.isMutexLocked) {
            this.lockInfoStr = failInfo.toString();
        }
        return this.isMutexLocked;
    }

    private String getBillNo() {
        ListSelectedRow row = this.getListFocusRow();
        String billNo = null;
        if (row != null) {
            billNo = StringUtils.isNotBlank((CharSequence)row.getBillNo()) ? row.getBillNo() : row.getNumber();
        } else {
            String selectview = this.getView().getPageCache().get("selectview");
            if (StringUtils.isNotBlank((CharSequence)selectview) && selectview.contains("cardview") && this.getListFocusRow() == null && this.getListSelectedData() != null && !this.getListSelectedData().isEmpty()) {
                ListSelectedRow selectedRow = this.getListSelectedData().get(0);
                this.setListFocusRow(selectedRow);
                billNo = StringUtils.isNotBlank((CharSequence)selectedRow.getBillNo()) ? selectedRow.getBillNo() : selectedRow.getNumber();
            }
        }
        return StringUtils.isNotBlank((CharSequence)billNo) ? billNo : String.valueOf(this.pkValue);
    }

    protected boolean enableReentrantMutex() {
        return MutexHelper.enableReentrant((String)this.getEntityId(), (Object)this.pkValue, (String)this.getOperateKey());
    }

    public String getPermissionEntityId() {
        return this.permissionEntityId;
    }

    public void setPermissionEntityId(String permissionEntityId) {
        this.permissionEntityId = permissionEntityId;
    }

    protected String generatePage4ListOp(IFormView currentView, String viewBillFormId, Object pkValue) {
        if (pkValue instanceof String) {
            pkValue = pkValue.toString().replace("/", "");
        }
        return currentView.getPageId() + "_" + viewBillFormId + "_" + pkValue;
    }
}

