/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.kflow.api.FlowParam;
import kd.bos.kflow.api.IFlowService;
import kd.bos.kflow.api.ServiceResult;
import kd.bos.kflow.api.enums.ValueType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class KFlowOp
extends DefaultDynamicFormOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String ENTITY_INSTANCE = "kf_instance";

    @Override
    protected OperationResult invokeOperation() {
        String flowId = (String)this.getParameter().get("flowId");
        String refId = (String)this.getParameter().get("refId");
        String entityId = this.getEntityId();
        if (StringUtils.isBlank((CharSequence)flowId) || StringUtils.isBlank((CharSequence)refId) || StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        IFlowService iFlowService = (IFlowService)ServiceFactory.getService(IFlowService.class);
        List params = iFlowService.getParameterByFlowId(flowId);
        for (FlowParam param : params) {
            if (!ValueType.View.equals((Object)param.getValueType()) || !entityId.equals(param.getEntityTypeName())) continue;
            HashMap<String, FlowParam> requestParams = new HashMap<String, FlowParam>(1);
            requestParams.put(param.getName(), new FlowParam(param.getName(), ValueType.View, (Object)this.getView()));
            IFlowService flowService = (IFlowService)ServiceFactory.getService(IFlowService.class);
            try {
                ServiceResult result = flowService.executeByRefId(refId, requestParams);
                if (!result.getSuccess().booleanValue()) {
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"K\u6d41\u7f16\u7801:%1$s%n\u72b6\u6001\u7801:%2$s%n\u5f02\u5e38\u4fe1\u606f:%3$s%n\u6570\u636e\u7c7b\u578b:%4$s%n\u8fd4\u56de\u6570\u636e:%5$s%n", (String)"KFlowOp_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.getFlowNumberById(flowId), result.getErrorCode(), result.getError(), result.getData(), result.getDataType()));
                }
                break;
            }
            catch (RuntimeException e) {
                if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                    String[] msg = e.getMessage().split("!");
                    String flowDisabledCode = "400009";
                    if (msg != null && msg.length > 0 && StringUtils.isNotBlank((CharSequence)msg[0]) && flowDisabledCode.equals(msg[0])) {
                        String tips = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5f15\u7528\u7684K\u6d41\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5K\u6d41\u7ba1\u7406\u3002", (String)"KFlowOp_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                        this.getView().showErrorNotification(tips);
                        return null;
                    }
                }
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"K\u6d41\u7f16\u7801:%1$s%n\u5f02\u5e38\u4fe1\u606f:%2$s%n", (String)"KFlowOp_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.getFlowNumberById(flowId), e.getMessage()));
            }
        }
        return null;
    }

    private String getFlowNumberById(String flowId) {
        String flowNumber = null;
        String selectFields = "number";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(flowId))};
        DynamicObject object = QueryServiceHelper.queryOne((String)ENTITY_INSTANCE, (String)selectFields, (QFilter[])qFilters);
        if (object != null) {
            flowNumber = object.getString("number");
        }
        return flowNumber;
    }

    public boolean needSelectData() {
        return false;
    }
}

