/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ITreeEntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MoveEntryDown
extends EntryGridOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final IAttachmentOperateService attachmentOperateService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);

    @Override
    public OperationResult invokeOperation() {
        int[] rowIndexs;
        String entryKey = this.getEntryKey();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getService(IDataModel.class);
        if (this.isAllowMoveEntryDown(model, rowIndexs = proxy.getEntryState(entryKey).getSelectedRows())) {
            attachmentOperateService.deleteAttachCache(this.getPageId(), entryKey);
            Control entry = this.getView().getControl(entryKey);
            if (entry instanceof CardEntry) {
                proxy.invokeControlMethod(entryKey, "clearSelRows", new Object[0]);
            }
            model.moveEntryRowsDown(entryKey, rowIndexs);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            List subEntryGrids = entryGrid.getSubEntryGrids();
            if (subEntryGrids != null) {
                for (String subEntryGrid : subEntryGrids) {
                    proxy.invokeControlMethod(subEntryGrid, "setGridPr", new Object[]{model.getEntryCurrentRowIndex(entryKey)});
                }
            }
        }
        return null;
    }

    private boolean isAllowMoveEntryDown(AbstractFormDataModel model, int[] rowIndexs) {
        String entryKey = this.getEntryKey();
        if (rowIndexs.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MoveEntryDown_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        int maxRow = Arrays.stream(rowIndexs).max().getAsInt();
        int rowCount = model.getEntryRowCount(entryKey);
        EntryInfo entryInfo = model.getEntryPageInfo(this.getEntryKey());
        if (entryInfo != null && entryInfo.getRowCount() != null) {
            int currentBatchEndRowIndex;
            int pageSize;
            Integer initRowCount = entryInfo.getRowCount();
            int startRowIndex = entryInfo.getStartRowIndex();
            if (startRowIndex + (pageSize = entryInfo.getPageSize()) < initRowCount && maxRow >= (currentBatchEndRowIndex = startRowIndex + (rowCount + pageSize - initRowCount)) - 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u5f53\u524d\u6279\u6b21\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"MoveEntryDown_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        if (maxRow >= rowCount - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"MoveEntryDown_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        boolean isFilterAndSortModel = model.isFilterAndSortModel(this.getEntryKey());
        if (isFilterAndSortModel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53d6\u6d88\u5206\u5f55\u6392\u5e8f\u3001\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u4e0b\u79fb\u64cd\u4f5c\u3002", (String)"MoveEntryDown_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        boolean bAllowMoveEntryDown = true;
        EntryProp entryProp = (EntryProp)model.getProperty(entryKey);
        if (entryProp instanceof ITreeEntryProp) {
            bAllowMoveEntryDown = false;
            Object pid = model.getTreeEntryEntityRow(entryProp, maxRow).get("pid");
            int j = 1;
            while (model.getTreeEntryEntityRow(entryProp, maxRow + j) != null) {
                if (pid.equals(model.getTreeEntryEntityRow(entryProp, maxRow + j).get("pid"))) {
                    bAllowMoveEntryDown = true;
                    break;
                }
                ++j;
            }
            for (int i : rowIndexs) {
                if (pid.equals(model.getTreeEntryEntityRow(entryProp, i).get("pid"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u8282\u70b9\u4e0b\u79fb\u3002", (String)"MoveEntryDown_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        if (!bAllowMoveEntryDown) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u672b\u884c\uff0c\u65e0\u6cd5\u4e0b\u79fb\u3002", (String)"MoveEntryDown_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
        }
        return bAllowMoveEntryDown;
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(this.getEntryKey()).getSelectedRows();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getService(IDataModel.class);
        if (!this.isAllowMoveEntryDown(model, rowIndexs)) {
            return false;
        }
        return super.beforeInvokeOperation(result);
    }
}

