/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ITreeEntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MoveEntryUp
extends EntryGridOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final IAttachmentOperateService attachmentOperateService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);

    @Override
    public OperationResult invokeOperation() {
        int[] rowIndexs;
        String entryKey = this.getEntryKey();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getService(IDataModel.class);
        if (this.isAllowMoveEntryUp(model, rowIndexs = proxy.getEntryState(entryKey).getSelectedRows())) {
            attachmentOperateService.deleteAttachCache(this.getPageId(), entryKey);
            Control entry = this.getView().getControl(entryKey);
            if (entry instanceof CardEntry) {
                proxy.invokeControlMethod(entryKey, "clearSelRows", new Object[0]);
            }
            model.moveEntryRowsUp(entryKey, rowIndexs);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            List subEntryGrids = entryGrid.getSubEntryGrids();
            if (subEntryGrids != null) {
                for (String subEntryGrid : subEntryGrids) {
                    proxy.invokeControlMethod(subEntryGrid, "setGridPr", new Object[]{model.getEntryCurrentRowIndex(entryKey)});
                }
            }
        }
        return null;
    }

    private boolean isAllowMoveEntryUp(AbstractFormDataModel model, int[] rowIndexs) {
        int minRow;
        if (rowIndexs.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MoveEntryUp_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        int startRowIndex = 0;
        EntryInfo entryInfo = model.getEntryPageInfo(this.getEntryKey());
        if (entryInfo != null && entryInfo.getRowCount() != null) {
            startRowIndex = entryInfo.getStartRowIndex();
        }
        if ((minRow = Arrays.stream(rowIndexs).min().getAsInt()) == startRowIndex - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MoveEntryUp_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        if (minRow <= startRowIndex) {
            if (startRowIndex > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u5f53\u524d\u6279\u6b21\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"MoveEntryUp_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"MoveEntryUp_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            }
            return false;
        }
        boolean isFilterAndSortModel = model.isFilterAndSortModel(this.getEntryKey());
        if (isFilterAndSortModel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53d6\u6d88\u5206\u5f55\u6392\u5e8f\u3001\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u4e0a\u79fb\u64cd\u4f5c\u3002", (String)"MoveEntryUp_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        boolean bAllowMoveEntryUp = true;
        String entryKey = this.getEntryKey();
        EntryProp entryProp = (EntryProp)model.getProperty(entryKey);
        if (entryProp instanceof ITreeEntryProp) {
            Object pid = model.getTreeEntryEntityRow(entryProp, minRow).get("pid");
            for (int i : rowIndexs) {
                if (pid.equals(model.getTreeEntryEntityRow(entryProp, i).get("pid"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u8282\u70b9\u4e0a\u79fb\u3002", (String)"MoveEntryUp_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (!pid.toString().equals("0") && pid.equals(model.getTreeEntryEntityRow(entryProp, minRow - 1).getPkValue())) {
                bAllowMoveEntryUp = false;
            }
        }
        if (!bAllowMoveEntryUp) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5305\u542b\u9996\u884c\uff0c\u65e0\u6cd5\u4e0a\u79fb\u3002", (String)"MoveEntryUp_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
        }
        return bAllowMoveEntryUp;
    }

    @Override
    protected boolean beforeInvokeOperation(OperationResult result) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(this.getEntryKey()).getSelectedRows();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getService(IDataModel.class);
        if (!this.isAllowMoveEntryUp(model, rowIndexs)) {
            return false;
        }
        return super.beforeInvokeOperation(result);
    }
}

