/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeSubEntryGrid;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SetEntryBottom {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private String entryKey;
    private IFormView view;

    public SetEntryBottom(String entryKey, IFormView view) {
        this.entryKey = entryKey;
        this.view = view;
    }

    public OperationResult invokeOperation() {
        DynamicObjectCollection entryEntity;
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.view.getService(IDataModel.class);
        int[] rowIndexs = proxy.getEntryState(this.entryKey).getSelectedRows();
        Control entry = this.view.getControl(this.entryKey);
        if (entry instanceof TreeEntryGrid) {
            entryEntity = model.getEntryEntity(this.entryKey);
            rowIndexs = ((TreeEntryGrid)entry).resetSelectRowIndexs(entryEntity, rowIndexs);
        }
        if (entry instanceof TreeSubEntryGrid) {
            entryEntity = model.getEntryEntity(this.entryKey);
            rowIndexs = ((TreeSubEntryGrid)entry).resetSelectRowIndexs(entryEntity, rowIndexs);
        }
        if (this.isAllowSetEntryBottom(model, rowIndexs)) {
            if (entry instanceof CardEntry) {
                proxy.invokeControlMethod(this.entryKey, "clearSelRows", new Object[0]);
            }
            model.setEntryRowBottom(this.entryKey, rowIndexs);
        }
        return null;
    }

    private boolean isAllowSetEntryBottom(AbstractFormDataModel model, int[] rowIndexs) {
        int rowCount;
        int maxRow;
        if (rowIndexs.length <= 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SetEntryBottom_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        int[] allRowIndexs = rowIndexs;
        Control entry = this.view.getControl(this.entryKey);
        if (entry instanceof TreeEntryGrid || entry instanceof TreeSubEntryGrid) {
            DynamicObjectCollection entryRows = model.getEntityEntity(this.entryKey);
            allRowIndexs = TreeEntryProp.getTreeEntrySubRowsByIndexs((DynamicObjectCollection)entryRows, (int[])rowIndexs);
        }
        if ((maxRow = Arrays.stream(allRowIndexs).max().getAsInt()) >= (rowCount = model.getEntryRowCount(this.entryKey)) - 1 && this.isContinue(allRowIndexs)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5df2\u5230\u8fbe\u5e95\u884c\uff0c\u65e0\u6cd5\u7f6e\u5e95\u3002", (String)"SetEntryBottom_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        boolean isFilterAndSortModel = model.isFilterAndSortModel(this.entryKey);
        if (isFilterAndSortModel) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53d6\u6d88\u5206\u5f55\u6392\u5e8f\u3001\u8fc7\u6ee4\u540e\u518d\u8fdb\u884c\u7f6e\u5e95\u64cd\u4f5c\u3002", (String)"SetEntryBottom_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    private boolean isContinue(int[] rowIndexs) {
        for (int i = 0; i < rowIndexs.length - 1; ++i) {
            if (rowIndexs[i] + 1 == rowIndexs[i + 1]) continue;
            return false;
        }
        return true;
    }
}

