/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.IInteractionRequest;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.form.operate.interaction.InteractionHandler;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.bos.service.operation.OperationServiceImpl;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DeleteEntry
extends EntryGridOperate {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String AFTER_DEL_ROW_FOCUS = "AfterDelRowFocus";
    private static final String LOST_FOCUS = "lostFocus";
    private static final IAttachmentOperateService attachmentOperateService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);
    private LocaleString successMsg;
    private String levelId;

    public LocaleString getSuccessMsg() {
        return this.successMsg;
    }

    public void initialize(Map<String, Object> opMeta) {
        List validationList;
        super.initialize(opMeta);
        this.successMsg = this.LocaleFromOpMeta(opMeta, "successMsg");
        Object validations = opMeta.get("validations");
        if (validations instanceof List && (validationList = (List)validations).size() > 0) {
            this.levelId = String.valueOf(((HashMap)validationList.get(0)).get("levelId"));
        }
    }

    @Override
    public OperationResult invokeOperation() {
        ValidateResultCollection validateResultCollection;
        String entryKey = this.getEntryKey();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState(this.getEntryKey()).getSelectedRows();
        attachmentOperateService.deleteAttachCache(this.getPageId(), entryKey);
        List<AbstractGrid> relatedGrid = this.getRelatedGrid();
        this.beginSelectRow(relatedGrid);
        EntryProp entryProp = (EntryProp)this.getView().getModel().getDataEntityType().getProperties().get((Object)entryKey);
        this.getOption().setVariableValue("entrykey", entryKey);
        this.getOption().setVariableValue("parentindex", String.valueOf(entryProp instanceof SubEntryProp ? this.getView().getModel().getEntryCurrentRowIndex(entryProp.getParent().getName()) : -1));
        this.getOption().setVariableValue("rowindex", Arrays.toString(rowIndexs));
        this.getOption().setVariableValue("onlyvalidate", "true");
        this.getOption().setVariableValue("levelid", this.levelId);
        OperationResult operationResult = super.invokeOperation();
        if (operationResult != null && (validateResultCollection = operationResult.getValidateResult()) != null && validateResultCollection.errorSize() != 0) {
            return operationResult;
        }
        this.getView().getModel().deleteEntryRows(entryKey, rowIndexs);
        this.endSelectRow(relatedGrid);
        return null;
    }

    @Override
    protected boolean isNeedSelectRows() {
        return true;
    }

    private void beginSelectRow(List<AbstractGrid> relatedGrid) {
        for (AbstractGrid grid : relatedGrid) {
            if (!(grid instanceof EntryGrid) || !this.stopSelectRow((EntryGrid)grid)) continue;
            ((EntryGrid)grid).setStopSelectRow(true);
        }
    }

    private void endSelectRow(List<AbstractGrid> relatedGrid) {
        for (AbstractGrid grid : relatedGrid) {
            if (!(grid instanceof EntryGrid) || !this.stopSelectRow((EntryGrid)grid)) continue;
            ((EntryGrid)grid).setStopSelectRow(false);
            this.getView().getModel().setEntryCurrentRowIndex(this.getEntryKey(), 0);
            grid.selectRows(-1);
        }
    }

    private boolean stopSelectRow(EntryGrid entryGrid) {
        if (LOST_FOCUS.equals(this.getParameter().get(AFTER_DEL_ROW_FOCUS))) {
            return true;
        }
        if (entryGrid.isServerFilterModle()) {
            return false;
        }
        Map entryFilterStatus = entryGrid.getEntryState().getEntryFilterStatus();
        return entryFilterStatus.get("hasFilter") != null && (Boolean)entryFilterStatus.get("hasFilter") != false;
    }

    @Override
    protected OperationResult callFormOperate() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperationResult opResult = operationService.localInvokeOperation(this.getOperateKey(), new DynamicObject[]{dataEntity}, this.getOption());
        return opResult;
    }

    protected void afterOperationClose(OperationResult opResult) {
        if (opResult != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("validationwarn", (AbstractOperate)this);
            InteractionHandler.doInteraction((IFormView)this.getView(), (IInteractionRequest)opResult, (OperateOption)this.getOption(), (ConfirmCallBackListener)confirmCallBacks);
            if (this.isShowMessage(opResult)) {
                if (opResult.isSuccess() && opResult.getAllErrorOrValidateInfo().isEmpty() && StringUtils.isBlank((CharSequence)opResult.getMessage())) {
                    this.showSuccessMessage(opResult);
                } else {
                    this.getView().showOperationResult(opResult, this.getOperateName().toString());
                }
            }
        }
    }

    protected boolean isShowMessage(OperationResult operationResult) {
        if (operationResult != null && !operationResult.isShowMessage()) {
            return false;
        }
        RefObject opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("isshowmessage", opValue)) {
            return Boolean.parseBoolean((String)opValue.getValue());
        }
        return true;
    }

    protected void showSuccessMessage(OperationResult operationResult) {
        String nextOperationKey = (String)this.getParameter().get("afterOperation");
        IFormView view = this.getView();
        boolean showInParentView = false;
        if (StringUtils.equalsIgnoreCase((CharSequence)"close", (CharSequence)nextOperationKey) && StringUtils.isNotBlank((CharSequence)this.getView().getFormShowParameter().getParentPageId())) {
            view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            showInParentView = true;
            if (view == null) {
                view = this.getView();
                showInParentView = false;
            }
        }
        String msg = this.getShowSuccessMsg(operationResult);
        view.showSuccessNotification(msg);
        if (showInParentView) {
            this.getView().sendFormAction(view);
        }
    }

    protected String getShowSuccessMsg(OperationResult operationResult) {
        if (this.getSuccessMsg() == null || StringUtils.isBlank((CharSequence)this.getSuccessMsg().toString())) {
            return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"DeleteEntry_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), this.getOperateName().toString());
        }
        return this.getSuccessMsg().toString();
    }
}

