/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.report.ReportShowParameter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OpenForm
extends DefaultDynamicFormOperate {
    @Override
    public OperationResult invokeOperation() {
        boolean isMoblie;
        String form = (String)this.getParameter().get("form");
        if (StringUtils.isBlank((CharSequence)form)) {
            return null;
        }
        String number = MetadataDao.getNumberById((String)form);
        String modelType = (String)this.getParameter().get("modeltype");
        if (StringUtils.isEmpty((CharSequence)modelType)) {
            modelType = "form";
        }
        if ((isMoblie = this.getView() instanceof IMobileView) && !modelType.startsWith("mobile")) {
            return null;
        }
        if (!isMoblie && modelType.startsWith("mobile")) {
            return null;
        }
        this.showForm(number, modelType);
        return null;
    }

    public boolean needSelectData() {
        return false;
    }

    private void showForm(String number, String modelType) {
        Class<?> clasz = this.getpType().get(modelType);
        if (clasz == null) {
            return;
        }
        FormShowParameter showParameter = (FormShowParameter)TypesContainer.createInstance(clasz);
        OpenStyle openStyle = new OpenStyle();
        switch (modelType) {
            case "list": {
                ((ListShowParameter)showParameter).setBillFormId(number);
                openStyle.setShowType(ShowType.Modal);
                break;
            }
            case "mobilelist": {
                ((ListShowParameter)showParameter).setBillFormId(number);
                openStyle.setShowType(ShowType.Floating);
                break;
            }
            case "form": 
            case "bill": 
            case "base": {
                showParameter.setFormId(number);
                openStyle.setShowType(ShowType.Modal);
                break;
            }
            case "mobileform": {
                showParameter.setFormId(number);
                openStyle.setShowType(ShowType.Floating);
                break;
            }
            case "mobilebill": {
                String mobilebillnumber = (String)this.getParameter().get("mobilebillnumber");
                if (StringUtils.isNotBlank((CharSequence)mobilebillnumber)) {
                    showParameter.setFormId(mobilebillnumber);
                } else {
                    showParameter.setFormId(this.convertMobileBillNumber(number));
                }
                openStyle.setShowType(ShowType.Floating);
                break;
            }
        }
        if (StringUtils.isNotBlank(this.getParameter().get("showtype"))) {
            openStyle.setShowType(ShowType.forValue((int)Integer.parseInt((String)this.getParameter().get("showtype"))));
        }
        if (StringUtils.isNotBlank(this.getParameter().get("targetkey"))) {
            openStyle.setTargetKey((String)this.getParameter().get("targetkey"));
        }
        showParameter.setOpenStyle(openStyle);
        this.getView().showForm(showParameter);
    }

    private String convertMobileBillNumber(String number) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)number);
        if ("bill".equals(formConfig.getModelType())) {
            return number + "_mob";
        }
        return number;
    }

    private Map<String, Class<?>> getpType() {
        HashMap ptypes = new HashMap(16);
        ptypes.put("form", FormShowParameter.class);
        ptypes.put("bill", BillShowParameter.class);
        ptypes.put("base", BaseShowParameter.class);
        ptypes.put("list", ListShowParameter.class);
        ptypes.put("report", ReportShowParameter.class);
        ptypes.put("parameter", ParameterShowParameter.class);
        ptypes.put("mobilebase", MobileBaseShowParameter.class);
        ptypes.put("mobilebill", MobileBillShowParameter.class);
        ptypes.put("mobileform", MobileFormShowParameter.class);
        ptypes.put("mobilelist", MobileListShowParameter.class);
        ptypes.put("mobiletreelist", MobileListShowParameter.class);
        return ptypes;
    }
}

