/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.mobileop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.mvc.list.MobileListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;

public class MobToolBarSelect
extends DefaultDynamicFormOperate {
    private static final String MOBILE_SEARCH_AP = "mobilesearchap";
    private static final String CANCEL = "cancel";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ITEMS = "items";
    private static final String OPERATION_KEY = "opk";
    private static final String ID = "id";
    private static final String SET_CARD_SELECT_STATUS = "setCardSelectStatus";

    public boolean needSelectData() {
        return false;
    }

    @Override
    public OperationResult invokeOperation() {
        if (this.getView() instanceof MobileListView) {
            this.updateMobileSearch();
            this.updateBillList();
            this.updateBarItem();
        }
        return null;
    }

    private void updateMobileSearch() {
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl(MOBILE_SEARCH_AP);
        if (mobileSearch == null) {
            return;
        }
        HashMap<String, Integer> mobileSearchMeta = new HashMap<String, Integer>(1);
        mobileSearchMeta.put("showModel", 1);
        this.getView().updateControlMetadata(MOBILE_SEARCH_AP, mobileSearchMeta);
    }

    private void updateBillList() {
        MobileListView mobileListView = (MobileListView)this.getView();
        BillList billList = (BillList)mobileListView.getControl(BILL_LIST_AP);
        if (billList == null) {
            return;
        }
        HashMap<String, Boolean> billListMeta = new HashMap<String, Boolean>(1);
        billListMeta.put("ismul", billList.isMulti());
        this.getView().updateControlMetadata(BILL_LIST_AP, billListMeta);
        mobileListView.getClientProxy().invokeControlMethod(billList.getKey(), SET_CARD_SELECT_STATUS, new Object[]{true});
        mobileListView.clearSelection();
    }

    private void updateBarItem() {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(this.getEntityId(), RuntimeMetaType.MobList.getValue(), "mtoolbarap");
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        Map meta = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        if (CollectionUtils.isEmpty((Map)meta) || meta.get(ITEMS) == null) {
            return;
        }
        List itemList = (List)meta.get(ITEMS);
        ArrayList<String> hideKeys = new ArrayList<String>(itemList.size());
        ArrayList<String> showKeys = new ArrayList<String>(itemList.size());
        for (Map item : itemList) {
            Object interactionType = item.get("it");
            if (CANCEL.equals(item.get(OPERATION_KEY)) || interactionType != null && (Integer)interactionType == 1) {
                showKeys.add(item.get(ID).toString());
                continue;
            }
            hideKeys.add(item.get(ID).toString());
        }
        this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[hideKeys.size()]));
        this.getView().setVisible(Boolean.valueOf(true), showKeys.toArray(new String[showKeys.size()]));
    }
}

