/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.mobileop;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.FormViewPluginProxy;

public class MobileFormOp
extends DefaultDynamicFormOperate {
    public boolean needSelectData() {
        return false;
    }

    @Override
    protected OperationResult invokeOperation() {
        String opType;
        FormOperate formOperate = (FormOperate)FormMetadataCache.getFormOperation((String)this.getEntityId(), (String)this.getOperateKey());
        if (formOperate != null && (opType = formOperate.getType()) != null) {
            switch (opType.toLowerCase(Locale.ENGLISH)) {
                case "scanqrcode": {
                    this.scanQRCode();
                    break;
                }
                case "closewebview": {
                    this.closeWebView();
                    break;
                }
                case "previewimage": {
                    this.previewImage();
                    break;
                }
                case "getlocation": {
                    this.getLocation();
                    break;
                }
                case "selectpic": {
                    this.selectPic();
                    break;
                }
                case "callphone": {
                    this.callPhone();
                    break;
                }
                case "rotateui": {
                    this.rotateUI();
                    break;
                }
            }
        }
        return null;
    }

    private void scanQRCode() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        Map param = (Map)SerializationUtils.fromJsonString((String)this.getParameter().get("parameter").toString(), Map.class);
        Object needResult = param.get("needResult");
        int result = 1;
        if (needResult != null && "false".equals(needResult.toString())) {
            result = 0;
        }
        args.put("needResult", result);
        this.executeClientCommand("scanQRCode", args);
    }

    private void closeWebView() {
        this.executeClientCommand("closeWebView", new HashMap<String, Object>());
    }

    private void previewImage() {
        this.executeClientCommand("previewImage", new HashMap<String, Object>());
    }

    private void getLocation() {
        this.executeClientCommand("getLocation", new HashMap<String, Object>());
    }

    private void selectPic() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        Map param = (Map)SerializationUtils.fromJsonString((String)this.getParameter().get("parameter").toString(), Map.class);
        Object type = param.get("type");
        args.put("type", type);
        this.executeClientCommand("selectPic", args);
    }

    private void callPhone() {
        this.executeClientCommand("callPhone", new HashMap<String, Object>());
    }

    private void rotateUI() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        Map param = (Map)SerializationUtils.fromJsonString((String)this.getParameter().get("parameter").toString(), Map.class);
        Object type = param.get("direction");
        args.put("direction", type);
        this.executeClientCommand("rotateUI", args);
    }

    private void executeClientCommand(String methodName, Map<String, Object> args) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("method", methodName);
        data.put("args", args);
        FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        proxy.fireBeforeExecClientCmd(args, this.getOperateKey());
        this.getView().executeClientCommand("callAPPApi", new Object[]{data});
    }
}

