/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.report;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;

public class SyncExportExcel
extends DefaultDynamicFormOperate
implements IConfirmCallBack {
    private static final String REPORTLISTAP = "reportlistap";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    public static final String CUSTPARAM_ENTITYNAME = "entityname";
    public static final String CUSTPARAM_ENTITYNUMBER = "entitynumber";

    @Override
    public OperationResult invokeOperation() {
        if (this.isHasOtherTask()) {
            return null;
        }
        boolean largeData = false;
        if (this.getView() instanceof ReportView) {
            ReportView reportView = (ReportView)this.getView();
            largeData = reportView.isLargeData();
        }
        int records = 0;
        if (largeData) {
            ReportList reportList = (ReportList)this.getView().getControl(REPORTLISTAP);
            AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
            ReportByBatchTaskResult reportTaskResult = (ReportByBatchTaskResult)reportModel.getReportTaskResult();
            if (reportTaskResult != null) {
                records = reportTaskResult.getBatchLoadInfo().getEstimateTotalRowCount();
            }
        } else {
            records = this.getTotalRecords();
        }
        if (records <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u518d\u5c1d\u8bd5\u5bfc\u51fa\u3002", (String)"SyncExportExcel_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return null;
        }
        if (largeData) {
            this.showProgressForm(this.getPermissionItemId());
            return null;
        }
        if (records > 0) {
            String showMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa{0}\u6761\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u5bfc\u51fa\uff1f", (String)"SyncExportExcel_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), records);
            HashMap<String, String> callbackValue = new HashMap<String, String>();
            callbackValue.put("permissionItemId", this.getPermissionItemId());
            this.getView().showConfirm(showMsg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("SyncExportExcelConfirmCallBack", (IConfirmCallBack)this), null, SerializationUtils.toJsonString(callbackValue));
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String permissionItemId = null;
        String customVaule = messageBoxClosedEvent.getCustomVaule();
        if (StringUtils.isNotBlank((CharSequence)customVaule)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            permissionItemId = (String)map.get("permissionItemId");
        }
        this.showProgressForm(permissionItemId);
    }

    private void showProgressForm(String permissionItemId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_reportexportprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put(CUSTPARAM_ENTITYNUMBER, this.getView().getEntityId());
        showParameter.getCustomParams().put(CUSTPARAM_ENTITYNAME, this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("permissionItemId", permissionItemId);
        showParameter.getCustomParams().put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put("isReportExporting", "true");
    }

    private int getTotalRecords() {
        ReportList reportList = (ReportList)this.getView().getControl(REPORTLISTAP);
        return reportList.getTotalRecords();
    }

    private boolean isHasOtherTask() {
        if (this.getView() instanceof ReportView) {
            boolean hasOtherExport;
            boolean singleUserLimit;
            String sceneCode;
            ConcurrentScene scenes;
            ReportList reportList;
            ReportView view = (ReportView)this.getView();
            String msg = view.getReportCache().getExcptionMsg(view.getPageId());
            if (StringUtils.isBlank((CharSequence)msg)) {
                if ("true".equals(view.getPageCache().get("isReportSearching"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u7684\u67e5\u8be2\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u67e5\u8be2\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"SyncExportExcel_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return true;
                }
                if ("true".equals(view.getPageCache().get("isReportExporting"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u8fdb\u884c\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u5bfc\u51fa\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u65b0\u7684\u5bfc\u51fa\u3002", (String)"SyncExportExcel_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return true;
                }
            }
            if ((reportList = (ReportList)this.getView().getControl(REPORTLISTAP)) != null && (scenes = ConcurrentSceneManager.getScene((String)(sceneCode = reportList.getLimitSceneCode(ReportList.LimitType.EXPORT_LIMIT, reportList.getView().getEntityId())))) != null && scenes.isSingleUserLimit1() && (singleUserLimit = ConcurrencyLimiter.isLockingUser((String)sceneCode, (String)this.getEntityId())) && (hasOtherExport = ConcurrencyLimiter.isLockingUser((String)sceneCode, (String)this.getEntityId()))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u4e2d\u60a8\u5df2\u6709\u4e00\u6761\u5bfc\u51fa\u4efb\u52a1\u5728\u8fdb\u884c\uff0c\u786e\u5b9a\u9700\u8981\u7ed3\u675f\u8be5\u4efb\u52a1\u5e76\u91cd\u65b0\u5f00\u59cb\u5417\uff1f", (String)"SyncExportExcel_4", (String)"bos-form-mvc", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("ReportReExportCallBack", (IConfirmCallBack)this));
                return true;
            }
        }
        return false;
    }
}

