/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.designer.DesignerMetaDao;
import kd.bos.orm.query.QFilter;

public class BaseLayoutPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_FNUMBER = "fnumber";
    private static final String KEY_FNAME = "fname";
    private static final String MODEL_TYPE = "ModelType";
    private static final String BASEENTITYID = "BaseEntityId";
    private static final String BASE_FORM_MODEL = "BaseFormModel";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void registerListener(EventObject e) {
        Button btn = (Button)this.getControl(KEY_BTNOK);
        btn.addClickListener((ClickListener)this);
        Button btnCancel = (Button)this.getControl("btncancel");
        btnCancel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        if (((Button)evt.getSource()).getKey().equals(KEY_BTNOK)) {
            this.returnData();
        }
        this.getView().close();
    }

    public void beforeBindData(EventObject e) {
        String baseEntitId;
        Map map;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object ctx = formShowParameter.getCustomParam("context");
        if (ctx == null) {
            return;
        }
        if (ctx instanceof Map) {
            map = (Map)ctx;
        } else {
            List list = SerializationUtils.fromJsonStringToList((String)ctx.toString(), Map.class);
            if (list.size() > 0) {
                map = (Map)list.get(0);
            } else {
                return;
            }
        }
        String modelType = BASE_FORM_MODEL;
        if ("UserField".equals(map.get("_Type_"))) {
            baseEntitId = "68bde9ca00000eac";
        } else {
            if (!map.containsKey(BASEENTITYID)) {
                return;
            }
            baseEntitId = map.get(BASEENTITYID).toString();
        }
        if (map.containsKey(MODEL_TYPE)) {
            modelType = map.get(MODEL_TYPE).toString();
        }
        QFilter[] filters = new QFilter[]{new QFilter("basedatafield", "=", (Object)baseEntitId), new QFilter("id", "!=", (Object)baseEntitId), StringUtils.isNotEmpty((CharSequence)modelType) ? new QFilter("modeltype", "=", (Object)modelType) : new QFilter("modeltype", "!=", (Object)"PrintModel")};
        DynamicObject[] formMetas = new DesignerMetaDao().getFormDesignMeta("id,name,number", filters);
        if (formMetas != null && formMetas.length > 0) {
            this.getModel().batchCreateNewEntryRow("layoutlist", formMetas.length);
            int i = 0;
            for (DynamicObject formMeta : formMetas) {
                this.getModel().setValue("fieldnumber", formMeta.get("number"), i);
                this.getModel().setValue("fieldfid", formMeta.get("id"), i);
                this.getModel().setValue("layoutname", formMeta.get("name"), i);
                ++i;
            }
        }
    }

    private void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            this.getView().returnDataToParent(row);
        }
    }

    private Map<String, Object> getCurrentSelector() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("layoutlist");
        int[] indexs = entryGrid.getEntryState().getSelectedRows();
        if (indexs == null || indexs.length == 0) {
            return null;
        }
        String fieldnumber = this.getModel().getValue("fieldnumber", indexs[0]).toString();
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", fieldnumber);
        para.put("alias", fieldnumber);
        para.put("name", this.getModel().getValue("layoutname", indexs[0]));
        para.put("id", this.getModel().getValue("fieldfid", indexs[0]));
        return para;
    }
}

