/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.util.CollectionUtils;

public class BillConfirmCallBackPlugin
implements IConfirmCallBack {
    private static final String SPAN_TYPE_NAME = "formview";
    private static final Log log = LogFactory.getLog(BillConfirmCallBackPlugin.class);

    public void confirmCallBack(MessageBoxClosedEvent e) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"BillConfirmCallBackPlugin.confirmCallBack");){
            span.addTag("callBackId", e.getCallBackId());
            Object source = e.getSource();
            if (source instanceof IFormView) {
                IFormView view = (IFormView)source;
                if ("billController_lockedConfirm".equalsIgnoreCase(e.getCallBackId())) {
                    if (e.getResult() == MessageBoxResult.Yes || e.getResult() == MessageBoxResult.OK) {
                        Map lockRequireInfo = (Map)SerializationUtils.fromJsonString((String)e.getCustomVaule(), Map.class);
                        String entityKey = (String)lockRequireInfo.get("MUTEX_ENTITY_KEY");
                        String operationKey = (String)lockRequireInfo.get("MUTEX_OPER_KEY");
                        String pkValue = (String)lockRequireInfo.get("MUTEX_OBJ_ID");
                        span.addTag("MUTEX_ENTITY_KEY", entityKey);
                        span.addTag("MUTEX_OPER_KEY", operationKey);
                        span.addTag("MUTEX_OBJ_ID", pkValue);
                        Map<String, String> lockInfo = this.getLockInfo(entityKey, operationKey, pkValue);
                        if (!CollectionUtils.isEmpty(lockInfo) && StringUtils.equals((CharSequence)RequestContext.get().getUserId(), (CharSequence)lockInfo.get("userid")) && StringUtils.equals((CharSequence)"modify", (CharSequence)lockInfo.get("opkey"))) {
                            IFormMutexService service = (IFormMutexService)view.getService(IFormMutexService.class);
                            if (service != null) {
                                service.destoryLockingPage(entityKey, (Object)pkValue, operationKey, true, Collections.singletonList(view.getPageId()));
                            } else {
                                MutexHelper.clearErrLockByWebSocket((String)entityKey, (Object)pkValue, (String)operationKey);
                            }
                            view.invokeOperation("modify");
                        } else {
                            view.showTipNotification(this.recordFailTip(lockInfo).toString());
                        }
                    }
                    view.getPageCache().remove("billController:lockedConfirm");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getLockInfo(String entityKey, String operationKey, String objId) {
        if (!StringUtils.isNotBlank((CharSequence)entityKey)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)objId)) return Collections.emptyMap();
        if (!StringUtils.isNotBlank((CharSequence)operationKey)) return Collections.emptyMap();
        String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.getLockInfo(objId, groupId, entityKey);
            return map;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return Collections.emptyMap();
    }

    private StringBuilder recordFailTip(Map<String, String> lockInfo) {
        StringBuilder errMsg = new StringBuilder();
        if (!CollectionUtils.isEmpty(lockInfo)) {
            String userIdStr = lockInfo.get("userid");
            if (userIdStr != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
            }
            errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"BillConfirmCallBackPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
        } else {
            errMsg.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"BillConfirmCallBackPlugin_2", (String)"bos-form-business", (Object[])new Object[0]));
        }
        return errMsg;
    }
}

