/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizOverallPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static final String TREE_KEY = "treebizoverall";
    private static final String KEY_CLOUD = "bizcloud";
    private static final String OPERATEENTRYKEY = "entryoperate";
    private static final String TABLEENTRYKEY = "entrytable";
    private static final String PRINTENTRYKEY = "entryprt";
    private static final String NODE_APP = "app_";
    private static final String NODE_BIZ = "biz_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_KEY);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase(KEY_CLOUD)) {
            String bizcloud = ((DynamicObject)this.getModel().getValue(KEY_CLOUD)).getString("id");
            this.initAllBizApps2TreebyCloudId(bizcloud);
        }
    }

    private void initAllBizApps2TreebyCloudId(String bizcloud) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_KEY);
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizOverallPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        treeView.addNode(root);
        JSONArray array = BizAppServiceHelp.getAllAppInfo();
        String localeId = RequestContext.get().getLang().toString();
        block0: for (Object object : array) {
            JSONArray group = (JSONArray)object;
            TreeNode nodeApp = null;
            int i = 0;
            for (Object item : group) {
                JSONObject obj = (JSONObject)item;
                if (i == 0) {
                    if (!obj.getString("id").equals(bizcloud)) {
                        continue block0;
                    }
                } else {
                    nodeApp = new TreeNode();
                    String appId = obj.getString("id");
                    String nodeID = NODE_APP + appId;
                    JSONObject name = (JSONObject)obj.get((Object)"name");
                    nodeApp.setText(name.getString(localeId));
                    nodeApp.setParentid("0");
                    nodeApp.setId(nodeID);
                    nodeApp.setData((Object)"app");
                    HashMap<String, TreeNode> bizGroup = new HashMap<String, TreeNode>();
                    DynamicObjectCollection entityobjects = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,number,name,modeltype,bizappid", (QFilter[])new QFilter[]{new QFilter("bizappid", "=", (Object)appId)});
                    for (DynamicObject objBiz : entityobjects) {
                        String modelType = objBiz.getString("modeltype");
                        if (!bizGroup.containsKey(modelType)) {
                            String bizappId = objBiz.getString("bizappid");
                            String modelTypeName = DomainModelType.getDomainModelType((String)modelType).getName().getLocaleValue();
                            TreeNode nodebizGroup = new TreeNode();
                            nodebizGroup.setText(modelTypeName);
                            nodebizGroup.setId(bizappId + modelType);
                            nodebizGroup.setParentid(NODE_APP + bizappId);
                            bizGroup.put(modelType, nodebizGroup);
                        }
                        TreeNode parentNode = (TreeNode)bizGroup.get(modelType);
                        TreeNode nodeBiz = new TreeNode();
                        String currentnodeId = NODE_BIZ + objBiz.getString("id");
                        String currentname = objBiz.getString("name");
                        nodeBiz.setText(currentname);
                        nodeBiz.setParentid(modelType);
                        nodeBiz.setId(currentnodeId);
                        nodeBiz.setData((Object)"biz");
                        parentNode.addChild(nodeBiz);
                    }
                    for (TreeNode gn : bizGroup.values()) {
                        nodeApp.addChild(gn);
                    }
                }
                ++i;
                root.addChild(nodeApp);
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (nodeId.contains(NODE_BIZ)) {
            this.clearData();
            String entityNumber = StringUtils.substringAfter((String)nodeId, (String)"_");
            this.dealOperate(entityNumber);
            this.dealTable(entityNumber);
            this.dealPrint(entityNumber);
        }
    }

    private void dealOperate(String entityNumber) {
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        for (Map op : dataEntityOperate) {
            int iRow = this.getModel().createNewEntryRow(OPERATEENTRYKEY);
            DynamicObject row = this.getModel().getEntryRowEntity(OPERATEENTRYKEY, iRow);
            HashMap name = (HashMap)op.get("name");
            String localeId = RequestContext.get().getLang().toString();
            String lname = name.get(localeId).toString();
            row.set("operatename", (Object)lname);
        }
        this.getView().updateView(OPERATEENTRYKEY);
    }

    private void dealTable(String entityNumber) {
        MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        Map entitys = entity.getAllEntities();
        for (EntityType et : entitys.values()) {
            int iRow = this.getModel().createNewEntryRow(TABLEENTRYKEY);
            String name = et.getAlias();
            this.getModel().setValue("tablename", (Object)name, iRow);
        }
    }

    private void dealPrint(String entityNumber) {
        ArrayList names = new ArrayList();
        String sql = "select t0.fnumber, t1.fname   from t_meta_formdesign t0   left join t_meta_formdesign_l t1 on (t0.fid = t1.fid and t1.flocaleid = ?)  where t0.fmodeltype = ?    and t0.fentityid = (select fid from t_meta_formdesign where fnumber =  ?) ";
        Object[] sqlParams = new SqlParameter[]{new SqlParameter(":FLocaleId", 12, (Object)Lang.get().toString()), new SqlParameter(":FModelType", 12, (Object)"PrintModel"), new SqlParameter(":FNumber", 12, (Object)entityNumber)};
        ResultSetHandler action = rs -> {
            while (rs.next()) {
                String name = rs.getString(2);
                names.add(name);
            }
            return true;
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParams, (ResultSetHandler)action);
        for (String name : names) {
            int iRow = this.getModel().createNewEntryRow(PRINTENTRYKEY);
            this.getModel().setValue("prtname", (Object)name, iRow);
        }
    }

    private void clearData() {
        this.getModel().deleteEntryData(OPERATEENTRYKEY);
        this.getModel().deleteEntryData(TABLEENTRYKEY);
        this.getModel().deleteEntryData(PRINTENTRYKEY);
    }
}

