/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.flex.FlexService;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.flex.IFlexEdit;
import kd.bos.form.flex.IFlexFormPlugin;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.util.StringUtils;

public class FlexFormPlugin
extends AbstractFormPlugin
implements IFlexFormPlugin {
    private static Log log = LogFactory.getLog(FlexFormPlugin.class);
    private FieldEdit parentFieldEdit;

    public void setFlexParameter(IDataModel flexDataModel, FieldEdit parentFieldEdit) {
        this.parentFieldEdit = parentFieldEdit;
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        IClientViewProxy proxy = (IClientViewProxy)button.getView().getService(IClientViewProxy.class);
        this.setView(button.getView());
        String[] buttonKeys = button.getKey().split("__");
        switch (buttonKeys[1]) {
            case "btnok": {
                this.save();
                this.closeFlexPanel(proxy);
                break;
            }
            case "btncancel": {
                this.closeFlexPanel(proxy);
                break;
            }
        }
    }

    private void closeFlexPanel(IClientViewProxy proxy) {
        FlexProp flexProp = this.getFlexProp();
        FlexType flexType = FlexEntityMetaUtils.getFlexType((int)flexProp.getFlexTypeId());
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        FlexBeforeClosedEvent event = new FlexBeforeClosedEvent((Object)this.getView());
        event.setBasedataKey(flexProp.getBasePropertyKey());
        event.setFlexKey(flexProp.getName());
        pluginProxy.fireFlexBeforeClosed(event);
        if (event.isCancel()) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flexId", flexType.getFormNumber() + "__" + flexProp.getBasePropertyKey());
        if (this.isEntryProperty((IDataEntityProperty)flexProp)) {
            String entryKey = flexProp.getParent().getName();
            proxy.invokeControlMethod(entryKey, "closeFlexible", new Object[]{map});
        } else {
            proxy.invokeControlMethod(this.parentFieldEdit.getKey(), "closeFlexible", new Object[]{map});
        }
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    private void save() {
        IFlexEdit be = (IFlexEdit)this.getControl(this.parentFieldEdit.getKey());
        MainEntityType entityType = be.getFlexModel().getDataEntityType();
        DynamicObject data = be.getFlexModel().getDataEntity();
        try {
            FlexEntireData fet = new FlexEntireData();
            fet.setFlexData(entityType, data);
            Long id = FlexService.saveFlexData((MainEntityType)entityType, (FlexEntireData)fet);
            if (entityType instanceof FlexEntityType) {
                FlexService.addRefrenceCount((FlexEntityType)((FlexEntityType)entityType), (DynamicObject[])new DynamicObject[]{data});
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)entityType);
                cacheManager.removeByPrimaryKey(new Object[]{id});
            }
            entityType.getPrimaryKey().setValue((Object)data, (Object)id);
        }
        catch (Exception e) {
            data = null;
            be.getFlexModel().createNewData();
            be.getFlexModel().updateCache();
            log.error("\u5f39\u6027\u57df\u6570\u636e\u4fdd\u5b58\u9519\u8bef", (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u6570\u636e\u4fdd\u5b58\u9519\u8bef\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"FlexFormPlugin_0", (String)"bos-form-business", (Object[])new Object[0]), e.getMessage()));
        }
        Map<String, Object> clientMap = FlexFormPlugin.createBaseEditFlexClientData(entityType, data);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.parentFieldEdit.getKey(), "flexData", clientMap);
    }

    private void setFlexFieldValue(long id, Map<String, Object> map) {
        FlexProp flexProp = this.getFlexProp();
        if (flexProp != null) {
            DynamicObject flexObj = (DynamicObject)flexProp.getComplexType().createInstance();
            flexObj.set("id", (Object)id);
            flexObj.set("value", (Object)SerializationUtils.toJsonString(map));
            int index = -1;
            if (!StringUtils.isEmpty((String)this.parentFieldEdit.getEntryKey())) {
                index = this.getModel().getEntryCurrentRowIndex(this.parentFieldEdit.getEntryKey());
            }
            this.getModel().setValue(flexProp.getName(), (Object)flexObj, index);
        }
    }

    private String getFlexFieldKey(String fieldKey) {
        String parentFieldKey = this.parentFieldEdit.getKey();
        return String.format("$$%s__%s", parentFieldKey, fieldKey);
    }

    private FlexProp getFlexProp() {
        String flexKey = this.parentFieldEdit.getKey();
        if (StringUtils.isBlank((String)flexKey)) {
            return new FlexProp();
        }
        return (FlexProp)this.getModel().getDataEntityType().findProperty(flexKey);
    }

    private static Map<String, Object> createBaseEditFlexClientData(MainEntityType entityType, DynamicObject data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object arr;
            if (data == null && (prop instanceof BasedataProp || prop instanceof AssistantProp || prop instanceof TextProp)) {
                map.put(prop.getName(), "");
                continue;
            }
            if (prop instanceof BasedataProp) {
                arr = FlexFormPlugin.getBasedataDisplayVal((BasedataProp)prop, (DynamicObject)prop.getValue((Object)data));
                map.put(prop.getName(), arr);
                continue;
            }
            if (prop instanceof AssistantProp) {
                arr = FlexFormPlugin.getBasedataDisplayVal((BasedataProp)((AssistantProp)prop), (DynamicObject)prop.getValue((Object)data));
                map.put(prop.getName(), arr);
                continue;
            }
            if (!(prop instanceof TextProp)) continue;
            Object text = prop.getValue((Object)data);
            map.put(prop.getName(), text);
        }
        return map;
    }

    private static Object getBasedataDisplayVal(BasedataProp prop, DynamicObject data) {
        IDataEntityProperty p2;
        Object[] arr = new Object[2];
        BasedataEntityType dt = (BasedataEntityType)prop.getComplexType();
        String nameKey = dt.getNameProperty();
        String numberKey = dt.getNumberProperty();
        IDataEntityProperty p1 = dt.findProperty(numberKey);
        if (p1 != null && data != null) {
            arr[0] = p1.getValueFast((Object)data);
        }
        if ((p2 = dt.findProperty(nameKey)) != null && data != null) {
            arr[1] = p2.getValueFast((Object)data);
            if (arr[1] instanceof ILocaleString) {
                arr[1] = arr[1].toString();
            }
        }
        if (StringUtils.isBlank((String)nameKey)) {
            arr[0] = arr[1];
        }
        return arr;
    }
}

