/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FlexPropertyConditionPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    static final String FilterGridAp = "filtergridap";
    static final String Key_TreeView = "tv_fields";
    static final String Key_btnFunction = "btnfunction";
    static final String Key_btnClr = "clr";
    static final String Key_btnBackSpace = "backspace";
    private static final String EXPRESSION = "expression";
    private static final String BASEFORMID = "baseformid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{Key_btnFunction, Key_btnClr, Key_btnBackSpace});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.createFilterGrid();
    }

    public void afterBindData(EventObject e) {
        MainEntityType met;
        String formId;
        String filterjson = (String)this.getView().getFormShowParameter().getCustomParam("filterjson");
        FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
        FlexBDValueCondition fc = null;
        if (StringUtils.isNotBlank((CharSequence)filterjson)) {
            fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)filterjson, FlexBDValueCondition.class);
            filterGrid.SetValue(fc.getFilterCondition());
            this.getModel().setValue(EXPRESSION, (Object)fc.getExpression());
        }
        if (StringUtils.isNotBlank((CharSequence)(formId = (String)this.getView().getFormShowParameter().getCustomParam(BASEFORMID))) && (met = EntityMetadataCache.getDataEntityType((String)formId)) instanceof BasedataEntityType) {
            this.addTreeRootNode(met.getFields());
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FilterGridAp);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            String formId = (String)this.getView().getFormShowParameter().getCustomParam(BASEFORMID);
            FilterBuilder filterBuilder = this.getFilterBuilder(formId, filterCondition);
            String filter = filterBuilder.getFilterObject().getFilterResult().getFilterGroup()[0];
            FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
            flexPropertyCon.setDescription(new LocaleString(filter));
            flexPropertyCon.setFilterCondition(filterCondition);
            flexPropertyCon.setExpression((String)this.getModel().getValue(EXPRESSION));
            String condition = SerializationUtils.toJsonString((Object)flexPropertyCon);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("display", filter);
            data.put("value", condition);
            this.getView().returnDataToParent(data);
            this.getView().close();
        } else if (Key_btnFunction.equals(key)) {
            this.showFuncSetting();
        } else if (Key_btnClr.equals(key)) {
            this.getModel().setValue(EXPRESSION, (Object)"");
        } else {
            this.clickCompareButton(key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_btnFunction)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.insertExpression(this.getView(), Key_btnFunction, EXPRESSION, (String)closedCallBackEvent.getReturnData());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.insertExpression(this.getView(), Key_TreeView, EXPRESSION, e.getNodeId().toString());
    }

    private void createFilterGrid() {
        FormShowParameter paramter = this.getView().getFormShowParameter();
        String formId = (String)paramter.getCustomParam(BASEFORMID);
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            this.filterGridSetFieldColumns(FilterGridAp, formId, true);
        }
    }

    private void filterGridSetFieldColumns(String controlKey, String entityNumber, boolean isAddedBtn) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(controlKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        filterGrid.setEntityNumber(entityType.getName());
        if (!isAddedBtn) {
            filterGrid.setBtnStatus();
        }
    }

    private FilterBuilder getFilterBuilder(String entityNumber, FilterCondition filterCondition) {
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, false);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    private void addTreeRootNode(Map<String, IDataEntityProperty> fields) {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"FlexPropertyConditionPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        for (IDataEntityProperty prop : fields.values()) {
            TreeNode tn = new TreeNode("0", prop.getName(), prop.getDisplayName().toString());
            root.addChild(tn);
        }
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            this.insertExpression(this.getView(), compareKey, EXPRESSION, compareValue);
        }
    }

    private void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int pos = this.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = pos;
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = expression.length();
        } else {
            String insertStr = " " + str + " ";
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put("cursorIndex", cursorIndex);
        cursorMap.put("ctrlKey", textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
    }

    private String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    public int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    private void showFuncSetting() {
        String funcsXML = "";
        FunctionType func = new FunctionType();
        func.setId("20200218");
        func.setSeq(10);
        func.setName(new LocaleString(ResManager.loadKDString((String)"\u53d6\u5f39\u6027\u57df\u5c5e\u6027", (String)"FlexPropertyConditionPlugin_1", (String)"bos-form-business", (Object[])new Object[0])));
        func.setGroupId("Common");
        func.setDef("getFlexPropertyValue(PropertyId)");
        func.setDesc(new LocaleString(String.format(ResManager.loadKDString((String)"1.\u51fd\u6570\u63cf\u8ff0\uff1a\u83b7\u53d6\u6307\u5b9a\u5f39\u6027\u57df\u5c5e\u6027\u7684\u503c%s 2.\u51fd\u6570\u683c\u5f0f\uff1agetFlexPropertyValue(PropertyId) 3.\u51fd\u6570\u53c2\u6570\uff1aPropertyId  \u5f39\u6027\u57df\u5c5e\u6027\u7684id 4.\u4e3e\u4f8b\uff1a\u7565 ", (String)"FlexPropertyConditionPlugin_5", (String)"bos-form-business", (Object[])new Object[0]), System.lineSeparator())));
        func.setReturnType("Object");
        FunctionTypes functionTypes = FunctionTypes.get();
        functionTypes.getFunctionTypes().clear();
        functionTypes.getFunctionTypes().add(func);
        String xml = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
        String jsonNode = "";
        String entityNumber = "";
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_btnFunction);
        FuncSettingHelper.show((String)xml, (String)"", null, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }
}

