/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.FlexGridConfigRow;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.operate.SetEntryBottom;
import kd.bos.form.operate.SetEntryTop;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.constant.UserParaType;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.product.ProductSettingService;
import kd.bos.report.ReportList;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class GridConfigPlugin
extends AbstractFormPlugin
implements TabSelectListener,
EntryGridBindDataListener {
    private static final String OPTIONTAB = "optiontab";
    private static final String TAG_ISRESET = "isreset";
    private static final String KEY_ADVCON_TOOLBARAP = "advcontoolbarap";
    private static final String KEY_BUTTON_ALL_ACTIVE = "btnallactive";
    private static final String KEY_BUTTON_ALL_FIXED = "btnallfiexd";
    private static final String KEY_BUTTON_ALL_SHOW = "btnallshow";
    private static final String KEY_BUTTON_ALL_HIDE = "btnallhide";
    private static final String KEY_BUTTON_RESET = "btnreset";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_CONFIRM = "btnconfirm";
    private static final String KEY_BUTTON_UP = "btnmoveup";
    private static final String KEY_BUTTON_DOWN = "btnmovedown";
    private static final String KEY_BARITEM_RESET = "reset";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_COLWIDTH = "colwidth";
    private static final String KEY_TEXTALIGN = "textalign";
    private static final String KEY_HIDE = "hide";
    private static final String KEY_FREEZE = "freeze";
    private static final String KEY_FREEZER = "freezer";
    private static final String GRIDCONFIG = "gridConfig";
    private static final String RESETGRIDCONFIG = "resetGridConfig";
    private static final String FLEXGRIDCONFIG = "flexGridConfig";
    private static final String ORIGINSEQS = "originSeqs";
    private static final String IS_RESET = "isReset";
    private static final String ACTION = "action";
    private static final String GRIDCONFIGKEY = "gridConfigKey";
    private static final String ENTRYENTITY = "entryEntity";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String KEY_BUTTON_SET_TOP = "btnsettop";
    private static final String KEY_BUTTON_SET_BOTTOM = "btnsetbottom";
    private static final String LIST_OPTION_PAGE_ID = "listOptionPageId";
    private static final String FLEX_SET = "flexset";
    private static final String FLEX_SET_PREFIX = "flexset_";
    private static final String REP_FLEX_CHILDREN_LIST = "rep_flex_children_list";
    private static final String IS_SHOW_ZERO = "isShowZero";
    private static final String FLEX_SPLIT = "flexsplit";
    private static final String FLEX_MERGE = "flexmerge";
    private static final String FLEX_MERGE_STAT = "0";
    private static final String FLEX_SPLIT_STAT = "1";
    private static final int FLEX_NOSET_STAT = -1;
    private static final String SOURCE_TYPE = "sourceType";
    List<FlexGridConfigRow> flexGridConfigRows = null;

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addPackageDataListener(pkEvent -> {
            if (pkEvent.getSource() instanceof OperationColumn && FLEX_SET.equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                String flexSet = this.getPageCache().get(FLEX_SET_PREFIX + pkEvent.getRowData().getString(KEY_FIELDKEY));
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    if ((FLEX_SPLIT.equalsIgnoreCase(operationKey) || FLEX_MERGE.equalsIgnoreCase(operationColItem.getOperationKey())) && StringUtils.isBlank((CharSequence)flexSet)) {
                        operationColItem.setVisible(false);
                        continue;
                    }
                    if (FLEX_MERGE.equalsIgnoreCase(operationKey) && FLEX_MERGE_STAT.equals(flexSet)) {
                        operationColItem.setVisible(false);
                        continue;
                    }
                    if (!FLEX_SPLIT.equalsIgnoreCase(operationKey) || !FLEX_SPLIT_STAT.equals(flexSet)) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_CONFIRM});
        this.addItemClickListeners(new String[]{KEY_ADVCON_TOOLBARAP, KEY_BUTTON_SET_TOP, KEY_BUTTON_SET_BOTTOM});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String flexGridConfigRowStr = (String)this.getView().getFormShowParameter().getCustomParam(FLEXGRIDCONFIG);
        if (StringUtils.isBlank((CharSequence)flexGridConfigRowStr) || StringUtils.equals((CharSequence)flexGridConfigRowStr, (CharSequence)"[]")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_SET});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (FLEX_SPLIT.equals(operateKey) || FLEX_MERGE.equals(operateKey)) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(ENTRYENTITY);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            String fieldName = (String)this.getModel().getValue(KEY_FIELDKEY, entryCurrentRowIndex);
            if (FLEX_SPLIT.equals(operateKey)) {
                this.getPageCache().put(FLEX_SET_PREFIX + fieldName, FLEX_SPLIT_STAT);
                String sourceType = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE);
                if (StringUtils.isNotEmpty((CharSequence)sourceType) && StringUtils.equals((CharSequence)sourceType, (CharSequence)"report")) {
                    this.hideFlexWhenMaxSizeLessen();
                }
            } else {
                this.getPageCache().put(FLEX_SET_PREFIX + fieldName, FLEX_MERGE_STAT);
                List<GridConfigurationRow> configurationRowList = this.getGridConfigRows();
                String str = this.getChildrenListStr(configurationRowList);
                this.getPageCache().put(REP_FLEX_CHILDREN_LIST, str);
            }
            this.getPageCache().put(IS_RESET, "false");
            List<GridConfigurationRow> currentFields = this.covertToBeanList();
            String flexGridConfigRowStr = (String)this.getView().getFormShowParameter().getCustomParam(FLEXGRIDCONFIG);
            if (StringUtils.isNotBlank((CharSequence)flexGridConfigRowStr)) {
                this.flexGridConfigRows = SerializationUtils.fromJsonStringToList((String)flexGridConfigRowStr, FlexGridConfigRow.class);
                if (this.flexGridConfigRows != null) {
                    for (GridConfigurationRow curFld : currentFields) {
                        for (GridConfigurationRow gridConfigurationRow : this.flexGridConfigRows) {
                            if (!StringUtils.equals((CharSequence)curFld.getFieldKey(), (CharSequence)gridConfigurationRow.getFieldKey())) continue;
                            curFld.setChildren(gridConfigurationRow.getChildren());
                        }
                    }
                }
            }
            this.getModel().beginInit();
            this.convertToModel(currentFields);
            this.getModel().endInit();
            entryGrid.expand(entryCurrentRowIndex);
        }
    }

    private void hideFlexWhenMaxSizeLessen() {
        List<GridConfigurationRow> configRows = this.getGridConfigRows();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        ReportList reportList = (ReportList)parentView.getControl("reportlistap");
        if (reportList == null) {
            return;
        }
        if (CollectionUtils.isEmpty(configRows)) {
            return;
        }
        if (parentView.getPageCache().get("flexFieldKeys") == null || parentView.getPageCache().get("flexFieldCanSplitMap") == null || parentView.getPageCache().get("flexMaxSizeShowMap") == null || parentView.getPageCache().get("isDefaultSplitMap") == null) {
            return;
        }
        Map<String, Integer> configLastFlexMaxSizeMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getLastFlexMaxSize, (o, o2) -> o));
        if (CollectionUtils.isEmpty(configLastFlexMaxSizeMap)) {
            return;
        }
        List flexFieldList = SerializationUtils.fromJsonStringToList((String)parentView.getPageCache().get("flexFieldKeys"), String.class);
        Map flexMaxSizeShowMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexMaxSizeShowMap"), Map.class);
        Map<String, LocaleString> configFieldKeyAndNameMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFieldName));
        for (String fieldKey : flexFieldList) {
            if (!configLastFlexMaxSizeMap.containsKey(fieldKey) || !flexMaxSizeShowMap.containsKey(fieldKey) || configLastFlexMaxSizeMap.get(fieldKey) <= Integer.parseInt((String)flexMaxSizeShowMap.get(fieldKey))) continue;
            this.showFlexExtendMaxTips(configFieldKeyAndNameMap.get(fieldKey).toString(), Integer.parseInt((String)flexMaxSizeShowMap.get(fieldKey)));
        }
    }

    private String getChildrenListStr(List<GridConfigurationRow> configurationRowList) {
        ArrayList list = new ArrayList();
        for (GridConfigurationRow row : configurationRowList) {
            if (row.getChildren().size() <= 0) continue;
            HashMap<String, List> map = new HashMap<String, List>();
            map.put(row.getFieldKey(), row.getChildren());
            list.add(map);
        }
        return SerializationUtils.toJsonString(list);
    }

    public void afterCreateNewData(EventObject e) {
        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(RESETGRIDCONFIG);
        if (StringUtils.isBlank((CharSequence)configRowsStr)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_RESET});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_COLWIDTH});
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE);
        if (StringUtils.isNotEmpty((CharSequence)sourceType) && StringUtils.equals((CharSequence)sourceType, (CharSequence)"report")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            String caption = ResManager.loadKDString((String)"\u5217\u51bb\u7ed3", (String)"GridConfigPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
            entryGrid.setColumnProperty(KEY_FREEZE, "header", (Object)caption);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FREEZER});
        }
        List<GridConfigurationRow> configRows = this.getGridConfigRows();
        this.convertToModel(configRows);
        HashMap<String, Integer> originSeqs = new HashMap<String, Integer>(16);
        DynamicObjectCollection cols = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (int i = 0; i < cols.size(); ++i) {
            originSeqs.put(((DynamicObject)cols.get(i)).getString(KEY_FIELDKEY), ((DynamicObject)cols.get(i)).getInt("seq"));
        }
        this.getView().getPageCache().put(ORIGINSEQS, SerializationUtils.toJsonString(originSeqs));
        if (StringUtils.isNotEmpty((CharSequence)sourceType) && StringUtils.equals((CharSequence)sourceType, (CharSequence)"report")) {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            ReportList reportList = (ReportList)parentView.getControl("reportlistap");
            if (reportList == null) {
                return;
            }
            if (CollectionUtils.isEmpty(configRows)) {
                return;
            }
            if (parentView.getPageCache().get("flexFieldKeys") == null || parentView.getPageCache().get("flexFieldCanSplitMap") == null || parentView.getPageCache().get("flexMaxSizeShowMap") == null || parentView.getPageCache().get("isDefaultSplitMap") == null) {
                return;
            }
            Map<String, Integer> configLastFlexMaxSizeMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getLastFlexMaxSize, (o, o2) -> o));
            Map<String, Integer> configFlexSplitMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
            List flexFieldList = SerializationUtils.fromJsonStringToList((String)parentView.getPageCache().get("flexFieldKeys"), String.class);
            Map flexFieldCanSplitMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexFieldCanSplitMap"), Map.class);
            Map flexMaxSizeShowMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexMaxSizeShowMap"), Map.class);
            Map defaultSplitMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("isDefaultSplitMap"), Map.class);
            Map<String, LocaleString> configFieldKeyAndNameMap = configRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFieldName));
            for (String fieldKey : flexFieldList) {
                if ((!((Boolean)flexFieldCanSplitMap.get(fieldKey)).booleanValue() || !((Boolean)defaultSplitMap.get(fieldKey)).booleanValue()) && (!((Boolean)flexFieldCanSplitMap.get(fieldKey)).booleanValue() || !configFlexSplitMap.containsKey(fieldKey) || configFlexSplitMap.get(fieldKey) != 1) || !configLastFlexMaxSizeMap.containsKey(fieldKey) || !flexMaxSizeShowMap.containsKey(fieldKey) || configLastFlexMaxSizeMap.get(fieldKey) <= Integer.parseInt((String)flexMaxSizeShowMap.get(fieldKey)) || !configFlexSplitMap.containsKey(fieldKey) || configFlexSplitMap.get(fieldKey) != 1) continue;
                this.showFlexExtendMaxTips(configFieldKeyAndNameMap.get(fieldKey).toString(), Integer.parseInt((String)flexMaxSizeShowMap.get(fieldKey)));
                this.hideFlex(Integer.parseInt((String)flexMaxSizeShowMap.get(fieldKey)), fieldKey, flexFieldCanSplitMap);
            }
        }
    }

    private void hideFlex(int maxSize, String fieldKey, Map<String, Boolean> flexFieldCanSplitMap) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Long> flexFieldPkIdList = new ArrayList<Long>();
        if (!flexFieldCanSplitMap.containsKey(fieldKey)) {
            return;
        }
        for (DynamicObject obj : collection) {
            if (!fieldKey.equals(obj.getString(KEY_FIELDKEY))) continue;
            flexFieldPkIdList.add(Long.valueOf(obj.getPkValue().toString()));
            break;
        }
        for (Long parentId : flexFieldPkIdList) {
            this.hideFlexByParentId(collection, parentId, maxSize);
        }
    }

    private void hideFlexByParentId(DynamicObjectCollection dynamicObjectCollection, long pid, int maxSize) {
        int count = 0;
        if (pid > 0L) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long parentId = dynamicObject.getLong("pid");
                boolean isHide = dynamicObject.getBoolean(KEY_HIDE);
                if (pid == parentId && !isHide) {
                    ++count;
                }
                if (pid != parentId || count <= maxSize) continue;
                dynamicObject.set(KEY_HIDE, (Object)true);
            }
        }
    }

    protected List<GridConfigurationRow> getGridConfigRows() {
        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(GRIDCONFIG);
        List configRows = null;
        if (StringUtils.isNotBlank((CharSequence)configRowsStr)) {
            configRows = SerializationUtils.fromJsonStringToList((String)configRowsStr, GridConfigurationRow.class);
            String entityNum = this.getEntityNum();
            if (configRows != null && StringUtils.isNotBlank((CharSequence)entityNum)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId());
                ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
                List blackFields = productService.getFormDisVisitField(entityNum);
                ArrayList<GridConfigurationRow> visiableConfigRows = new ArrayList<GridConfigurationRow>(16);
                boolean hasFreezeColumn = false;
                for (GridConfigurationRow row : configRows) {
                    FilterField field = FilterField.create((MainEntityType)type, (String)row.getFieldKey());
                    if (field != null && SingleOrgContextHelper.isNeedHideOrg((FilterField)field) || blackFields != null && blackFields.contains(row.getFieldKey())) continue;
                    if (row.isFreeze()) {
                        hasFreezeColumn = true;
                    }
                    visiableConfigRows.add(row);
                }
                if (hasFreezeColumn) {
                    this.columnsByFreezeSort(visiableConfigRows);
                }
                return visiableConfigRows;
            }
        }
        return configRows;
    }

    private void columnsByFreezeSort(List<GridConfigurationRow> visiableConfigRows) {
        ArrayList<GridConfigurationRow> visiableConfigRowsTemp = new ArrayList<GridConfigurationRow>(10);
        Iterator<GridConfigurationRow> iterator = visiableConfigRows.iterator();
        while (iterator.hasNext()) {
            GridConfigurationRow row = iterator.next();
            if (row.isFreeze()) continue;
            iterator.remove();
            visiableConfigRowsTemp.add(row);
        }
        visiableConfigRows.addAll(visiableConfigRowsTemp);
    }

    public void afterBindData(EventObject e) {
        this.showItemBar();
    }

    private String getEntityNum() {
        Object num = this.getView().getFormShowParameter().getCustomParam("entityNum");
        return num == null ? null : num.toString();
    }

    private void showItemBar() {
        if (this.isExistValueInCol(KEY_FREEZE, Boolean.TRUE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_ACTIVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_FIXED});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_ACTIVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_FIXED});
        }
        if (this.isExistValueInCol(KEY_HIDE, Boolean.TRUE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_HIDE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_HIDE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnmoveup": {
                break;
            }
            case "btnmovedown": {
                break;
            }
            case "btnallhide": {
                this.toggleButton(KEY_HIDE, true, KEY_BUTTON_ALL_HIDE);
                break;
            }
            case "btnallshow": {
                this.toggleButton(KEY_HIDE, false, KEY_BUTTON_ALL_SHOW);
                break;
            }
            case "btnallfiexd": {
                this.getModel().beginInit();
                this.toggleButton(KEY_FREEZE, true, KEY_BUTTON_ALL_FIXED);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                break;
            }
            case "btnallactive": {
                this.getModel().beginInit();
                this.toggleButton(KEY_FREEZE, false, KEY_BUTTON_ALL_ACTIVE);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                break;
            }
            case "btnreset": {
                List<GridConfigurationRow> currentFields = this.getGridConfigRows();
                this.getModel().beginInit();
                this.convertToModel(currentFields);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                this.getPageCache().put(TAG_ISRESET, "true");
                this.getModel().setDataChanged(false);
                break;
            }
            case "reset": {
                this.getPageCache().put(IS_RESET, "true");
                this.resetGridControl();
                break;
            }
            case "btnsetbottom": {
                this.setButtom();
                break;
            }
            case "btnsettop": {
                this.setTop();
                break;
            }
        }
        super.itemClick(evt);
        this.showItemBar();
    }

    private void setTop() {
        SetEntryTop setEntryTop = new SetEntryTop(ENTRYENTITY, this.getView());
        setEntryTop.invokeOperation();
    }

    private void setButtom() {
        SetEntryBottom setEntryBottom = new SetEntryBottom(ENTRYENTITY, this.getView());
        setEntryBottom.invokeOperation();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int i;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        int firstIndex = -1;
        int lastIndex = -1;
        for (i = 0; i < doc.size(); ++i) {
            DynamicObject obj = (DynamicObject)doc.get(i);
            if (Boolean.TRUE.equals(obj.get(KEY_FREEZE))) {
                lastIndex = i;
            }
            if (!Boolean.FALSE.equals(obj.get(KEY_FREEZER))) continue;
            firstIndex = i;
        }
        if (firstIndex == -1 && lastIndex == -1) {
            return;
        }
        this.getModel().beginInit();
        for (i = 0; i <= lastIndex; ++i) {
            if (!Boolean.FALSE.equals(this.getModel().getValue(KEY_FREEZE, i))) continue;
            this.getModel().setValue(KEY_FREEZE, (Object)true, i);
        }
        for (i = 0; i < firstIndex; ++i) {
            if (!Boolean.TRUE.equals(this.getModel().getValue(KEY_FREEZER, i))) continue;
            this.getModel().setValue(KEY_FREEZER, (Object)false, i);
        }
        this.getModel().endInit();
        for (i = 0; i <= lastIndex; ++i) {
            this.getView().updateView(KEY_FREEZE, i);
        }
        for (i = 0; i < firstIndex; ++i) {
            this.getView().updateView(KEY_FREEZER, i);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int i;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        int firstIndex = -1;
        int lastIndex = -1;
        int size = doc.size();
        for (i = size - 1; i >= 0; --i) {
            DynamicObject obj = (DynamicObject)doc.get(i);
            if (Boolean.FALSE.equals(obj.get(KEY_FREEZE))) {
                firstIndex = i;
            }
            if (!Boolean.TRUE.equals(obj.get(KEY_FREEZER))) continue;
            lastIndex = i;
        }
        if (firstIndex == -1 && lastIndex == -1) {
            return;
        }
        this.getModel().beginInit();
        if (firstIndex != -1) {
            for (i = size - 1; i > firstIndex; --i) {
                if (!Boolean.TRUE.equals(this.getModel().getValue(KEY_FREEZE, i))) continue;
                this.getModel().setValue(KEY_FREEZE, (Object)false, i);
            }
        }
        if (lastIndex != -1) {
            for (i = size - 1; i > lastIndex; --i) {
                if (!Boolean.FALSE.equals(this.getModel().getValue(KEY_FREEZER, i))) continue;
                this.getModel().setValue(KEY_FREEZER, (Object)true, i);
            }
        }
        this.getModel().endInit();
        if (firstIndex != -1) {
            for (i = size - 1; i >= firstIndex; --i) {
                this.getView().updateView(KEY_FREEZE, i);
            }
        }
        if (lastIndex != -1) {
            for (i = size - 1; i > lastIndex; --i) {
                this.getView().updateView(KEY_FREEZER, i);
            }
        }
    }

    public void afterSetEntryBottom(AfterMoveEntryEventArgs e) {
        this.afterMoveEntryDown(e);
    }

    public void afterSetEntryTop(AfterMoveEntryEventArgs e) {
        this.afterMoveEntryUp(e);
    }

    private boolean hasSeqChange(Map<String, Integer> lastSeqs) {
        boolean b = false;
        Map originSeqs = new HashMap(16);
        if (this.getView().getPageCache().get(ORIGINSEQS) != null) {
            originSeqs = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(ORIGINSEQS), Map.class);
        }
        for (Map.Entry entry : originSeqs.entrySet()) {
            if (((Integer)entry.getValue()).equals(lastSeqs.get(entry.getKey()))) continue;
            b = true;
            break;
        }
        return b;
    }

    private void updateViewAndRecoverSelectRows() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        this.getView().updateView();
        if (selectRows != null && selectRows.length > 0) {
            grid.selectRows(selectRows, selectRows[0]);
        }
    }

    private void updateViewAndRecoverSelectRows(String entryEntity) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntity);
        int[] selectRows = grid.getSelectRows();
        this.getView().updateView(entryEntity);
        if (selectRows != null && selectRows.length > 0) {
            grid.selectRows(selectRows, selectRows[0]);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnconfirm": {
                if (!this.validateData()) break;
                HashMap<String, Object> result = new HashMap<String, Object>(6);
                boolean isEntry = StringUtils.equals((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get(SOURCE_TYPE)), (CharSequence)"entry");
                if ("true".equals(this.getPageCache().get(TAG_ISRESET))) {
                    result.put(ACTION, KEY_BARITEM_RESET);
                    String gridConfigKey = (String)this.getView().getFormShowParameter().getCustomParam(GRIDCONFIGKEY);
                    result.put(GRIDCONFIGKEY, gridConfigKey);
                } else if ("true".equals(this.getPageCache().get(IS_RESET))) {
                    if (isEntry) {
                        result.put(ACTION, KEY_BARITEM_RESET);
                        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(RESETGRIDCONFIG);
                        result.put(RESETGRIDCONFIG, configRowsStr);
                        this.getReturnDataToParent(result);
                        this.getPageCache().put(IS_RESET, "false");
                        if (result.get(GRIDCONFIG).equals(this.removeLangForResetGridconfig())) {
                            result.put(ACTION, KEY_BARITEM_RESET);
                        }
                    } else {
                        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
                        String configKey = formId + "_reportlistap_gridConfig";
                        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
                        this.getPageCache().put(IS_RESET, "false");
                        this.getReturnDataToParent(result);
                    }
                } else {
                    HashMap<String, Integer> lastSeqs = new HashMap<String, Integer>(16);
                    DynamicObjectCollection cols = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                    for (int i = 0; i < cols.size(); ++i) {
                        lastSeqs.put(((DynamicObject)cols.get(i)).getString(KEY_FIELDKEY), ((DynamicObject)cols.get(i)).getInt("seq"));
                    }
                    boolean flag = false;
                    String sourceType = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE);
                    if (StringUtils.isNotEmpty((CharSequence)sourceType) && StringUtils.equals((CharSequence)sourceType, (CharSequence)"report")) {
                        List<GridConfigurationRow> gridConfigurationRowList = this.getGridConfigRows();
                        for (GridConfigurationRow row : gridConfigurationRowList) {
                            if (row.getLastFlexMaxSize() == -1) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (this.getModel().getDataChanged() || this.hasSeqChange(lastSeqs) || this.isOptionTabInitComplete() || flag) {
                        this.getReturnDataToParent(result);
                    }
                }
                this.saveOptionWithResult(result);
                if (!CollectionUtils.isEmpty(result)) {
                    this.getView().returnDataToParent(result);
                }
                this.getView().close();
                break;
            }
        }
    }

    private void resetGridControl() {
        String configRowsStr;
        ArrayList<GridConfigurationRow> configRows = new ArrayList();
        if ("true".equals(this.getPageCache().get(IS_RESET)) && StringUtils.isNotBlank((CharSequence)(configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(RESETGRIDCONFIG)))) {
            configRows = SerializationUtils.fromJsonStringToList((String)configRowsStr, GridConfigurationRow.class);
        }
        if (!configRows.isEmpty()) {
            String initFieldListStr;
            String sourceType = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE);
            if (StringUtils.equals((CharSequence)sourceType, (CharSequence)"report") && StringUtils.isNotEmpty((CharSequence)(initFieldListStr = (String)this.getView().getFormShowParameter().getCustomParam("initField")))) {
                List initFieldList = SerializationUtils.fromJsonStringToList((String)initFieldListStr, Map.class);
                GridConfigRenderUtils.setInitField(configRows, (List)initFieldList);
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            this.convertToModel(configRows);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_FREEZE.equals(e.getProperty().getName())) {
            int i;
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getModel().beginInit();
            int curIdx = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            if (newValue.booleanValue()) {
                for (i = curIdx - 1; i >= 0; --i) {
                    this.getModel().setValue(KEY_FREEZE, (Object)newValue, i);
                }
            } else {
                for (i = curIdx + 1; i < this.getModel().getEntryRowCount(KEY_ENTRYENTITY); ++i) {
                    this.getModel().setValue(KEY_FREEZE, (Object)newValue, i);
                }
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            long id = changeData.getDataEntity().getLong("id");
            List<Integer> subRowIdx = this.getSubRowIdxByPid(dynamicObjectCollection, id);
            for (Integer rowIdx : subRowIdx) {
                this.getModel().setValue(KEY_FREEZE, (Object)newValue, rowIdx - 1);
            }
            this.getModel().endInit();
            this.updateViewAndRecoverSelectRows();
        } else if (KEY_FREEZER.equals(e.getProperty().getName())) {
            int i;
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getModel().beginInit();
            int curIdx = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            int rowCnt = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
            if (newValue.booleanValue()) {
                for (i = curIdx + 1; i < rowCnt; ++i) {
                    this.getModel().setValue(KEY_FREEZER, (Object)newValue, i);
                }
            } else {
                for (i = curIdx - 1; i >= 0; --i) {
                    this.getModel().setValue(KEY_FREEZER, (Object)newValue, i);
                }
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            long id = changeData.getDataEntity().getLong("id");
            List<Integer> subRowIdx = this.getSubRowIdxByPid(dynamicObjectCollection, id);
            for (Integer rowIdx : subRowIdx) {
                this.getModel().setValue(KEY_FREEZER, (Object)newValue, rowIdx - 1);
            }
            this.getModel().endInit();
            this.updateViewAndRecoverSelectRows(KEY_ENTRYENTITY);
        } else {
            this.showItemBar();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        if (e.getSource() instanceof FieldEdit) {
            String fieldKey;
            FieldEdit fieldEdit = (FieldEdit)e.getSource();
            int rowIndex = e.getRowIndex();
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEdit.getKey(), (CharSequence)KEY_HIDE) && !((Boolean)e.getValue()).booleanValue() && StringUtils.contains((CharSequence)(fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, rowIndex)), (CharSequence)"___") && this.validFlexColumnSize(fieldKey)) {
                e.setCancel(true);
                this.updateViewAndRecoverSelectRows();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEdit.getKey(), (CharSequence)KEY_FREEZER) && ((Boolean)e.getValue()).booleanValue() && ((Boolean)this.getModel().getValue(KEY_FREEZE, rowIndex)).booleanValue()) {
                e.setCancel(true);
                this.getView().updateView(KEY_FREEZER, rowIndex);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEdit.getKey(), (CharSequence)KEY_FREEZE) && ((Boolean)e.getValue()).booleanValue() && ((Boolean)this.getModel().getValue(KEY_FREEZER, rowIndex)).booleanValue()) {
                e.setCancel(true);
                this.getView().updateView(KEY_FREEZE, rowIndex);
            }
        }
    }

    private boolean isExistValueInCol(String key, Object value) {
        int curRows = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        String cacheRes = this.getPageCache().get("field_hide_felx_key");
        for (int i = 0; i < curRows; ++i) {
            if (Objects.equals(value, this.getModel().getValue(key, i))) {
                return true;
            }
            String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, i);
            if (!StringUtils.isNotEmpty((CharSequence)cacheRes) || !cacheRes.contains(fieldKey)) continue;
            return false;
        }
        return false;
    }

    private void toggleButton(String fieldName, boolean isOpen, String key) {
        this.getModel().beginInit();
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < rowCount; ++i) {
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)KEY_FREEZE) && isOpen && ((Boolean)this.getModel().getValue(KEY_FREEZER, i)).booleanValue()) continue;
            this.getModel().setValue(fieldName, (Object)isOpen, i);
        }
        this.getModel().endInit();
        String sourceType = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE);
        if (StringUtils.isEmpty((CharSequence)sourceType) || !StringUtils.equals((CharSequence)"report", (CharSequence)sourceType)) {
            this.updateViewAndRecoverSelectRows();
            return;
        }
        if (KEY_BUTTON_ALL_SHOW.equals(key) && !isOpen) {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            ReportList reportList = (ReportList)parentView.getControl("reportlistap");
            String flexMaxSizeShowMapStr = reportList.getView().getPageCache().get("flexMaxSizeShowMap");
            String flexFieldCanSplitMapStr = reportList.getView().getPageCache().get("flexFieldCanSplitMap");
            List<GridConfigurationRow> configurationRowList = this.getGridConfigRows();
            Map<String, Integer> flexSplitMap = configurationRowList.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, GridConfigurationRow::getFlexSplit, (o, o2) -> o));
            if (StringUtils.isEmpty((CharSequence)flexFieldCanSplitMapStr) || StringUtils.isEmpty((CharSequence)flexMaxSizeShowMapStr)) {
                this.updateViewAndRecoverSelectRows();
                return;
            }
            if (reportList != null && reportList.getFlexColumnSplitService() != null) {
                Map map = reportList.getFlexColumnSplitService().getFlexPropertiesSize();
                Map flexMaxShowMap = (Map)SerializationUtils.fromJsonString((String)flexMaxSizeShowMapStr, Map.class);
                Map flexFieldCanSplitMap = (Map)SerializationUtils.fromJsonString((String)flexFieldCanSplitMapStr, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    boolean flag = true;
                    String[] entryKeys = ((String)entry.getKey()).split(",");
                    Integer entryValue = (Integer)entry.getValue();
                    int maxSize = Integer.parseInt((String)flexMaxShowMap.get(entryKeys[0]));
                    if (entryValue > maxSize) {
                        String fieldKey = entryKeys[0];
                        if (flexFieldCanSplitMap.containsKey(fieldKey) && ((Boolean)flexFieldCanSplitMap.get(fieldKey)).booleanValue() && flexSplitMap.get(fieldKey) == 1) {
                            this.showFlexExtendMaxTips(entryKeys[1], maxSize);
                        }
                        flag = false;
                    }
                    if (flag) continue;
                    this.hideFlex(maxSize, entryKeys[0], parentView);
                }
            }
        }
        this.updateViewAndRecoverSelectRows();
    }

    private void hideFlex(int maxSize, String fieldKey, IFormView parentView) {
        if (parentView.getPageCache().get("flexFieldKeys") == null || parentView.getPageCache().get("flexFieldCanSplitMap") == null) {
            return;
        }
        List flexFieldList = SerializationUtils.fromJsonStringToList((String)parentView.getPageCache().get("flexFieldKeys"), String.class);
        Map flexFieldCanSplitMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexFieldCanSplitMap"), Map.class);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Long> flexFieldPkIdList = new ArrayList<Long>();
        block0: for (String key : flexFieldList) {
            boolean flag;
            boolean bl = flag = flexFieldCanSplitMap.get(key) == null ? false : (Boolean)flexFieldCanSplitMap.get(key);
            if (!flag) continue;
            for (DynamicObject obj : collection) {
                if (!key.equals(obj.getString(KEY_FIELDKEY))) continue;
                flexFieldPkIdList.add(Long.valueOf(obj.getPkValue().toString()));
                continue block0;
            }
        }
        for (Long parentId : flexFieldPkIdList) {
            this.hideFlex(collection, parentId, maxSize, fieldKey);
        }
    }

    private void hideFlex(DynamicObjectCollection dynamicObjectCollection, long pid, int maxSize, String key) {
        int count = 0;
        if (pid > 0L) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String fieldKey = dynamicObject.getString(KEY_FIELDKEY);
                if (!StringUtils.contains((CharSequence)fieldKey, (CharSequence)(key + "___"))) continue;
                long parentId = dynamicObject.getLong("pid");
                boolean isHide = dynamicObject.getBoolean(KEY_HIDE);
                if (pid == parentId && !isHide) {
                    ++count;
                }
                if (pid != parentId || count <= maxSize) continue;
                dynamicObject.set(KEY_HIDE, (Object)true);
                sb.append(dynamicObject.get(KEY_FIELDKEY)).append(",");
            }
            this.getPageCache().put("field_hide_felx_key", sb.toString());
        }
    }

    private boolean validateData() {
        boolean isValid = true;
        int colCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int realAppendTime = 0;
        for (int i = 0; i < colCount; ++i) {
            boolean freeze = (Boolean)this.getModel().getValue(KEY_FREEZE, i);
            boolean hide = (Boolean)this.getModel().getValue(KEY_HIDE, i);
            boolean bl = isValid = !freeze || !hide;
            if (!isValid) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5728\u7b2c%s\u884c\u4e2d\uff0c\u9690\u85cf\u4e0e\u51bb\u7ed3\u4e00\u8d77\u4f1a\u5bfc\u81f4\u65e0\u6548\u3002", (String)"GridConfigPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), i + 1));
                break;
            }
            if (freeze || i >= colCount - 1 || !((Boolean)this.getModel().getValue(KEY_FREEZE, i + 1)).booleanValue()) continue;
            ++realAppendTime;
        }
        if (realAppendTime != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u5217\u9700\u8981\u5728\u975e\u51bb\u7ed3\u5217\u4e4b\u524d\u3002", (String)"GridConfigPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        isValid = this.validFlexColumn();
        return isValid;
    }

    private boolean validFlexColumn() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        ReportList reportList = (ReportList)parentView.getControl("reportlistap");
        if (reportList == null) {
            return true;
        }
        if (parentView.getPageCache().get("flexFieldKeys") == null || parentView.getPageCache().get("flexFieldCanSplitMap") == null || parentView.getPageCache().get("flexMaxSizeShowMap") == null) {
            return true;
        }
        List flexFieldList = SerializationUtils.fromJsonStringToList((String)parentView.getPageCache().get("flexFieldKeys"), String.class);
        Map flexFieldCanSplitMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexFieldCanSplitMap"), Map.class);
        Map flexMaxSizeShowMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexMaxSizeShowMap"), Map.class);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        HashMap<Long, String> flexFieldMap = new HashMap<Long, String>();
        block0: for (String fieldKey : flexFieldList) {
            if (!((Boolean)flexFieldCanSplitMap.get(fieldKey)).booleanValue()) continue;
            for (DynamicObject obj : collection) {
                if (!fieldKey.equals(obj.getString(KEY_FIELDKEY))) continue;
                flexFieldMap.put(Long.valueOf(obj.getPkValue().toString()), fieldKey + "," + obj.getString(KEY_FIELDNAME));
                continue block0;
            }
        }
        Boolean flag = true;
        for (Map.Entry entry : flexFieldMap.entrySet()) {
            int maxSize;
            Long parentId = (Long)entry.getKey();
            String[] strings = ((String)entry.getValue()).split(",");
            int size = this.countSubRowShowByPid(collection, parentId);
            if (size <= (maxSize = Integer.parseInt((String)flexMaxSizeShowMap.get(strings[0])))) continue;
            this.showFlexExtendMaxTips(strings[1], maxSize);
            flag = false;
        }
        if (!flag.booleanValue()) {
            return flag;
        }
        return true;
    }

    private boolean validFlexColumnSize(String fieldKey) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        ReportList reportList = (ReportList)parentView.getControl("reportlistap");
        if (reportList == null) {
            return false;
        }
        if (parentView.getPageCache().get("flexMaxSizeShowMap") == null) {
            return false;
        }
        Map flexMaxSizeShowMap = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("flexMaxSizeShowMap"), Map.class);
        String flexKey = fieldKey.split("___")[0];
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (DynamicObject obj : collection) {
            int maxSize;
            Long parentId;
            int size;
            if (!flexKey.equals(obj.getString(KEY_FIELDKEY)) || (size = this.countSubRowShowByPid(collection, parentId = Long.valueOf(obj.getPkValue().toString()))) + 1 <= (maxSize = Integer.parseInt((String)flexMaxSizeShowMap.get(flexKey)))) continue;
            this.showFlexExtendMaxTips(obj.getString("fieldName"), maxSize);
            return true;
        }
        return false;
    }

    private void showFlexExtendMaxTips(String fieldName, int maxSize) {
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u6700\u591a\u62c6\u5206\u663e\u793a%2$s\u5217\u3002", (String)"GridConfigPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), fieldName, maxSize));
    }

    private int countSubRowShowByPid(DynamicObjectCollection dynamicObjectCollection, long pid) {
        ArrayList<Integer> subRowIdx = new ArrayList<Integer>(10);
        if (pid > 0L) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long parentId = dynamicObject.getLong("pid");
                boolean isHide = dynamicObject.getBoolean(KEY_HIDE);
                if (pid != parentId || isHide) continue;
                subRowIdx.add((Integer)dynamicObject.get("seq"));
                List<Integer> subSubRowIdx = this.getSubRowIdxByPid(dynamicObjectCollection, dynamicObject.getLong("id"));
                subRowIdx.addAll(subSubRowIdx);
            }
        }
        return subRowIdx.size();
    }

    private void getReturnDataToParent(Map<String, Object> result) {
        List<GridConfigurationRow> configRows = this.covertToBeanList();
        result.put(ACTION, "setConfig");
        String gridConfigKey = (String)this.getView().getFormShowParameter().getCustomParam(GRIDCONFIGKEY);
        result.put(GRIDCONFIGKEY, gridConfigKey);
        result.put(GRIDCONFIG, SerializationUtils.toJsonString(configRows));
        result.put(REP_FLEX_CHILDREN_LIST, this.getPageCache().get(REP_FLEX_CHILDREN_LIST));
        result.put("gridConfigOld", this.getView().getFormShowParameter().getCustomParam(GRIDCONFIG));
        result.put(IS_SHOW_ZERO, this.getView().getFormShowParameter().getCustomParam("isshowzero"));
    }

    private void convertToModel(List<GridConfigurationRow> storeSetting) {
        if (storeSetting == null) {
            return;
        }
        int size = storeSetting.size();
        if (size <= 0) {
            return;
        }
        this.getModel().beginInit();
        if (this.getModel().getEntryRowCount(KEY_ENTRYENTITY) > 0) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
        int rowIndex = 0;
        for (GridConfigurationRow bean : storeSetting) {
            rowIndex += this.insertIntoEntry(bean, rowIndex, bean.isFreeze(), bean.isFreezer(), configRow -> this.isFlexSplit((GridConfigurationRow)configRow));
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private boolean isFlexSplit(GridConfigurationRow configRow) {
        String flexSet = this.getPageCache().get(FLEX_SET_PREFIX + configRow.getFieldKey());
        if (StringUtils.isNotBlank((CharSequence)flexSet) && !"true".equals(this.getPageCache().get(IS_RESET))) {
            return FLEX_SPLIT_STAT.equals(flexSet);
        }
        String flexGridConfigRowStr = (String)this.getView().getFormShowParameter().getCustomParam(FLEXGRIDCONFIG);
        if (StringUtils.isBlank((CharSequence)flexGridConfigRowStr) || StringUtils.equals((CharSequence)flexGridConfigRowStr, (CharSequence)"[]")) {
            return true;
        }
        if (this.flexGridConfigRows == null) {
            this.flexGridConfigRows = SerializationUtils.fromJsonStringToList((String)flexGridConfigRowStr, FlexGridConfigRow.class);
        }
        if (this.flexGridConfigRows != null) {
            for (FlexGridConfigRow flexGridConfigRow : this.flexGridConfigRows) {
                int flexSplit;
                if (!configRow.getFieldKey().equals(flexGridConfigRow.getFieldKey())) continue;
                int n = flexSplit = "true".equals(this.getPageCache().get(IS_RESET)) ? -1 : flexGridConfigRow.getFlexSplit();
                flexSet = flexSplit == -1 ? (flexGridConfigRow.isDefaultSplit() ? FLEX_SPLIT_STAT : FLEX_MERGE_STAT) : flexSplit + "";
                this.getPageCache().put(FLEX_SET_PREFIX + configRow.getFieldKey(), flexSet);
                return FLEX_SPLIT_STAT.equals(flexSet);
            }
        }
        return true;
    }

    private int insertIntoEntry(GridConfigurationRow configRow, int rowIndex, boolean isFreeze, boolean isFreezer, Predicate<GridConfigurationRow> showChildren) {
        int insertRows = 1;
        this.getModel().setValue(KEY_FIELDNAME, (Object)configRow.getFieldName(), rowIndex);
        this.getModel().setValue(KEY_COLWIDTH, (Object)configRow.getColWidth(), rowIndex);
        this.getModel().setValue(KEY_FIELDKEY, (Object)configRow.getFieldKey(), rowIndex);
        this.getModel().setValue(KEY_TEXTALIGN, (Object)configRow.getTextAlign(), rowIndex);
        this.getModel().setValue(KEY_FREEZE, (Object)(isFreeze || configRow.isFreeze() ? 1 : 0), rowIndex);
        this.getModel().setValue(KEY_FREEZER, (Object)(isFreezer || configRow.isFreezer() ? 1 : 0), rowIndex);
        this.getModel().setValue(KEY_HIDE, (Object)configRow.isHide(), rowIndex);
        List childrenList = configRow.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childrenList) && showChildren.test(configRow)) {
            for (GridConfigurationRow item : childrenList) {
                int insertEntryRow = this.getModel().insertEntryRow(ENTRYENTITY, rowIndex);
                insertRows += this.insertIntoEntry(item, insertEntryRow, isFreeze, isFreezer, showChildren);
            }
        }
        if (CollectionUtils.isEmpty((Collection)childrenList) && configRow.getFlexSplit() != -1) {
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(FLEX_SET_PREFIX + configRow.getFieldKey()))) {
                this.getPageCache().put(FLEX_SET_PREFIX + configRow.getFieldKey(), String.valueOf(configRow.getFlexSplit()));
            } else {
                configRow.setFlexSplit(Integer.parseInt(this.getPageCache().get(FLEX_SET_PREFIX + configRow.getFieldKey())));
            }
        }
        return insertRows;
    }

    private List<GridConfigurationRow> covertToBeanList() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        HashMap<Integer, GridConfigurationRow> columnMap = new HashMap<Integer, GridConfigurationRow>(collection.size());
        ArrayList<GridConfigurationRow> beans = new ArrayList<GridConfigurationRow>(collection.size());
        for (DynamicObject config : collection) {
            String flexSet;
            GridConfigurationRow bean = new GridConfigurationRow(new LocaleString(config.getString(KEY_FIELDNAME)), config.getInt(KEY_COLWIDTH), config.getString(KEY_TEXTALIGN), config.getString(KEY_FIELDKEY), config.getBoolean(KEY_HIDE), config.getBoolean(KEY_FREEZE), config.getBoolean(KEY_FREEZER));
            String flexsetPageCacheVal = this.getPageCache().get(FLEX_SET_PREFIX + config.getString(KEY_FIELDKEY));
            String string = flexSet = StringUtils.isNotEmpty((CharSequence)flexsetPageCacheVal) ? flexsetPageCacheVal : "-1";
            if (StringUtils.isNotBlank((CharSequence)flexSet)) {
                bean.setFlexSplit(Integer.parseInt(flexSet));
                if (bean.getFlexSplit() != -1) {
                    bean.setFlexMaxSize(0);
                }
            }
            columnMap.put(config.getInt("id"), bean);
            int pid = config.getInt("pid");
            if (pid == 0) {
                beans.add(bean);
                continue;
            }
            GridConfigurationRow parentColumn = (GridConfigurationRow)columnMap.get(pid);
            if (parentColumn == null) continue;
            List childColumns = parentColumn.getChildren();
            childColumns.add(bean);
        }
        return beans;
    }

    private List<Integer> getSubRowIdxByPid(DynamicObjectCollection dynamicObjectCollection, long pid) {
        ArrayList<Integer> subRowIdx = new ArrayList<Integer>(10);
        if (pid > 0L) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long parentId = dynamicObject.getLong("pid");
                if (pid != parentId) continue;
                subRowIdx.add((Integer)dynamicObject.get("seq"));
                List<Integer> subSubRowIdx = this.getSubRowIdxByPid(dynamicObjectCollection, dynamicObject.getLong("id"));
                subRowIdx.addAll(subSubRowIdx);
            }
        }
        return subRowIdx;
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        if (OPTIONTAB.equals(paramTabSelectEvent.getTabKey())) {
            if (this.isOptionTabInitComplete()) {
                return;
            }
            String formId = null;
            if (this.isEntryOrReport()) {
                formId = "bos_gridoptiontpl";
            }
            String entityNumber = this.getEntityNum();
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                ParameterShowParameter parameter = new ParameterShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.setFormId(formId);
                parameter.setCustomParam("bindformid", (Object)entityNumber);
                parameter.setCustomParam("extend", this.getView().getFormShowParameter().getCustomParam(GRIDCONFIGKEY));
                parameter.setCustomParam("userparatype", (Object)UserParaType.GRID.getValue());
                parameter.setCustomParam(SOURCE_TYPE, this.getView().getFormShowParameter().getCustomParam(SOURCE_TYPE));
                parameter.getOpenStyle().setTargetKey("option");
                this.getPageCache().put(LIST_OPTION_PAGE_ID, parameter.getPageId());
                this.getView().showForm((FormShowParameter)parameter);
                this.updateOpTabInitStatus(true);
            }
        }
    }

    private boolean isOptionTabInitComplete() {
        String result = this.getPageCache().get("optiontabinit");
        return Boolean.parseBoolean(String.valueOf(result));
    }

    private void updateOpTabInitStatus(boolean status) {
        this.getPageCache().put("optiontabinit", String.valueOf(status));
    }

    private Map<String, Object> getOption() {
        String listOptionPageId = this.getPageCache().get(LIST_OPTION_PAGE_ID);
        IFormView listOptionView = this.getView().getViewNoPlugin(listOptionPageId);
        if (this.isEntryOrReport()) {
            IDataModel optionModel = (IDataModel)listOptionView.getService(IDataModel.class);
            DynamicObject dataEntity = optionModel.getDataEntity();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setSerializeComplexProperty(false);
            return jser.serializeToMap((Object)dataEntity, null);
        }
        return new HashMap<String, Object>();
    }

    private boolean isEntryOrReport() {
        Object sourceType = this.getView().getFormShowParameter().getCustomParams().get(SOURCE_TYPE);
        return "entry".equals(sourceType) || "report".equals(sourceType);
    }

    private void saveOptionWithResult(Map<String, Object> result) {
        if (this.isOptionTabInitComplete()) {
            String listOptionPageId = this.getPageCache().get(LIST_OPTION_PAGE_ID);
            IFormView listOptionView = this.getView().getViewNoPlugin(listOptionPageId);
            if (listOptionView != null) {
                listOptionView.invokeOperation("parametersave");
                result.put("option", this.getOption());
            }
        }
    }

    private String removeLangForResetGridconfig() {
        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(RESETGRIDCONFIG);
        if (StringUtils.isNotBlank((CharSequence)configRowsStr)) {
            List configurationRowList = SerializationUtils.fromJsonStringToList((String)configRowsStr, GridConfigurationRow.class);
            this.removeLangForResetGridconfig(configurationRowList);
            configRowsStr = SerializationUtils.toJsonString((Object)configurationRowList);
        }
        return configRowsStr;
    }

    private void removeLangForResetGridconfig(List<GridConfigurationRow> configurationRowList) {
        if (CollectionUtils.isEmpty(configurationRowList)) {
            return;
        }
        for (GridConfigurationRow configurationRow : configurationRowList) {
            configurationRow.setFieldName(new LocaleString(configurationRow.getFieldName().toString()));
            if (configurationRow.getFlexSplit() == 0) {
                configurationRow.setChildren(new ArrayList(0));
            }
            if (configurationRow.getChildren() == null || configurationRow.getChildren().size() <= 0) continue;
            this.removeLangForResetGridconfig(configurationRow.getChildren());
        }
    }
}

