/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.IListColumnsSetting;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class ListFieldsControlPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String KEY_CONTROL_TAB = "tabap";
    private static final String OPTIONTAB = "optiontab";
    private static final String ENTITYID = "entityId";
    private static final String LISTOPTIONPAGEID = "listOptionPageId";
    private static final String LISTCOLUMNSPAGEID = "listColumnsPageId";
    private static final String ISRESET = "isReset";
    private static final String SUMFIELDSENTRY = "sumfieldsentry";
    private static final String LISTFIELDKEY = "listFieldKey";
    private static final String CHECKED = "checked";
    private static final Log log = LogFactory.getLog(ListFieldsControlPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        Tab tab = (Tab)this.getControl(KEY_CONTROL_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        super.registerListener(e);
    }

    private boolean isOptionTabInitComplete() {
        String result = this.getPageCache().get("optiontabinit");
        return Boolean.parseBoolean(String.valueOf(result));
    }

    private void updateOpTabInitStatus(boolean status) {
        this.getPageCache().put("optiontabinit", String.valueOf(status));
    }

    public void tabSelected(TabSelectEvent paramTabSelectEvent) {
        if (OPTIONTAB.equals(paramTabSelectEvent.getTabKey())) {
            if (this.isOptionTabInitComplete()) {
                return;
            }
            String option = null;
            String formId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTITYID);
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            if (formConfig == null) {
                log.info("entityId\uff1a{} \u83b7\u53d6\u5230\u8868\u5355\u7684\u5ba2\u6237\u7aef\u663e\u793a\u914d\u7f6e\u5bf9\u8c61\u4e3a\u7a7a\u3002", (Object)formId);
                return;
            }
            String entityId = formConfig.getEntityTypeId();
            FormConfig listConfig = FormMetadataCache.getListFormConfig((String)this.getEntityId());
            if (listConfig != null) {
                option = listConfig.getListUserOption();
            }
            if (StringUtils.isNotBlank(option) && this.isList()) {
                ParameterShowParameter parameter = new ParameterShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.setFormId(option);
                parameter.setCustomParam("bindformid", (Object)entityId);
                parameter.getOpenStyle().setTargetKey("option");
                this.getPageCache().put(LISTOPTIONPAGEID, parameter.getPageId());
                this.getView().showForm((FormShowParameter)parameter);
                this.updateOpTabInitStatus(true);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!this.isList()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPTIONTAB});
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setFormId("ide_listcolumnssetting");
        parameter.getOpenStyle().setTargetKey("tabletab");
        parameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        this.getPageCache().put(LISTCOLUMNSPAGEID, parameter.getPageId());
        this.getView().showForm(parameter);
        this.initGridControl();
        super.afterCreateNewData(e);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        String option = null;
        String formId = String.valueOf(this.getView().getFormShowParameter().getCustomParams().get(ENTITYID));
        FormConfig listConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (listConfig != null) {
            option = listConfig.getListUserOption();
        }
        if (StringUtils.isBlank(option) || !this.isList()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{OPTIONTAB});
        }
    }

    private String getEntityId() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTITYID);
        entityId = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        return entityId;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                boolean isContainOption = false;
                if (this.isOptionTabInitComplete()) {
                    String listOptionPageId = this.getPageCache().get(LISTOPTIONPAGEID);
                    IFormView listOptionView = this.getView().getViewNoPlugin(listOptionPageId);
                    if (listOptionView != null) {
                        listOptionView.invokeOperation("parametersave");
                        isContainOption = true;
                    }
                }
                this.closeAndreturnData(isContainOption);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private Map<String, Object> getOption() {
        String listOptionPageId = this.getPageCache().get(LISTOPTIONPAGEID);
        IFormView listOptionView = this.getView().getViewNoPlugin(listOptionPageId);
        if (this.isList()) {
            IDataModel optionModel = (IDataModel)listOptionView.getService(IDataModel.class);
            DynamicObject dataEntity = optionModel.getDataEntity();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            binder.setSerializeDefaultValue(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setSerializeComplexProperty(false);
            return jser.serializeToMap((Object)dataEntity, null);
        }
        return new HashMap<String, Object>();
    }

    private boolean isEnableCustomSum() {
        return this.getView().getFormShowParameter().getCustomParams().get("isEnableCustomSum") == null ? false : Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParams().get("isEnableCustomSum").toString());
    }

    private boolean isList() {
        return this.getView().getFormShowParameter().getCustomParams().get("isList") == null ? false : Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParams().get("isList").toString());
    }

    private IListColumnsSetting getListColumnsSetting(IFormView editForm) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)editForm.getService(FormViewPluginProxy.class);
        IListColumnsSetting listColumnsSetting = null;
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            if (!(plugin instanceof IListColumnsSetting)) continue;
            listColumnsSetting = (IListColumnsSetting)plugin;
            break;
        }
        return listColumnsSetting;
    }

    private String getSchemeId() {
        return this.getView().getFormShowParameter().getCustomParams().get("schemeId") != null ? this.getView().getFormShowParameter().getCustomParams().get("schemeId").toString() : "";
    }

    private void closeAndreturnData(boolean isContainOption) {
        HashMap<String, Object> listConfig = new HashMap<String, Object>();
        List<String> saveUserSummaryFieldsSetting = this.saveUserSummaryFieldsSetting();
        String listColumnsPageId = this.getPageCache().get(LISTCOLUMNSPAGEID);
        if (listColumnsPageId != null) {
            Map map;
            IFormView listColumnsView = this.getView().getView(listColumnsPageId);
            IListColumnsSetting listColumnsSetting = this.getListColumnsSetting(listColumnsView);
            if (listColumnsSetting != null && (map = listColumnsSetting.saveListColumnsSetting(this.getSchemeId())) != null) {
                listConfig.putAll(map);
            }
            listColumnsView.close();
            this.getPageCache().remove(LISTCOLUMNSPAGEID);
        }
        listConfig.put("userSummaryFields", saveUserSummaryFieldsSetting);
        if (isContainOption) {
            listConfig.put("listOption", this.getOption());
        }
        this.getView().returnDataToParent(listConfig);
        this.getView().close();
    }

    private List<String> saveUserSummaryFieldsSetting() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(SUMFIELDSENTRY);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String fieldname = dynamicObject.getString("fieldname");
            if (!dynamicObject.getBoolean(CHECKED)) continue;
            fieldNames.add(fieldname);
        }
        String userSummaryFieldsKey = this.getUserSummaryFieldsKey();
        if (fieldNames.isEmpty()) {
            UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)userSummaryFieldsKey);
        } else {
            UserConfigServiceHelper.setSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)userSummaryFieldsKey, (String)SerializationUtils.toJsonString(fieldNames));
        }
        return fieldNames;
    }

    private String getListFieldsControlKey() {
        return this.getView().getFormShowParameter().getCustomParams().get("ListFieldsControlKey").toString();
    }

    private String getUserSummaryFieldsKey() {
        return this.getView().getFormShowParameter().getCustomParams().get("UserSummaryFieldsKey").toString();
    }

    private List<String> getSummaryFieldIds() {
        ArrayList<String> finalsummaryFieldIds = new ArrayList<String>(10);
        Object summaryFieldId = this.getView().getFormShowParameter().getCustomParams().get("SummaryFieldId");
        Object summaryFieldIds = this.getView().getFormShowParameter().getCustomParams().get("SummaryFieldIds");
        if (summaryFieldId != null) {
            finalsummaryFieldIds.add(summaryFieldId.toString());
        } else if (summaryFieldIds instanceof Map) {
            Map summaryFieldIds2 = (Map)summaryFieldIds;
            for (Map summaryField : (List)summaryFieldIds2.get("summaryFieldIds")) {
                finalsummaryFieldIds.add((String)summaryField.get("f"));
            }
        }
        return finalsummaryFieldIds;
    }

    private void initGridControl() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        HashSet<String> blackFieldSet = new HashSet<String>(this.getProductFilterField());
        List<Map<String, Object>> factorySetColumns = this.getFactorySetColumns();
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> listColumn : factorySetColumns) {
            ListFieldsControlPlugin.getSumFilterColumns(mainEntityType, blackFieldSet, filterColumns, listColumn);
        }
        if (this.isEnableCustomSum() && !filterColumns.isEmpty()) {
            this.createSumFieldsEntry(filterColumns);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sumfieldstab"});
        }
    }

    private static void getSumFilterColumns(MainEntityType mainEntityType, Set<String> blackFieldSet, List<Map<String, Object>> filterColumns, Map<String, Object> listColumn) {
        List items;
        IDataEntityProperty fieldProp;
        String fieldName = (String)listColumn.get(LISTFIELDKEY);
        FilterField filterField = FilterField.create((MainEntityType)mainEntityType, (String)fieldName);
        if (!(filterField == null || !((fieldProp = filterField.getFieldProp()) instanceof DecimalProp) || filterField.isFieldPropAliasEmpty() || fieldProp instanceof ExchangeRateProp || !blackFieldSet.isEmpty() && blackFieldSet.contains(fieldName) || filterField.getLatestParent() instanceof IBasedataField)) {
            filterColumns.add(listColumn);
        }
        if ((items = (List)listColumn.get("items")) != null) {
            for (Map item : items) {
                ListFieldsControlPlugin.getSumFilterColumns(mainEntityType, blackFieldSet, filterColumns, item);
            }
        }
    }

    private List<Map<String, Object>> getFactorySetColumns() {
        return (List)this.getView().getFormShowParameter().getCustomParams().get("factorySetColumns");
    }

    private void createSumFieldsEntry(List<Map<String, Object>> properties) {
        List userSummaryFields = new ArrayList();
        String setting = this.getModel().getCurrUserSetting(this.getUserSummaryFieldsKey());
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            userSummaryFields = SerializationUtils.fromJsonStringToList((String)setting, String.class);
        }
        List<String> summaryFieldIds = this.getSummaryFieldIds();
        this.getModel().deleteEntryData(SUMFIELDSENTRY);
        this.getModel().batchCreateNewEntryRow(SUMFIELDSENTRY, properties.size());
        List<String> filterFields = this.getProductFilterField();
        int rowIndex = 0;
        for (Map<String, Object> entityProperty : properties) {
            String name = (String)entityProperty.get(LISTFIELDKEY);
            String displayName = entityProperty.get("caption").toString();
            if (filterFields.contains(name)) continue;
            this.getModel().setValue("fieldname", (Object)name, rowIndex);
            this.getModel().setValue("fieldcaption", (Object)displayName, rowIndex);
            if (userSummaryFields.isEmpty() && !summaryFieldIds.isEmpty()) {
                this.getModel().setValue(CHECKED, (Object)summaryFieldIds.contains(name), rowIndex);
            } else {
                this.getModel().setValue(CHECKED, (Object)userSummaryFields.contains(name), rowIndex);
            }
            ++rowIndex;
        }
    }

    private List<String> getProductFilterField() {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        return service.getFormDisVisitField(this.getEntityId());
    }
}

