/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.utils.MobileFormInfo;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MobileFormPlugin
extends AbstractMobBillPlugIn {
    private static final String CLOSECALLBACK = "closeCallBack";
    private static final String BUSINESSNUMBER = "businessNumber";
    private static final String MOBILECONFIGID = "mobileConfigId";
    private static final String BOS_MOBILEFORMCONFIG = "bos_mobileformconfig";
    private static final String BILLTYPE_ID = "billtype_Id";
    private static final String ENTRYENTITY = "entryentity";
    private static final String KEY_BORDER = "0.5px_solid_#b2b2b2";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String SETLOCALEVALUE_333 = "33.3%";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        JSONObject jsonObj;
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        FlexPanelAp uiHeadMeta = new FlexPanelAp();
        uiHeadMeta.setKey("headAp");
        FlexPanelAp uiContainerMeta = new FlexPanelAp();
        uiContainerMeta.setKey("containerap");
        MobileFormInfo utis = (MobileFormInfo)showParameter.getCustomParam(CLOSECALLBACK);
        if (showParameter.getCustomParam(CLOSECALLBACK) instanceof JSONObject && (utis = (MobileFormInfo)JSONObject.toJavaObject((JSON)(jsonObj = (JSONObject)showParameter.getCustomParam(CLOSECALLBACK)), MobileFormInfo.class)).getCallBackClass().containsKey("className")) {
            try {
                Class<?> clazz = Class.forName(utis.getCallBackClass().get("className"));
                utis.setCallBack((ICloseCallBack)clazz.newInstance());
            }
            catch (Exception e1) {
                this.getView().showErrorNotification(e1.getMessage());
            }
        }
        String number = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        String configNumber = (String)showParameter.getCustomParam("configNumber");
        if (number != null) {
            this.createMetaNotByConfig(uiHeadMeta, uiContainerMeta, number, utis.getDisVisbleNumber(), configNumber);
        } else {
            this.createMeta(uiHeadMeta, uiContainerMeta, showParameter);
        }
        showParameter.setCustomParam("schemeDesign", (Object)true);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "mobilecontainer");
        mapHead.put("items", (String)uiHeadMeta.createControl().get("items"));
        e.getItems().add(mapHead);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "mobileentity");
        mapEntry.put("items", (String)uiContainerMeta.createControl().get("items"));
        e.getItems().add(mapEntry);
    }

    public void createNewData(BizDataEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        if (billId != null) {
            this.loadDataByNoConfig(e);
        } else {
            this.loadData(e);
        }
    }

    private void loadDataByNoConfig(BizDataEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String pkId = (String)showParameter.getCustomParam("businessPkId");
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        if (pkId != null) {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)billId);
            e.setDataEntity((Object)dataEntity);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u4f53Id\u4e3a\u7a7a\uff01", (String)"MobileFormPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    private void loadData(BizDataEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam(MOBILECONFIGID), (String)BOS_MOBILEFORMCONFIG);
        Object pkId = this.getPkId(mobileConfig.getString(BILLTYPE_ID));
        if (pkId != null) {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)mobileConfig.getString(BILLTYPE_ID));
            e.setDataEntity((Object)dataEntity);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u4f53Id\u4e3a\u7a7a\uff01", (String)"MobileFormPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("schemeDesign");
        if (customParam.equals(true)) {
            MetadataReader reader = new MetadataReader();
            String fid = reader.loadIdByNumber("bos_mobileform", MetaCategory.Entity);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Form);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
            formMetadata.bindEntityMetadata(entityMetadata);
            FlexPanelAp uiHeadMeta = new FlexPanelAp();
            uiHeadMeta.setKey("headAp");
            FlexPanelAp uiContainerMeta = new FlexPanelAp();
            uiContainerMeta.setKey("containerap");
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String number = (String)showParameter.getCustomParam(BUSINESSNUMBER);
            String configNumber = (String)showParameter.getCustomParam("configNumber");
            Object utis = showParameter.getCustomParam(CLOSECALLBACK);
            if (showParameter.getCustomParam(CLOSECALLBACK) instanceof JSONObject) {
                JSONObject jsonObj = (JSONObject)showParameter.getCustomParam(CLOSECALLBACK);
                utis = JSONObject.toJavaObject((JSON)jsonObj, MobileFormInfo.class);
            }
            if (number != null) {
                this.createMetaNotByConfig(uiHeadMeta, uiContainerMeta, number, ((MobileFormInfo)utis).getDisVisbleNumber(), configNumber);
            } else {
                this.createMeta(uiHeadMeta, uiContainerMeta, showParameter);
            }
            Container c = (Container)this.getControl("mobilecontainer");
            c.getItems().addAll(((Container)uiHeadMeta.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(c.getItems());
            Container entryCard = (Container)this.getControl("mobileentity");
            List entryFieldEditors = ((Container)uiContainerMeta.buildRuntimeControl()).getItems();
            for (Control entryFieldEditor : entryFieldEditors) {
                if (entryFieldEditor instanceof CardEntry) {
                    ((CardEntry)entryFieldEditor).setEntryKey(entryFieldEditor.getKey());
                    ArrayList<Control> list = new ArrayList<Control>();
                    list.add(entryFieldEditor);
                    this.getView().createControlIndex(list);
                }
                entryFieldEditor.setView(this.getView());
                entryCard.getItems().add(entryFieldEditor);
            }
            this.getView().getControl(ENTRYENTITY);
        }
    }

    private void createEntry(FlexPanelAp uiContainerMeta, String entryKey, Map<String, CardEntryRowAp> entryMap) {
        CardEntryAp uiMetaEntry = new CardEntryAp();
        uiMetaEntry.setKey(entryKey);
        uiMetaEntry.setId(entryKey);
        uiMetaEntry.setEntryId(entryKey);
        uiMetaEntry.setShrink(0);
        uiMetaEntry.setGrow(0);
        CardEntryViewAp entryview = new CardEntryViewAp();
        entryview.setId(entryKey + "viewap");
        entryview.setKey(entryKey + "viewap");
        CardEntryRowAp entryrow = new CardEntryRowAp();
        entryrow.setHeight(new LocaleString("100px"));
        entryrow.setId(entryKey + "rowap");
        entryrow.setKey(entryKey + "rowap");
        Style entryStyle = new Style();
        Border border = new Border();
        border.setBottom(KEY_BORDER);
        border.setLeft(KEY_BORDER);
        border.setRight(KEY_BORDER);
        border.setTop(KEY_BORDER);
        entryStyle.setBorder(border);
        entryrow.setStyle(entryStyle);
        entryMap.put(entryKey, entryrow);
        entryview.getItems().add(entryrow);
        uiMetaEntry.getItems().add(entryview);
        uiContainerMeta.getItems().add(uiMetaEntry);
    }

    private DynamicObjectCollection getDynConfig(String formNumber, String configNumber) {
        DynamicObject doj;
        QFilter filter = new QFilter("billtype", "=", (Object)formNumber);
        if (StringUtils.isNotEmpty((CharSequence)configNumber)) {
            QFilter configFilter = new QFilter("number", "=", (Object)configNumber);
            doj = BusinessDataServiceHelper.loadSingle((String)BOS_MOBILEFORMCONFIG, (QFilter[])new QFilter[]{filter, configFilter});
        } else {
            doj = BusinessDataServiceHelper.loadSingle((String)BOS_MOBILEFORMCONFIG, (QFilter[])new QFilter[]{filter});
        }
        DynamicObjectCollection entryCollections = null;
        if (doj != null) {
            entryCollections = doj.getDynamicObjectCollection(ENTRYENTITY);
        }
        return entryCollections;
    }

    private void createMetaNotByConfig(FlexPanelAp uiHeadMeta, FlexPanelAp uiContainerMeta, String number, List<String> disVisibleNumbers, String configNumber) {
        DynamicObjectCollection dynamicObjectCollection = this.getDynConfig(number, configNumber);
        HashMap<String, DynamicObject> keyDynCollections = new HashMap<String, DynamicObject>();
        if (dynamicObjectCollection != null) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                keyDynCollections.put(dynamicObject.getString("fieldkey"), dynamicObject);
            }
        }
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        HashMap<String, CardEntryRowAp> entryMap = new HashMap<String, CardEntryRowAp>();
        HashMap<String, Integer> fieldIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> entryFieldNumber = new HashMap<String, Integer>();
        for (EntityItem entityItem : entities) {
            if (!(entityItem instanceof EntryEntity)) continue;
            this.createEntry(uiContainerMeta, entityItem.getKey(), entryMap);
            fieldIndex.put(entityItem.getKey(), 1);
            int size = ((EntryEntity)entityItem).getItems().size();
            for (EntityItem item : ((EntryEntity)entityItem).getItems()) {
                if ((disVisibleNumbers == null || !disVisibleNumbers.contains(item.getKey())) && !(item instanceof SubEntryEntity) && keyDynCollections.containsKey(item.getKey())) continue;
                --size;
            }
            entryFieldNumber.put(entityItem.getKey(), size);
        }
        for (EntityItem entityItem : entities) {
            if (entityItem instanceof EntryEntity) {
                EntryEntity entry = (EntryEntity)entityItem;
                String entryKey = entry.getKey();
                int size = (Integer)entryFieldNumber.get(entryKey) > 6 ? 6 : (Integer)entryFieldNumber.get(entryKey);
                for (EntityItem item : entry.getItems()) {
                    String fieldkey = item.getKey();
                    if (disVisibleNumbers != null && disVisibleNumbers.contains(fieldkey) || item instanceof SubEntryEntity || !keyDynCollections.containsKey(fieldkey)) continue;
                    CardEntryFieldAp entryFldAp = new CardEntryFieldAp();
                    entryFldAp.setId(fieldkey);
                    entryFldAp.setKey(fieldkey);
                    entryFldAp.setName(item.getName());
                    entryFldAp.setFireUpdEvt(false);
                    if (StringUtils.equals((CharSequence)fieldkey, (CharSequence)item.getKey()) && !(item instanceof SubEntryEntity)) {
                        if ((Integer)fieldIndex.get(entryKey) < 7) {
                            if (item instanceof DateField || item instanceof DateTimeField) {
                                entryFldAp.setDisplayFormatString("MM-dd");
                                entryFldAp.setFieldForeColor("#707070");
                            } else if (item instanceof AmountField) {
                                entryFldAp.setNoDisplayScaleZero(true);
                            }
                            if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FONTCOLOR))) {
                                entryFldAp.setFieldForeColor(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FONTCOLOR));
                            } else {
                                entryFldAp.setFieldForeColor("#4c4c4c");
                            }
                            if (keyDynCollections.get(fieldkey) != null && ((DynamicObject)keyDynCollections.get(fieldkey)).getInt(FONTSIZE) != 0) {
                                entryFldAp.setFontSize(((DynamicObject)keyDynCollections.get(fieldkey)).getInt(FONTSIZE));
                                entryFldAp.setFieldFontSize(((DynamicObject)keyDynCollections.get(fieldkey)).getInt(FONTSIZE));
                            } else {
                                entryFldAp.setFontSize(16);
                                entryFldAp.setFieldFontSize(16);
                            }
                            entryFldAp.setFieldTextAlign("center");
                            entryFldAp.setField((Field)item);
                            entryFldAp.setShowTitle(false);
                            LocaleString width = new LocaleString();
                            LocaleString height = new LocaleString();
                            switch (size) {
                                case 1: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue("100%");
                                    }
                                    height.setLocaleValue("100%");
                                    break;
                                }
                                case 2: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue("50%");
                                    }
                                    height.setLocaleValue("100%");
                                    break;
                                }
                                case 4: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue("50%");
                                    }
                                    height.setLocaleValue("50%");
                                    break;
                                }
                                case 3: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue(SETLOCALEVALUE_333);
                                    }
                                    height.setLocaleValue("100%");
                                    break;
                                }
                                case 5: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue(SETLOCALEVALUE_333);
                                    }
                                    if ((Integer)fieldIndex.get(entryKey) == 3) {
                                        height.setLocaleValue("60%");
                                        Style style = new Style();
                                        Padding padding = new Padding();
                                        padding.setTop("12%");
                                        style.setPadding(padding);
                                        entryFldAp.setStyle(style);
                                        break;
                                    }
                                    height.setLocaleValue("33%");
                                    break;
                                }
                                case 6: {
                                    if (keyDynCollections.get(fieldkey) != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT))) {
                                        width.setLocaleValue(((DynamicObject)keyDynCollections.get(fieldkey)).getString(FIELDPERCENT));
                                    } else {
                                        width.setLocaleValue(SETLOCALEVALUE_333);
                                    }
                                    height.setLocaleValue("50%");
                                    break;
                                }
                            }
                            entryFldAp.setHeight(height);
                            entryFldAp.setWidth(width);
                        } else {
                            entryFldAp.setField((Field)item);
                            entryFldAp.setVisible("");
                        }
                        fieldIndex.put(entryKey, (Integer)fieldIndex.get(entryKey) + 1);
                    }
                    ((CardEntryRowAp)entryMap.get(entryKey)).getItems().add(entryFldAp);
                }
                continue;
            }
            if (disVisibleNumbers != null && disVisibleNumbers.contains(entityItem.getKey())) continue;
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(entityItem.getKey());
            fieldAp.setKey(entityItem.getKey());
            TextEdit te = new TextEdit();
            if (!keyDynCollections.containsKey(entityItem.getKey())) continue;
            fieldAp.setName(entityItem.getName());
            fieldAp.setBackColor("#FFFFFF");
            if (entityItem instanceof Field) {
                fieldAp.setField((Field)entityItem);
            }
            uiHeadMeta.getItems().add(fieldAp);
        }
    }

    private void createMeta(FlexPanelAp uiHeadMeta, FlexPanelAp uiContainerMeta, FormShowParameter showParameter) {
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam(MOBILECONFIGID), (String)BOS_MOBILEFORMCONFIG);
        String number = mobileConfig.getString(BILLTYPE_ID);
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        HashMap<String, CardEntryRowAp> entryMap = new HashMap<String, CardEntryRowAp>();
        HashMap<String, Integer> fieldIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> entryFieldNumber = new HashMap<String, Integer>();
        for (EntityItem entityItem : entities) {
            if (!(entityItem instanceof EntryEntity)) continue;
            this.createEntry(uiContainerMeta, entityItem.getKey(), entryMap);
            fieldIndex.put(entityItem.getKey(), 1);
            entryFieldNumber.put(entityItem.getKey(), 0);
        }
        DynamicObjectCollection entries = mobileConfig.getDynamicObjectCollection(ENTRYENTITY);
        FieldAp fieldAp = null;
        for (DynamicObject dynamicObject : entries) {
            String entryKey = dynamicObject.getString("entrylocation");
            if (dynamicObject.getBoolean("isheadfield")) continue;
            entryFieldNumber.put(entryKey, (Integer)entryFieldNumber.get(entryKey) + 1);
        }
        for (DynamicObject object : entries) {
            String fieldkey = object.getString("fieldkey");
            String entryKey = object.getString("entrylocation");
            if (object.getBoolean("isheadfield")) {
                fieldAp = new FieldAp();
                fieldAp.setId(fieldkey);
                fieldAp.setKey(fieldkey);
                fieldAp.setName(new LocaleString(object.getString("fieldname")));
                fieldAp.setBackColor("#FFFFFF");
                for (EntityItem entity : entities) {
                    if (!(entity instanceof Field) || !StringUtils.equals((CharSequence)fieldkey, (CharSequence)entity.getKey())) continue;
                    fieldAp.setField((Field)entity);
                }
                uiHeadMeta.getItems().add(fieldAp);
                continue;
            }
            CardEntryFieldAp entryFldAp = new CardEntryFieldAp();
            entryFldAp.setId(fieldkey);
            entryFldAp.setKey(fieldkey);
            object.getString("fieldtype");
            entryFldAp.setName(new LocaleString(object.getString("fieldname")));
            entryFldAp.setFireUpdEvt(false);
            for (EntityItem entity : entities) {
                if (!(entity instanceof EntryEntity)) continue;
                EntryEntity entry = (EntryEntity)entity;
                int size = (Integer)entryFieldNumber.get(entryKey) > 6 ? 6 : (Integer)entryFieldNumber.get(entryKey);
                for (EntityItem item : entry.getItems()) {
                    if (!StringUtils.equals((CharSequence)fieldkey, (CharSequence)item.getKey()) || item instanceof SubEntryEntity) continue;
                    if ((Integer)fieldIndex.get(entryKey) < 7) {
                        if (item instanceof DateField || item instanceof DateTimeField) {
                            entryFldAp.setDisplayFormatString("MM-dd");
                            entryFldAp.setFieldForeColor("#707070");
                        } else if (item instanceof AmountField) {
                            entryFldAp.setNoDisplayScaleZero(true);
                        }
                        if (!StringUtils.isBlank((CharSequence)object.getString(FONTCOLOR))) {
                            entryFldAp.setFieldForeColor(object.getString(FONTCOLOR));
                        } else {
                            entryFldAp.setFieldForeColor("#4c4c4c");
                        }
                        if (object.getInt(FONTSIZE) > 0) {
                            entryFldAp.setFontSize(object.getInt(FONTSIZE));
                            entryFldAp.setFieldFontSize(object.getInt(FONTSIZE));
                        } else {
                            entryFldAp.setFontSize(16);
                            entryFldAp.setFieldFontSize(16);
                        }
                        entryFldAp.setFieldTextAlign("center");
                        entryFldAp.setField((Field)item);
                        entryFldAp.setShowTitle(false);
                        LocaleString width = new LocaleString();
                        LocaleString height = new LocaleString();
                        switch (size) {
                            case 1: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("100%");
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 2: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("50%");
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 4: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("50%");
                                }
                                height.setLocaleValue("50%");
                                break;
                            }
                            case 3: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue(SETLOCALEVALUE_333);
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 5: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue(SETLOCALEVALUE_333);
                                }
                                if ((Integer)fieldIndex.get(entryKey) == 3) {
                                    height.setLocaleValue("60%");
                                    Style style = new Style();
                                    Padding padding = new Padding();
                                    padding.setTop("12%");
                                    style.setPadding(padding);
                                    entryFldAp.setStyle(style);
                                    break;
                                }
                                height.setLocaleValue("33%");
                                break;
                            }
                            case 6: {
                                if (!StringUtils.isBlank((CharSequence)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue(SETLOCALEVALUE_333);
                                }
                                height.setLocaleValue("50%");
                                break;
                            }
                        }
                        entryFldAp.setHeight(height);
                        entryFldAp.setWidth(width);
                    } else {
                        entryFldAp.setField((Field)item);
                        entryFldAp.setVisible("");
                    }
                    fieldIndex.put(entryKey, (Integer)fieldIndex.get(entryKey) + 1);
                }
            }
            ((CardEntryRowAp)entryMap.get(entryKey)).getItems().add(entryFldAp);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        if (billId != null) {
            this.getTypeByNoConig(e, billId);
        } else {
            this.getType(e);
        }
    }

    private void getType(GetEntityTypeEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam(MOBILECONFIGID), (String)BOS_MOBILEFORMCONFIG);
        EntityMetadataCache.getDataEntityType((String)mobileConfig.getString(BILLTYPE_ID));
        MainEntityType newMainType = EntityMetadataCache.getDataEntityTypeNoCache((String)mobileConfig.getString(BILLTYPE_ID));
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        if (entryType == null) {
            entryType = new EntryType();
            entryType.setName(ENTRYENTITY);
            entryType.setAlias("");
            entryType.setDbIgnore(true);
            EntryProp prop = new EntryProp(ENTRYENTITY, (DynamicObjectType)entryType);
            prop.setDefaultRows(0);
            newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
        }
        e.setNewEntityType(newMainType);
    }

    private void getTypeByNoConig(GetEntityTypeEventArgs e, String number) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        EntityMetadataCache.getDataEntityType((String)number);
        MainEntityType newMainType = EntityMetadataCache.getDataEntityTypeNoCache((String)number);
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        if (entryType == null) {
            entryType = new EntryType();
            entryType.setName(ENTRYENTITY);
            entryType.setAlias("");
            entryType.setDbIgnore(true);
            EntryProp prop = new EntryProp(ENTRYENTITY, (DynamicObjectType)entryType);
            prop.setDefaultRows(0);
            newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
        }
        e.setNewEntityType(newMainType);
    }

    private Object getPkId(String entityName) {
        ORM orm = ORM.create();
        Object pkId = null;
        DynamicObjectCollection dynColl = orm.query(entityName, null);
        if (dynColl != null && !dynColl.isEmpty()) {
            pkId = ((DynamicObject)dynColl.get(0)).get("Id");
        }
        return pkId;
    }
}

