/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OperationResultPlugin
extends AbstractFormPlugin {
    private static final String BTN_MORE = "btnmore";
    private static final String SUBTITLE = "fsubtitle";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_MORE});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label label = (Label)this.getControl("ftitle");
        label.setText((String)parameter.getCustomParam("title"));
        Object errObj = parameter.getCustomParam("errorMsg");
        if (errObj == null) {
            return;
        }
        StringBuilder val = new StringBuilder();
        ArrayList<Map<String, Object>> contentList = new ArrayList<Map<String, Object>>(1);
        if (errObj instanceof List) {
            List list = (List)errObj;
            for (String text : list) {
                if (text != null && text.contains("\"msgcode\":") && text.contains("\"msg\":")) {
                    val.append(this.analysisContent(text, contentList)).append(System.lineSeparator());
                    continue;
                }
                val.append(text).append(System.lineSeparator());
            }
        } else {
            String errStr = (String)errObj;
            if (errStr != null && errStr.contains("\"msgcode\":") && errStr.contains("\"msg\":")) {
                val.append(this.analysisContent(errStr, contentList));
            } else {
                val.append(this.extractMesage(errStr));
            }
        }
        this.getModel().setValue("content", (Object)val.toString());
        if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_MORE});
        }
        Label subtitle = (Label)this.getControl(SUBTITLE);
        String message = (String)parameter.getCustomParam("message");
        if (StringUtils.isBlank((CharSequence)message)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SUBTITLE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SUBTITLE});
            subtitle.setText(message);
        }
    }

    private String analysisContent(String text, List<Map<String, Object>> contentList) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        Map postMap = (Map)SerializationUtils.fromJsonString((String)text, Map.class);
        String msgcode = (String)postMap.get("msgcode");
        String msg = postMap.get("msg") == null ? "" : (String)postMap.get("msg");
        String tenantId = RequestContext.get().getTenantId();
        String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
        if (!"FALSE".equalsIgnoreCase(tipsOn)) {
            map.put("msgcode", msgcode);
            map.put("href", (String)postMap.get("href"));
        }
        map.put("msg", msg);
        map.put("detail", msg);
        map.put("messageType", (String)MessageTypes.Default);
        contentList.add(map);
        return msg;
    }

    private String extractMesage(String errStr) {
        int index = errStr.indexOf(62);
        if (index == 0) {
            return errStr;
        }
        String[] lines = StringUtils.substring((String)errStr, (int)(errStr.indexOf(62) + 1)).split("<br/>");
        StringBuilder val = new StringBuilder();
        val.append(lines[0]);
        for (int i = 1; i < lines.length - 1; ++i) {
            val.append(System.lineSeparator());
            val.append(lines[i]);
        }
        return val.toString();
    }

    public void click(EventObject evt) {
        if (BTN_MORE.equals(((Control)evt.getSource()).getKey())) {
            FormShowParameter param = this.getView().getFormShowParameter();
            IFormView view = this.getView();
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ide_showoperationresult");
            parameter.setCustomParam("pkNumbers", param.getCustomParam("pkNumbers"));
            parameter.setCustomParam("operateName", param.getCustomParam("operateName"));
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            parentView.showForm(parameter);
            view.sendFormAction(parentView);
            view.close();
        }
    }
}

