/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.report.events.SortAndFilterEvent;

public class ReportMultiFieldSortPlugin
extends AbstractFormPlugin {
    private static final String KEY_BUTTON_OK = "btnok";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SORTFIELD = "sortfield";
    private static final String KEY_SORTSTYLE = "sortstyle";
    private static final String KEY_ORIGINTOTAL = "originTotal";
    private int originTotal = 0;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_OK});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (KEY_BUTTON_OK.equals(control.getKey())) {
            int size = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
            if (this.getView().getPageCache().get(KEY_ORIGINTOTAL) != null) {
                this.originTotal = Integer.parseInt(this.getView().getPageCache().get(KEY_ORIGINTOTAL));
            }
            if ((this.originTotal != size || this.getModel().getDataChanged()) && !this.returnDataToParent()) {
                return;
            }
            this.getView().close();
        }
    }

    private static <T> T deSerializeFromBase64(String base64String) {
        return (T)SerializationUtils.fromByte((byte[])Base64.getDecoder().decode(base64String));
    }

    public void afterCreateNewData(EventObject e) {
        List columns = (List)ReportMultiFieldSortPlugin.deSerializeFromBase64((String)this.getView().getFormShowParameter().getCustomParam("reportcolumns"));
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_SORTFIELD);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        ComboItem item = null;
        for (SortAndFilterEvent event : columns) {
            item = new ComboItem(event.getDisplayName(), event.getColumnName());
            items.add(item);
        }
        comboEdit.setComboItems(items);
        ReportQueryParam param = ReportCacheManager.getInstance().getCache().getReportQueryParam((String)this.getView().getFormShowParameter().getCustomParam("pageId"));
        if ("multiSort".equals(param.getSortSource()) && !StringUtils.isBlank((CharSequence)param.getSortInfo())) {
            this.convertToModel(param.getSortInfo());
        }
    }

    private void convertToModel(String sortInfo) {
        String[] infos;
        if (this.getModel().getEntryRowCount(KEY_ENTRYENTITY) > 0) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
        if ((infos = sortInfo.split(",")).length > 0) {
            this.originTotal = infos.length;
            this.getView().getPageCache().put(KEY_ORIGINTOTAL, String.valueOf(this.originTotal));
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, infos.length);
            for (int i = 0; i < infos.length; ++i) {
                String info = infos[i];
                String[] items = info.split(" ");
                int sortValue = this.getSortValue(items[1]);
                this.getModel().setValue(KEY_SORTFIELD, (Object)items[0], i);
                this.getModel().setValue(KEY_SORTSTYLE, (Object)sortValue, i);
            }
        }
    }

    private boolean returnDataToParent() {
        String sortInfo = this.convertToSortInfo();
        if (sortInfo == null) {
            return false;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("action", "reportmultifieldsort");
        result.put("controlKey", this.getView().getFormShowParameter().getCustomParam("controlKey"));
        result.put("entityId", this.getView().getFormShowParameter().getCustomParam("entityId"));
        result.put("sortInfo", sortInfo);
        this.getView().returnDataToParent(result);
        return true;
    }

    private int getSortValue(String sortStyle) {
        if ("asc".equals(sortStyle)) {
            return 1;
        }
        if ("desc".equals(sortStyle)) {
            return 2;
        }
        return 0;
    }

    private String convertToSortInfo() {
        int size = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        ArrayList<String> fieldList = new ArrayList<String>(10);
        StringBuilder sortInfo = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String sortField = (String)this.getModel().getValue(KEY_SORTFIELD, i);
            if (fieldList.contains(sortField)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"ReportMultiFieldSortPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
                return null;
            }
            String sortStyle = (String)this.getModel().getValue(KEY_SORTSTYLE, i);
            if (StringUtils.isBlank((CharSequence)sortField) || StringUtils.isBlank((CharSequence)sortStyle)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6392\u5e8f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"ReportMultiFieldSortPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
                return null;
            }
            sortInfo.append(sortField).append(" ").append(sortStyle).append(",");
            fieldList.add(sortField);
        }
        if (!"".equals(sortInfo.toString())) {
            sortInfo = sortInfo.deleteCharAt(sortInfo.length() - 1);
        }
        return sortInfo.toString();
    }
}

