/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class RptListFieldsControlPlugin
extends AbstractFormPlugin {
    private static final String TAG_ISRESET = "isreset";
    private static final String KEY_ADVCON_TOOLBARAP = "advcontoolbarap";
    private static final String KEY_BUTTON_ALL_ACTIVE = "btnallactive";
    private static final String KEY_BUTTON_ALL_FIXED = "btnallfiexd";
    private static final String KEY_BUTTON_ALL_SHOW = "btnallshow";
    private static final String KEY_BUTTON_ALL_HIDE = "btnallhide";
    private static final String KEY_BUTTON_RESET = "btnreset";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_CONFIRM = "btnconfirm";
    private static final String KEY_BUTTON_UP = "btnmoveup";
    private static final String KEY_BUTTON_DOWN = "btnmovedown";
    private static final String KEY_BARITEM_RESET = "reset";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_FIELDNAME = "fieldname";
    private static final String KEY_COLWIDTH = "colwidth";
    private static final String KEY_TEXTALIGN = "textalign";
    private static final String KEY_HIDE = "hide";
    private static final String KEY_FREEZE = "freeze";
    private static final int KEY_FREEZE_COL_INDEX = 6;
    private static final String GRIDCONFIG = "gridConfig";
    private static final String ENTRY_ENTITY = "entryEntity";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_CONFIRM});
        this.addItemClickListeners(new String[]{KEY_ADVCON_TOOLBARAP});
    }

    public void afterCreateNewData(EventObject e) {
        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("resetGridConfig");
        if (StringUtils.isBlank((CharSequence)configRowsStr)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_RESET});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_COLWIDTH});
        List<GridConfigurationRow> configRows = this.getGridConfigRows();
        this.convertToModel(configRows);
        HashMap<String, Integer> originSeqs = new HashMap<String, Integer>(16);
        DynamicObjectCollection cols = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (int i = 0; i < cols.size(); ++i) {
            originSeqs.put(((DynamicObject)cols.get(i)).getString(KEY_FIELDKEY), ((DynamicObject)cols.get(i)).getInt("seq"));
        }
        this.getView().getPageCache().put("originSeqs", SerializationUtils.toJsonString(originSeqs));
    }

    protected List<GridConfigurationRow> getGridConfigRows() {
        String configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam(GRIDCONFIG);
        List configRows = null;
        if (StringUtils.isNotBlank((CharSequence)configRowsStr)) {
            configRows = SerializationUtils.fromJsonStringToList((String)configRowsStr, GridConfigurationRow.class);
        }
        return configRows;
    }

    public void afterBindData(EventObject e) {
        this.showItemBar();
    }

    private void showItemBar() {
        if (this.isExistValueInCol(KEY_FREEZE, Boolean.TRUE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_ACTIVE});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_FIXED});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_ACTIVE});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_FIXED});
        }
        if (this.isExistValueInCol(KEY_HIDE, Boolean.TRUE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_HIDE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BUTTON_ALL_SHOW});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BUTTON_ALL_HIDE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnmoveup": {
                break;
            }
            case "btnmovedown": {
                break;
            }
            case "btnallhide": {
                this.toggleButton(KEY_HIDE, true);
                break;
            }
            case "btnallshow": {
                this.toggleButton(KEY_HIDE, false);
                break;
            }
            case "btnallfiexd": {
                this.getModel().beginInit();
                this.toggleButton(KEY_FREEZE, true);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                break;
            }
            case "btnallactive": {
                this.getModel().beginInit();
                this.toggleButton(KEY_FREEZE, false);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                break;
            }
            case "btnreset": {
                List<GridConfigurationRow> currentFields = this.getGridConfigRows();
                this.getModel().beginInit();
                this.convertToModel(currentFields);
                this.getModel().endInit();
                this.updateViewAndRecoverSelectRows();
                this.getPageCache().put(TAG_ISRESET, "true");
                this.getModel().setDataChanged(false);
                break;
            }
            case "reset": {
                this.getPageCache().put("isReset", "true");
                this.resetGridControl();
                break;
            }
        }
        super.itemClick(evt);
        this.showItemBar();
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int i;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        int lastIndex = -1;
        for (i = 0; i < doc.size(); ++i) {
            DynamicObject obj = (DynamicObject)doc.get(i);
            if (!Boolean.TRUE.equals(obj.get(6))) continue;
            lastIndex = i;
        }
        this.getModel().beginInit();
        for (i = 0; i <= lastIndex; ++i) {
            if (!Boolean.FALSE.equals(this.getModel().getValue(KEY_FREEZE, i))) continue;
            this.getModel().setValue(KEY_FREEZE, (Object)true, i);
        }
        this.getModel().endInit();
        for (i = 0; i <= lastIndex; ++i) {
            this.getView().updateView(KEY_FREEZE, i);
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int i;
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (doc == null || doc.isEmpty()) {
            return;
        }
        int firstIndex = 0;
        int size = doc.size();
        for (i = size - 1; i >= 0; --i) {
            DynamicObject obj = (DynamicObject)doc.get(i);
            if (!Boolean.FALSE.equals(obj.get(6))) continue;
            firstIndex = i;
        }
        this.getModel().beginInit();
        for (i = size - 1; i > firstIndex; --i) {
            if (!Boolean.TRUE.equals(this.getModel().getValue(KEY_FREEZE, i))) continue;
            this.getModel().setValue(KEY_FREEZE, (Object)false, i);
        }
        this.getModel().endInit();
        for (i = size - 1; i >= firstIndex; --i) {
            this.getView().updateView(KEY_FREEZE, i);
        }
    }

    private boolean hasSeqChange(Map<String, Integer> lastSeqs) {
        boolean b = false;
        Map originSeqs = new HashMap(16);
        if (this.getView().getPageCache().get("originSeqs") != null) {
            originSeqs = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("originSeqs"), Map.class);
        }
        for (Map.Entry entry : originSeqs.entrySet()) {
            if (((Integer)entry.getValue()).equals(lastSeqs.get(entry.getKey()))) continue;
            b = true;
            break;
        }
        return b;
    }

    private void updateViewAndRecoverSelectRows() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        this.getView().updateView();
        if (selectRows != null && selectRows.length > 0) {
            grid.selectRows(selectRows, selectRows[0]);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnconfirm": {
                if (!this.validateData()) break;
                if ("true".equals(this.getPageCache().get(TAG_ISRESET))) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("action", KEY_BARITEM_RESET);
                    String gridConfigKey = (String)this.getView().getFormShowParameter().getCustomParam("gridConfigKey");
                    result.put("gridConfigKey", gridConfigKey);
                    this.getView().returnDataToParent(result);
                } else if ("true".equals(this.getPageCache().get("isReset"))) {
                    String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
                    String configKey = formId + "_reportlistap_gridConfig";
                    UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
                    this.getPageCache().put("isReset", "false");
                } else {
                    HashMap<String, Integer> lastSeqs = new HashMap<String, Integer>(16);
                    DynamicObjectCollection cols = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                    for (int i = 0; i < cols.size(); ++i) {
                        lastSeqs.put(((DynamicObject)cols.get(i)).getString(KEY_FIELDKEY), ((DynamicObject)cols.get(i)).getInt("seq"));
                    }
                    if (this.getModel().getDataChanged() || this.hasSeqChange(lastSeqs)) {
                        this.returnDataToParent();
                    }
                }
                this.getView().close();
                break;
            }
        }
    }

    private void resetGridControl() {
        String configRowsStr;
        List<Object> configRows = new ArrayList<GridConfigurationRow>();
        if ("true".equals(this.getPageCache().get("isReset")) && StringUtils.isNotBlank((CharSequence)(configRowsStr = (String)this.getView().getFormShowParameter().getCustomParam("resetGridConfig")))) {
            configRows = SerializationUtils.fromJsonStringToList((String)configRowsStr, GridConfigurationRow.class);
        }
        if (!configRows.isEmpty()) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.convertToModel(configRows);
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_FREEZE.equals(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getModel().beginInit();
            int curIdx = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            if (newValue.booleanValue()) {
                for (int i = curIdx - 1; i >= 0; --i) {
                    this.getModel().setValue(KEY_FREEZE, (Object)newValue, i);
                }
            } else {
                for (int i = curIdx + 1; i < this.getModel().getEntryRowCount(KEY_ENTRYENTITY); ++i) {
                    this.getModel().setValue(KEY_FREEZE, (Object)newValue, i);
                }
            }
            this.getModel().endInit();
            this.updateViewAndRecoverSelectRows();
        } else {
            this.showItemBar();
        }
    }

    private boolean isExistValueInCol(String key, Object value) {
        int curRows = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        for (int i = 0; i < curRows; ++i) {
            if (!Objects.equals(value, this.getModel().getValue(key, i))) continue;
            return true;
        }
        return false;
    }

    private void toggleButton(String fieldName, boolean isOpen) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue(fieldName, (Object)isOpen, i);
        }
    }

    private boolean validateData() {
        boolean isValid = true;
        int colCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int realAppendTime = 0;
        for (int i = 0; i < colCount; ++i) {
            boolean freeze = (Boolean)this.getModel().getValue(KEY_FREEZE, i);
            boolean hide = (Boolean)this.getModel().getValue(KEY_HIDE, i);
            boolean bl = isValid = !freeze || !hide;
            if (!isValid) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5728\u7b2c%s\u884c\u4e2d\uff0c\u9690\u85cf\u4e0e\u51bb\u7ed3\u4e00\u8d77\u4f1a\u5bfc\u81f4\u65e0\u6548\u3002", (String)"RptListFieldsControlPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), i + 1));
                break;
            }
            if (freeze || i >= colCount - 1 || !((Boolean)this.getModel().getValue(KEY_FREEZE, i + 1)).booleanValue()) continue;
            ++realAppendTime;
        }
        if (realAppendTime != 0) {
            isValid = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51bb\u7ed3\u5217\u9700\u8981\u5728\u975e\u51bb\u7ed3\u5217\u4e4b\u524d", (String)"RptListFieldsControlPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        return isValid;
    }

    private void returnDataToParent() {
        List<GridConfigurationRow> configRows = this.covertToBeanList();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("action", "setConfig");
        String gridConfigKey = (String)this.getView().getFormShowParameter().getCustomParam("gridConfigKey");
        result.put("gridConfigKey", gridConfigKey);
        result.put(GRIDCONFIG, SerializationUtils.toJsonString(configRows));
        this.getView().returnDataToParent(result);
    }

    private void convertToModel(List<GridConfigurationRow> storeSetting) {
        if (storeSetting == null) {
            return;
        }
        int size = storeSetting.size();
        if (size <= 0) {
            return;
        }
        if (this.getModel().getEntryRowCount(KEY_ENTRYENTITY) > 0) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
        for (int i = 0; i < storeSetting.size(); ++i) {
            GridConfigurationRow bean = storeSetting.get(i);
            this.getModel().setValue(KEY_FIELDNAME, (Object)bean.getFieldName(), i);
            this.getModel().setValue(KEY_COLWIDTH, (Object)bean.getColWidth(), i);
            this.getModel().setValue(KEY_FIELDKEY, (Object)bean.getFieldKey(), i);
            this.getModel().setValue(KEY_TEXTALIGN, (Object)bean.getTextAlign(), i);
            this.getModel().setValue(KEY_FREEZE, (Object)bean.isFreeze(), i);
            this.getModel().setValue(KEY_HIDE, (Object)bean.isHide(), i);
        }
    }

    private List<GridConfigurationRow> covertToBeanList() {
        int size = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        ArrayList<GridConfigurationRow> beans = new ArrayList<GridConfigurationRow>(10);
        for (int i = 0; i < size; ++i) {
            GridConfigurationRow bean = new GridConfigurationRow();
            String fieldName = (String)this.getModel().getValue(KEY_FIELDNAME, i);
            int colWidth = (Integer)this.getModel().getValue(KEY_COLWIDTH, i);
            String fieldKey = (String)this.getModel().getValue(KEY_FIELDKEY, i);
            String textAlign = (String)this.getModel().getValue(KEY_TEXTALIGN, i);
            boolean freeze = (Boolean)this.getModel().getValue(KEY_FREEZE, i);
            boolean hide = (Boolean)this.getModel().getValue(KEY_HIDE, i);
            bean.setColWidth(colWidth);
            bean.setFieldKey(fieldKey);
            bean.setFieldName(new LocaleString(fieldName));
            bean.setFreeze(freeze);
            bean.setHide(hide);
            bean.setTextAlign(textAlign);
            beans.add(bean);
        }
        return beans;
    }
}

