/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.QFilterDto;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.QueryFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TemplateGroupBaseDataPlugin
extends TemplateTreePlugin
implements IDataModelChangeListener {
    private static final Log log = LogFactory.getLog(TemplateGroupBaseDataPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        this.getView().getFormShowParameter().setCustomParam("isGroup", (Object)true);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("iscontainlower") && e.getChangeSet().length == 1) {
            boolean iscontainLower = (Boolean)e.getChangeSet()[0].getNewValue();
            if (this.getTreeListView().getTreeModel() != null) {
                Object nodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
                TreeNode rootNode = this.getTreeListView().getTreeModel().getRoot();
                if (nodeId != null && rootNode != null) {
                    GroupProp groupProp = this.getTreeListView().getTreeModel().getGroupProp();
                    TreeNode currentNode = rootNode.getTreeNode(nodeId.toString());
                    BillList billList = (BillList)this.getControl("billlistap");
                    ArrayList<QFilter> filters = new ArrayList<QFilter>();
                    if (groupProp != null) {
                        String groupName = groupProp.getName();
                        if (currentNode != null) {
                            QFilter qFiter;
                            if (StringUtils.isNotBlank((CharSequence)currentNode.getLongNumber())) {
                                int dbType = groupProp.getDbType();
                                qFiter = new QFilter(groupName, "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId()));
                                filters.add(qFiter);
                                String longNumber = currentNode.getLongNumber();
                                if (iscontainLower) {
                                    IQuery query = QueryFactory.createQuery();
                                    List idArrays = query.getChildsId(groupProp, longNumber);
                                    List ids = idArrays.stream().map(obj -> DbTypeConverter.safeConvert((int)dbType, (Object)obj)).collect(Collectors.toList());
                                    for (Object string : ids) {
                                        qFiter.or(new QFilter(groupName, "=", string));
                                    }
                                }
                            } else if (currentNode.getId().equals(rootNode.getId())) {
                                if (!iscontainLower) {
                                    int dbType = groupProp.getDbType();
                                    Object value = 12 == dbType || -9 == dbType || 1 == dbType ? " " : Integer.valueOf(0);
                                    QFilter qFiter2 = new QFilter(groupName, "=", value);
                                    filters.add(qFiter2);
                                } else {
                                    IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                                    ListCache listCache = new ListCache(pageCache);
                                    listCache.getTreeListFilterParameter().setQFilters(Collections.emptyList());
                                }
                            } else {
                                int dbType = groupProp.getDbType();
                                qFiter = new QFilter(groupName, "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentNode.getId()));
                                filters.add(qFiter);
                            }
                            FieldEdit showDisabledDataEdit = (FieldEdit)this.getControl("isshowdisabled");
                            boolean showDisabledData = false;
                            if (showDisabledDataEdit != null) {
                                showDisabledData = (Boolean)showDisabledDataEdit.getModel().getValue("isshowdisabled");
                            }
                            billList.setShowDisabledData(showDisabledData);
                            this.addFastFilter(filters);
                            billList.setQueryFilterParameter(new FilterParameter(filters, null));
                            boolean isF7 = false;
                            if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
                                isF7 = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
                            }
                            if (!isF7) {
                                billList.clearEntryState();
                                billList.clearSelection();
                            }
                            billList.refresh();
                        }
                    }
                }
            }
        }
    }

    private void addFastFilter(List<QFilter> filters) {
        try {
            String fastfilter = this.getPageCache().get("fast:filter");
            if (StringUtils.isNotBlank((CharSequence)fastfilter)) {
                List fastQfilters = SerializationUtils.fromJsonStringToList((String)fastfilter, QFilterDto.class);
                for (QFilterDto filterDto : fastQfilters) {
                    filters.add(QFilter.fromSerializedString((String)filterDto.getFilter()));
                }
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5feb\u901f\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

