/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TemplateTreeBaseDataPlugin
extends AbstractBasePlugIn
implements IDataModelChangeListener {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String NUMBER = "number";
    private static final String PARENT = "parent";
    private static final String SELECTFIELDS = "number,level,longnumber,parent,fullname,name";
    private static final String LEVEL_ASC = "level asc";
    private static final String TEMPLATE_TREE_BASE_DATA_PLUGIN_8 = "TemplateTreeBaseDataPlugin_8";
    private static final String SELECT_FIELD = "id,longnumber,fullname,level,number,name,parent";

    private Object getDataEntityId() {
        String thisId = this.getModel().getDataEntity().getString("id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId());
        return this.safeConvert((DynamicObjectType)mainEntityType, thisId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String type;
        if (args.isCancel()) {
            return;
        }
        if ("kd.bos.entity.operate.Submit".equals(args.getSource().getClass().getName()) || "kd.bos.entity.operate.Save".equals(args.getSource().getClass().getName()) || "kd.bos.entity.operate.SaveAndNew".equals(args.getSource().getClass().getName())) {
            String thisId = this.getModel().getDataEntity().getString("id");
            DynamicObject thisParent = this.getModel().getDataEntity().getDynamicObject(PARENT);
            if (thisParent != null && thisParent.getPkValue().toString().equals(thisId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u672c\u8eab\u4f5c\u4e3a\u4e0a\u7ea7!", (String)"TemplateTreeBaseDataPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject doj = this.getModel().getDataEntity();
            this.processCurrentNode(doj);
        }
        if ("kd.bos.entity.operate.Delete".equals(args.getSource().getClass().getName())) {
            args.setListSelectedData(this.deleteOperation());
        } else if ("kd.bos.entity.operate.StatusConvert".equals(args.getSource().getClass().getName()) && "disable".equals(type = ((AbstractOperate)args.getSource()).getType())) {
            args.setListSelectedData(this.disableOperation());
        }
        super.beforeDoOperation(args);
    }

    private void processCurrentNode(DynamicObject doj) {
        String number = doj.getString(NUMBER);
        Object name = doj.get("name");
        int level = doj.getInt("level");
        Object parentId = doj.get("parent_id");
        Object parentLongName = doj.get("parent.fullname");
        int parentLevel = doj.getInt("parent.level");
        String longNumberDLM = this.getlongNumberDLM(doj);
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String parentLongNumber = doj.getString("parent.longnumber");
            if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                doj.set(LONGNUMBER, (Object)(parentLongNumber + longNumberDLM + number));
            } else if (parentId != null) {
                QFilter filter = new QFilter("id", "=", parentId);
                DynamicObject tempDoj = ORM.create().queryOne(doj.getDataEntityType().getName(), SELECT_FIELD, new QFilter[]{filter});
                if (tempDoj != null) {
                    parentLongNumber = tempDoj.getString(LONGNUMBER);
                    parentLongName = tempDoj.get(FULLNAME);
                    parentLevel = tempDoj.getInt("level");
                    if (StringUtils.isNotBlank((CharSequence)parentLongNumber)) {
                        doj.set(LONGNUMBER, (Object)(parentLongNumber + longNumberDLM + number));
                    } else {
                        doj.set(LONGNUMBER, (Object)number);
                    }
                } else {
                    doj.set(LONGNUMBER, (Object)number);
                }
            } else {
                doj.set(LONGNUMBER, (Object)number);
            }
        }
        if (name != null && StringUtils.isNotBlank((CharSequence)name.toString())) {
            Object currentName = doj.get(FULLNAME);
            if (name instanceof ILocaleString && currentName instanceof ILocaleString) {
                LocaleString newFullName = new LocaleString();
                for (Map.Entry value : ((ILocaleString)name).entrySet()) {
                    String lcid = (String)value.getKey();
                    String parentFullName = null;
                    if (parentLongName instanceof ILocaleString) {
                        parentFullName = (String)((ILocaleString)parentLongName).getItem(lcid);
                    }
                    if (StringUtils.isNotEmpty(parentFullName)) {
                        newFullName.setItem(lcid, (Object)(parentFullName + longNumberDLM + (String)value.getValue()));
                        continue;
                    }
                    newFullName.setItem((String)value.getKey(), value.getValue());
                }
                doj.set(FULLNAME, (Object)newFullName);
            } else if (parentLongName != null && StringUtils.isNotBlank((CharSequence)parentLongName.toString())) {
                doj.set(FULLNAME, (Object)(parentLongName + longNumberDLM + name));
            } else {
                doj.set(FULLNAME, (Object)name.toString());
            }
            IDataEntityProperty fullNameProp = (IDataEntityProperty)doj.getDataEntityType().getProperties().get((Object)FULLNAME);
            if (fullNameProp != null) {
                doj.getLastDirty().set(fullNameProp.getOrdinal(), true);
            }
        }
        if (parentLevel != 0) {
            doj.set("level", (Object)(parentLevel + 1));
        } else {
            doj.set("level", (Object)level);
        }
    }

    private String getlongNumberDLM(DynamicObject doj) {
        String longNumberDLM = ".";
        IDataEntityType dataEntityType = doj.getDataEntityType();
        for (IDataEntityProperty dymProperty : dataEntityType.getProperties()) {
            if (!(dymProperty instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)dymProperty).getLongNumberDLM();
            break;
        }
        return longNumberDLM;
    }

    private ListSelectedRowCollection deleteOperation() {
        ListSelectedRowCollection sortListSelectedRowCollection = null;
        BasedataEntityType entityType = (BasedataEntityType)this.getModel().getDataEntityType();
        String primaryKey = entityType.getPrimaryKey().getName();
        DynamicObjectCollection deleteCol = this.getChildrenDynamicObject(this.getModel().getDataEntity().getPkValue(), entityType);
        if (deleteCol != null) {
            sortListSelectedRowCollection = new ListSelectedRowCollection();
            for (DynamicObject dynamicObject : deleteCol) {
                ListSelectedRow rows = new ListSelectedRow(dynamicObject.get(primaryKey));
                if (sortListSelectedRowCollection.contains((Object)rows)) continue;
                sortListSelectedRowCollection.add((Object)rows);
            }
        }
        return sortListSelectedRowCollection;
    }

    private ListSelectedRowCollection disableOperation() {
        ListSelectedRowCollection sortListSelectedRowCollection = null;
        BasedataEntityType entityType = (BasedataEntityType)this.getModel().getDataEntityType();
        String primaryKey = entityType.getPrimaryKey().getName();
        DynamicObjectCollection disableCol = this.getChildrenDynamicObject(this.getModel().getDataEntity().getPkValue(), entityType);
        if (disableCol != null) {
            sortListSelectedRowCollection = new ListSelectedRowCollection();
            for (DynamicObject dynamicObject : disableCol) {
                ListSelectedRow rows = new ListSelectedRow(dynamicObject.get(primaryKey));
                if (!"1".equals(dynamicObject.get("enable")) || sortListSelectedRowCollection.contains((Object)rows)) continue;
                sortListSelectedRowCollection.add((Object)rows);
            }
        }
        return sortListSelectedRowCollection;
    }

    public DynamicObjectCollection getChildrenDynamicObject(Object id, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty(LONGNUMBER) != null) {
            String entityName = entityType.getName();
            String selectFields = "id,longnumber";
            String orderBy = "longnumber desc";
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", this.safeConvert((DynamicObjectType)entityType, id))};
            DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                if (dynamicObject.getString(LONGNUMBER) == null || "".equals(dynamicObject.getString(LONGNUMBER).trim())) continue;
                list.add(dynamicObject.getString(LONGNUMBER));
            }
            selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
            QFilter baseQfilter = null;
            if (list.size() > 0) {
                baseQfilter = new QFilter(LONGNUMBER, "like", (Object)((String)list.get(0) + "%"));
                for (int i = 1; i < list.size(); ++i) {
                    QFilter tempQfilter = new QFilter(LONGNUMBER, "like", (Object)((String)list.get(i) + "%"));
                    baseQfilter.or(tempQfilter);
                }
            }
            if (baseQfilter == null) {
                return collection;
            }
            DynamicObjectCollection deleteCol = orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
            return deleteCol;
        }
        return null;
    }

    private Object safeConvert(DynamicObjectType type, Object value) {
        if (null == type || null == value) {
            return value;
        }
        ISimpleProperty primaryKey = type.getPrimaryKey();
        if (null == primaryKey) {
            return value;
        }
        int dbType = primaryKey.getDbType();
        return DbTypeConverter.safeConvert((int)dbType, (Object)value);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String listCaption;
        BasedataEntityType entityType = (BasedataEntityType)this.getModel().getDataEntityType();
        GroupProp prop = (GroupProp)entityType.getProperty(PARENT);
        if (!(prop instanceof ParentBasedataProp)) {
            return;
        }
        String propName = prop.getName();
        String entityName = prop.getEntityType().getName();
        String numberName = prop.getNumberProp();
        String string = listCaption = StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getCaption()) ? "" : this.getView().getFormShowParameter().getCaption();
        if (evt.getItemKey().equals("bar_disable") || evt.getItemKey().equals("bar_delete")) {
            ORM orm = ORM.create();
            String selectField = "id," + prop.getEntityType().getNameProperty() + "," + propName + ".enable," + propName + "." + numberName + ",longnumber";
            DynamicObjectType dynamicObjectType = this.getModel().getDataEntity().getDynamicObjectType();
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter q = new QFilter("id", "=", this.safeConvert(dynamicObjectType, pkValue));
            QFilter[] filters = new QFilter[]{q};
            DynamicObjectCollection dynamicObjectCollection = orm.query(prop.getBaseEntityId(), selectField, filters);
            Object[] longNumbers = new Object[dynamicObjectCollection.size()];
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject doj = (DynamicObject)dynamicObjectCollection.get(i);
                longNumbers[i] = doj.get(LONGNUMBER);
            }
            if (longNumbers.length > 0) {
                QFilter baseQfilter = new QFilter(LONGNUMBER, "like", (Object)(longNumbers[0] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                for (int i = 1; i < longNumbers.length; ++i) {
                    QFilter tempQfilter = new QFilter(LONGNUMBER, "like", (Object)(longNumbers[i] + ((ParentBasedataProp)prop).getLongNumberDLM() + "%"));
                    baseQfilter.or(tempQfilter);
                }
                if (orm.exists(entityName, new QFilter[]{baseQfilter})) {
                    evt.setCancel(true);
                    if (evt.getItemKey().equals("bar_disable")) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u63d0\u793a", (String)"TemplateTreeBaseDataPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s%2$s\u6709\u4e0b\u7ea7\uff0c\u6b64\u6b21\u7981\u7528\u5c06\u7981\u7528\u57fa\u7840\u8d44\u6599\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TemplateTreeBaseDataPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), listCaption, this.getModel().getDataEntity().get(NUMBER), listCaption), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("disablebyall", (IFormPlugin)this));
                    } else if (evt.getItemKey().equals("bar_delete")) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"TemplateTreeBaseDataPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5c06\u5220\u9664\u672c\u6761\u6570\u636e\u53ca\u5176\u4e0b\u7ea7\u57fa\u7840\u8d44\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TemplateTreeBaseDataPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), new Object[0]), MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("delbyall", (IFormPlugin)this));
                    }
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("delbyall".equals(event.getCallBackId())) {
            this.delete(event);
        } else if ("disablebyall".equals(event.getCallBackId())) {
            this.disable(event);
        } else if ("enablebyall".equals(event.getCallBackId())) {
            this.enable(event);
        }
    }

    public void delete(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("delete");
            this.getView().showMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TemplateTreeBaseDataPlugin_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    public void disable(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("disable");
        }
    }

    public void enable(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("enable");
        }
    }
}

