/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import org.apache.commons.io.FilenameUtils;

class TreeListBizApps {
    public static final Log logger = LogFactory.getLog(TreeListBizApps.class);
    public static final String ERROR = "ERROR";
    public static final String NOPATH = "NOPATH";
    public static final String PAGE_WARN = "PAGE_WARN";
    public static final String CARD_WARN = "CARD_WARN";
    public static final String SCRIPT_WARN = "SCRIPT_WARN";
    public static final String DYM_WARN = "DYM_WARN";
    public static final String DYMX_WARN = "DYMX_WARN";
    public static final String SUCCESS = "SUCCESS";
    public static final String CONFLICT = "CONFLICT";
    public static final String EMPTY_COMMIT = "EMPTY COMMIT";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String UPLOADPATH = "KINGDEEUPDATEDOWNLOAD";
    public static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    public static final String APPPLUGIN = "APPPLUGIN";
    public static final String PAGEPLUGIN = "PAGEPLUGIN";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String NUMBER = "number";
    private static final String BIZAPP = "bizapp";
    private static final String BIZAPPNAME = "bizappname";
    private static final String BIZUNIT = "bizunit";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZUNITNAME = "bizunitname";
    private static final String MASTERID = "masterid";
    private static final String USETYPE = "usetype";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String USERESOURCE = "useresource";
    private static final String BIZCLOUD = "bizcloud";
    private static final String BIZCLOUD_ID = "bizcloud_id";
    private static final String SEQUENCE = "sequence";
    private static final String CLOUD = "cloud";
    private static final String ROOTNODE = "rootNode";
    private static final String INDUSTRY = "industry";
    public static final String ORITENENTISV = "kingdee";
    public static final String SCENE_DELETEAPP = "deleteapp";
    private static final String ORDERBY = "sequence asc";
    private static final String BIZAPPID = "bizappid";
    private static final String ISV_KINGDEE = "kingdee";

    TreeListBizApps() {
    }

    private String getNopermissiontip() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"TreeListBizApps_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
    }

    public static void deleteFiles(String deletePath) {
        TreeListBizApps.deleteKd(new File(FilenameUtils.getName((String)(deletePath + File.separator + "dbschema"))));
        TreeListBizApps.deleteKd(new File(FilenameUtils.getName((String)(deletePath + File.separator + "metadata"))));
        TreeListBizApps.deleteKd(new File(FilenameUtils.getName((String)(deletePath + File.separator + "preinsdata"))));
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (file.delete()) {
                // empty if block
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    if (!file.delete()) continue;
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                TreeListBizApps.deleteKd(fileList[i]);
            }
            if (file.delete()) {
                // empty if block
            }
        }
    }

    public static void deleteFile(String deletePath) {
        File file = new File(FilenameUtils.getName((String)deletePath));
        TreeListBizApps.deleteKd(file);
    }

    public static List<String> getFilePaths(String formNumber, String svnLocalPath) {
        ArrayList<String> filePathList = new ArrayList<String>();
        List<String> fileList = TreeListBizApps.getFileNames(formNumber);
        for (String fileName : fileList) {
            if (!fileName.endsWith(".dym") && !fileName.endsWith(".dymx")) continue;
            filePathList.add(TreeListBizApps.getMetaXmlPath(fileName, svnLocalPath));
        }
        return filePathList;
    }

    private static List<String> getFileNames(String formNumber) {
        ArrayList<String> fileList = new ArrayList<String>();
        String dynFileName = String.format("%s.dym", formNumber);
        String dynLangFileName_CN = String.format("%s.zh_CN.dymx", formNumber);
        String dynLangFileName_EN = String.format("%s.en.dymx", formNumber);
        String dynLangFileName_EN_US = String.format("%s.en_US.dymx", formNumber);
        String dynLangFileName_TW = String.format("%s.zh_TW.dymx", formNumber);
        fileList.add(dynFileName);
        fileList.add(dynLangFileName_CN);
        fileList.add(dynLangFileName_EN);
        fileList.add(dynLangFileName_EN_US);
        fileList.add(dynLangFileName_TW);
        return fileList;
    }

    public static String getMetaXmlPath(String filename, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, filename);
        return fullPath;
    }

    public static String getSessionKey(String svnPath, String uuid) {
        String substring;
        String[] split2;
        String re = "((http|https|svn|file)://)(([a-zA-Z0-9._-]+)|([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}))(([a-zA-Z]{2,6})|(:[0-9]{1,4})?)";
        String sessionKey = "";
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(svnPath);
        sessionKey = matcher.matches() ? svnPath : ((split2 = svnPath.split(re)).length > 1 ? (substring = svnPath.substring(0, svnPath.length() - split2[1].length())) : split2[0]);
        String userId = RequestContext.get().getUserId();
        return sessionKey + uuid + userId;
    }

    public static String getIsvByAppId(String bizAppId) {
        return AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
    }

    public static String getIsvByCloudId(String bizCloudId) {
        return BizCloudServiceHelp.getIsvByCloudId((String)bizCloudId);
    }

    public static boolean checkCloudResourceBelongsToCurDeveloper(String bizCloudId) {
        if (StringUtils.isBlank((CharSequence)bizCloudId)) {
            return false;
        }
        return TreeListBizApps.getIsvByCloudId(bizCloudId).equals(TreeListBizApps.getDeveloperInfo());
    }

    public static boolean checkResourceBelongsToCurDeveloper(String bizAppId) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return false;
        }
        return TreeListBizApps.getIsvByAppId(bizAppId).equals(TreeListBizApps.getDeveloperInfo());
    }

    public static boolean checkResourceBelongsToCurDeveloper(String bizAppId, String developer) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return false;
        }
        return TreeListBizApps.getIsvByAppId(bizAppId).equals(developer);
    }

    public static String getDeveloperInfo() {
        return ISVService.getISVInfo().getId();
    }

    public static boolean isScriptBeReferenced(String scriptId) {
        QFilter[] qFilterArr = new QFilter[]{new QFilter("scriptid", "=", (Object)scriptId)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_devp_pagerelscript", (String)"pageid", (QFilter[])qFilterArr);
        return dynamicObjects.length > 0;
    }

    public static boolean checkDeleteResource(String id, String bizAppId, IFormView view, String resourceType, String sceneType) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        switch (resourceType) {
            case "page": {
                DynamicObject[] bizApp;
                DynamicObject thisform = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_FORMMETA, (String)NUMBER);
                if (thisform == null || StringUtils.isBlank((CharSequence)thisform.getString(NUMBER))) {
                    return true;
                }
                MetadataWriter writer = new MetadataWriter();
                if (writer.isExistFormRefs(id)) {
                    DynamicObject[] forms;
                    QFilter q1 = new QFilter("basedatafield", "=", (Object)id);
                    QFilter q2 = new QFilter("id", "!=", (Object)id);
                    QFilter q3 = new QFilter("modeltype", "!=", (Object)"PrintModel");
                    QFilter q4 = new QFilter("inheritpath", "like", (Object)("%" + id + "%"));
                    QFilter filter = q1.and(q2).and(q3).or(q4);
                    QFilter[] filters1 = new QFilter[]{filter};
                    for (DynamicObject dynamicObject : forms = BusinessDataServiceHelper.load((String)BOS_FORMMETA, (String)"id,name,number,modeltype,masterid,basedatafield", (QFilter[])filters1)) {
                        try {
                            DynamicObject unitRelForm = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{new QFilter("form", "=", dynamicObject.get("id"))});
                            if (unitRelForm == null) continue;
                            JSONObject page = new JSONObject();
                            DynamicObject bizApp2 = unitRelForm.getDynamicObject(BIZAPP);
                            page.put(BIZAPPID, (Object)bizApp2.getString("id"));
                            page.put(BIZAPPNAME, (Object)bizApp2.getString("name"));
                            String bizunitid = unitRelForm.getString(BIZUNIT);
                            page.put(BIZUNITID, (Object)bizunitid);
                            String bizunitname = AppMetaServiceHelper.getFunctionPacketById((String)bizunitid, (String)bizApp2.getString("id"), (boolean)false).getName().getLocaleValue();
                            page.put(BIZUNITNAME, (Object)bizunitname);
                            page.put("id", (Object)dynamicObject.getString("id"));
                            page.put("name", (Object)dynamicObject.getString("name"));
                            page.put(NUMBER, (Object)dynamicObject.getString(NUMBER));
                            page.put("type", (Object)ResManager.loadKDString((String)"\u9875\u9762", (String)"TreeListBizApps_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            String masterId = dynamicObject.getString(MASTERID);
                            String formId = dynamicObject.getString("id");
                            String entityId = dynamicObject.getString("basedatafield_id");
                            if (!formId.equals(entityId)) {
                                page.put(USETYPE, (Object)ResManager.loadKDString((String)"\u5e03\u5c40", (String)"TreeListBizApps_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            } else if (StringUtils.isNotBlank((CharSequence)masterId) && masterId.equals(id)) {
                                page.put(USETYPE, (Object)ResManager.loadKDString((String)"\u6269\u5c55", (String)"TreeListBizApps_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            } else {
                                page.put(USETYPE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f", (String)"TreeListBizApps_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            }
                            jsonArray.add((Object)page);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                String selectFields = "DISTINCT(FAPPID)";
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT ").append(selectFields).append(" FROM T_META_MENURUNTIME WHERE FFORMID = ?");
                String menuSql = sb.toString();
                Object[] params = new SqlParameter[]{new SqlParameter(":FFORMID", 12, (Object)MetadataDao.getNumberById((String)id))};
                ResultSetHandler callBackHanlder = rs -> {
                    ArrayList<String> appIds = new ArrayList<String>();
                    try {
                        while (rs.next()) {
                            String appId = rs.getString("FAPPID");
                            if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
                            appIds.add(appId);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return appIds;
                };
                List appIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)menuSql, (Object[])params, (ResultSetHandler)callBackHanlder);
                if (appIds != null && appIds.size() > 0) {
                    DynamicObject[] bizApps;
                    QFilter[] qfilter2 = new QFilter[]{new QFilter(NUMBER, "in", (Object)appIds.toArray(new String[appIds.size()]))};
                    for (DynamicObject dynamicObject : bizApps = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])qfilter2)) {
                        try {
                            if (SCENE_DELETEAPP.equals(sceneType) && dynamicObject.getString("id").equals(bizAppId)) continue;
                            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)dynamicObject.getString("id"), (boolean)false);
                            List appMenus = appMetadata.getAppMenus();
                            for (AppMenuElement appMenu : appMenus) {
                                String formId = appMenu.getFormId();
                                if (!StringUtils.isNotBlank((CharSequence)formId) || !formId.equals(id)) continue;
                                JSONObject menu = new JSONObject();
                                menu.put(BIZAPPID, (Object)appMetadata.getAppElement().getId());
                                menu.put(BIZAPPNAME, (Object)appMetadata.getAppElement().getName().getLocaleValue());
                                menu.put(BIZUNITID, (Object)"");
                                menu.put(BIZUNITNAME, (Object)"");
                                menu.put("id", (Object)appMenu.getId());
                                menu.put("name", (Object)appMenu.getName().getLocaleValue());
                                menu.put(NUMBER, (Object)appMenu.getNumber());
                                menu.put("type", (Object)ResManager.loadKDString((String)"\u5e94\u7528\u83dc\u5355", (String)"TreeListBizApps_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                                menu.put(USETYPE, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u83dc\u5355\u5f15\u7528", (String)"TreeListBizApps_6", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                                jsonArray.add((Object)menu);
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                QFilter[] qfilter3 = new QFilter[]{new QFilter("mainformid", "=", (Object)id)};
                for (DynamicObject dynamicObject : bizApp = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number", (QFilter[])qfilter3)) {
                    try {
                        if (SCENE_DELETEAPP.equals(sceneType) && dynamicObject.getString("id").equals(bizAppId)) continue;
                        JSONObject bizapp = new JSONObject();
                        bizapp.put(BIZAPPID, (Object)dynamicObject.getString("id"));
                        bizapp.put(BIZAPPNAME, (Object)dynamicObject.getString("name"));
                        bizapp.put(BIZUNITID, (Object)"");
                        bizapp.put(BIZUNITNAME, (Object)"");
                        bizapp.put("id", (Object)dynamicObject.getString("id"));
                        bizapp.put("name", (Object)dynamicObject.getString("name"));
                        bizapp.put(NUMBER, (Object)dynamicObject.getString(NUMBER));
                        bizapp.put("type", (Object)ResManager.loadKDString((String)"\u5e94\u7528", (String)"TreeListBizApps_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        bizapp.put(USETYPE, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u5f15\u7528", (String)"TreeListBizApps_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        jsonArray.add((Object)bizapp);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                if (jsonArray != null && jsonArray.size() > 0) {
                    DynamicObject form = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_FORMMETA);
                    String name = form.getString("name");
                    jsonObject.put(KEY_SUCCESS, (Object)false);
                    jsonObject.put(MESSAGE, (Object)String.format(ResManager.loadKDString((String)"\"%s\"\u9875\u9762\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"TreeListBizApps_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), name));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(KEY_SUCCESS, (Object)true);
                break;
            }
            case "script": {
                JSONArray formIds = new JSONArray();
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devp_pagerelscript", (String)"scriptid,pageid,enable", (QFilter[])new QFilter[]{new QFilter("scriptid", "=", (Object)id)});
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String formId = (String)dynamicObject.get("pageid");
                    formIds.add((Object)formId);
                }
                QFilter[] filters5 = new QFilter[]{new QFilter("id", "in", (Object)formIds)};
                try (DataSet dataSet5 = QueryServiceHelper.queryDataSet((String)"DEV.FRAME.MainPage", (String)BOS_FORMMETA, (String)"id,name,number", (QFilter[])filters5, (String)"number asc");
                     DataSet dataSet6 = QueryServiceHelper.queryDataSet((String)"DEV.DEVPORTAL.BizPage", (String)"bos_devportal_unitrelform", (String)"bizunit,bizapp,form", null, null);
                     DataSet pages = dataSet5.join(dataSet6, JoinType.INNER).on("id", "form").select(new String[]{"id", "name", NUMBER}, new String[]{BIZUNIT, BIZAPP, "form"}).finish();){
                    for (Row row : pages) {
                        try {
                            JSONObject page = new JSONObject();
                            AppElement appElement = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)row.getString(BIZAPP), (boolean)false).getAppElement();
                            AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)row.getString(BIZUNIT), (String)row.getString(BIZAPP), (boolean)false);
                            page.put(BIZAPPID, (Object)appElement.getId());
                            page.put(BIZAPPNAME, (Object)appElement.getName().getLocaleValue());
                            page.put(BIZUNITID, (Object)functionPacket.getId());
                            page.put(BIZUNITNAME, (Object)functionPacket.getName().getLocaleValue());
                            page.put("id", (Object)row.getString("id"));
                            page.put("name", (Object)row.getString("name"));
                            page.put(NUMBER, (Object)row.getString(NUMBER));
                            page.put("type", (Object)ResManager.loadKDString((String)"\u9875\u9762", (String)"TreeListBizApps_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            page.put(USETYPE, (Object)ResManager.loadKDString((String)"\u9875\u9762\u6ce8\u518c\u811a\u672c\u63d2\u4ef6", (String)"TreeListBizApps_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                            jsonArray.add((Object)page);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                if (jsonArray != null && jsonArray.size() > 0) {
                    jsonObject.put(KEY_SUCCESS, (Object)false);
                    jsonObject.put(MESSAGE, (Object)ResManager.loadKDString((String)"\u8be5\u811a\u672c\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"TreeListBizApps_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(KEY_SUCCESS, (Object)true);
                break;
            }
            case "unittest": {
                if (jsonArray != null && jsonArray.size() > 0) {
                    jsonObject.put(KEY_SUCCESS, (Object)false);
                    jsonObject.put(MESSAGE, (Object)ResManager.loadKDString((String)"\u8be5\u5355\u5143\u6d4b\u8bd5\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"TreeListBizApps_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(KEY_SUCCESS, (Object)true);
                break;
            }
        }
        if (jsonObject != null && jsonObject.getBooleanValue(KEY_SUCCESS)) {
            return true;
        }
        if (SCENE_DELETEAPP.equals(sceneType)) {
            return false;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_delresourcetip");
        parameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u8d44\u6e90\u63d0\u793a", (String)"TreeListBizApps_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        parameter.setCustomParam("scenetype", (Object)sceneType);
        parameter.setCustomParam(MESSAGE, jsonObject.get((Object)MESSAGE));
        parameter.setCustomParam(USERESOURCE, (Object)jsonObject.get((Object)USERESOURCE).toString());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
        return false;
    }

    public static void getMetadataContent(File filePath, JSONObject msg) {
        File[] files;
        for (File file : files = filePath.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith("dym") && !fileName.endsWith("dymx")) continue;
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
                String content = sb.toString();
                MetadataDao.deployMetadata((String)content);
                TreeListBizApps.rebuildRuntimeMetaById(content);
            }
            catch (IOException e) {
                msg.put(ERROR, (Object)e);
                return;
            }
        }
    }

    public static void getMetadataContent(File file) {
        String fileName = file.getName();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            String content = sb.toString();
            if (fileName.endsWith(".dym")) {
                MetadataDao.deployMetadata((String)content);
                TreeListBizApps.rebuildRuntimeMetaById(content);
            } else if (fileName.endsWith(".dymx")) {
                MetadataDao.deployMetadata((String)content);
            } else if (fileName.endsWith(".ks")) {
                MetadataDao.deployScript((String)content);
            } else if (fileName.endsWith(".card")) {
                MetadataDao.deployCard((String)content);
            } else if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
                AppMetaServiceHelper.deployAppMetadata((String)content);
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void rebuildRuntimeMetaById(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        if (!deployNew.isMultilanguage()) {
            String formId = deployNew.getMasterId();
            MetadataDao.rebuildRuntimeMetaById((String)formId);
        }
    }

    public static boolean checkPagePermission(String pageNumber, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkPermission((long)userId, (String)"bos_org", (long)0L, null, (String)pageNumber, (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    public static void addLog(String id, String opName, String opDescription) {
        try {
            LogServiceHelper helper = new LogServiceHelper();
            AppLogInfo info = new AppLogInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"devportal")});
            if (bizApp != null) {
                info.setBizAppID(bizApp.getString("id"));
            }
            info.setBizObjID(id);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(opName);
            info.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])filters, (String)ORDERBY);
        return cloudsMap;
    }

    public static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime) {
        return TreeListBizApps.getApps(filters, orderBy, isRuntime, true);
    }

    public static List<DynamicObject> getApps(QFilter[] filters, boolean isRuntime) {
        return TreeListBizApps.getApps(filters, ORDERBY, isRuntime);
    }

    public static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime, boolean onlyVisible) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)BIZCLOUD);
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number,type,industry,bizcloud,sequence,visible", (QFilter[])filters, (String)orderBy);
        HashSet<String> extendedAppIds = new HashSet<String>();
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                extendedAppIds.add(obj.getString(MASTERID));
            }
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                String appId = obj.getString("id");
                String appNum = obj.getString(NUMBER);
                if (isRuntime && onlyVisible) {
                    if ("portal".equals(appNum)) continue;
                    if (extendedAppIds.contains(appId)) {
                        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
                        if (!appInfo.isRealRuntime()) continue;
                        obj.set("name", (Object)appInfo.getName());
                    } else {
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        final Map<Object, DynamicObject> cloudsMap = TreeListBizApps.getClouds(null);
        try {
            Collections.sort(apps, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    if (o1.getString(TreeListBizApps.BIZCLOUD_ID).equals(o2.getString(TreeListBizApps.BIZCLOUD_ID))) {
                        return 0;
                    }
                    DynamicObject obj1 = (DynamicObject)cloudsMap.get(o1.getString(TreeListBizApps.BIZCLOUD_ID));
                    DynamicObject obj2 = (DynamicObject)cloudsMap.get(o2.getString(TreeListBizApps.BIZCLOUD_ID));
                    if (obj1 != null && obj2 != null && StringUtils.isNotBlank((Object)obj1.getInt(TreeListBizApps.SEQUENCE)) && StringUtils.isNotBlank((Object)obj2.getInt(TreeListBizApps.SEQUENCE))) {
                        return obj1.getInt(TreeListBizApps.SEQUENCE) - obj2.getInt(TreeListBizApps.SEQUENCE);
                    }
                    return 0;
                }
            });
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return apps;
    }

    public static TreeNode getCloudSubsysTree(String[] bizCloudIds, String industryId) {
        TreeNode root = TreeListBizApps.getSubsysTree(bizCloudIds, null, industryId, CLOUD, true);
        return root;
    }

    public static TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed) {
        TreeNode root = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"TreeListBizApps_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), (Object)"root");
        root.setIsOpened(true);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (CLOUD.equals(leafType)) {
            QFilter filter;
            if (bizCloudIds != null) {
                filter = new QFilter("id", "in", (Object)bizCloudIds);
                filterList.add(filter);
            }
            if (StringUtils.isNotBlank((CharSequence)industryId)) {
                filter = new QFilter(INDUSTRY, "=", (Object)industryId);
                filter.or(new QFilter(INDUSTRY, "=", (Object)0));
                filterList.add(filter);
            }
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
            Map<Object, DynamicObject> cloudsMap = TreeListBizApps.getClouds(filters);
            for (DynamicObject obj : cloudsMap.values()) {
                TreeNode node = new TreeNode(ROOTNODE, obj.getString("id"), obj.getString("name"), (Object)CLOUD);
                root.addChild(node);
            }
        } else {
            QFilter filter;
            if (bizAppIds != null) {
                filter = new QFilter("id", "in", (Object)bizAppIds);
                filterList.add(filter);
            } else if (bizCloudIds != null) {
                filter = new QFilter(BIZCLOUD, "in", (Object)bizCloudIds);
                filterList.add(filter);
            }
            if (StringUtils.isNotBlank((CharSequence)industryId)) {
                filter = new QFilter(INDUSTRY, "=", (Object)industryId);
                filter.or(new QFilter(INDUSTRY, "=", (Object)0));
                filterList.add(filter);
            }
            if (isRuntime) {
                filter = new QFilter("type", "!=", (Object)"2");
                filterList.add(filter);
            }
            if (isRuntime && onlyDeployed) {
                filter = new QFilter("deploystatus", "=", (Object)"2");
                filterList.add(filter);
            }
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
            List<DynamicObject> apps = TreeListBizApps.getApps(filters, ORDERBY, isRuntime, onlyVisible);
            HashMap<String, TreeNode> allNodeMap = new HashMap<String, TreeNode>();
            for (DynamicObject obj : apps) {
                AppMetadata appMeta;
                DynamicObject cldObj = obj.getDynamicObject(BIZCLOUD);
                if (cldObj == null) continue;
                String cldName = cldObj.getLocaleString("name").toString();
                String cldId = cldObj.getString("id");
                String appName = obj.getLocaleString("name").toString();
                String appId = obj.getString("id");
                String appNum = obj.getString(NUMBER);
                if (cldId != null && allNodeMap.get(cldId) == null) {
                    TreeNode cldNode = new TreeNode(ROOTNODE, cldId, cldName, (Object)CLOUD);
                    allNodeMap.put(cldId, cldNode);
                    root.addChild(cldNode);
                }
                TreeNode appNode = new TreeNode(cldId, appId, appName, (Object)"app");
                allNodeMap.put(appId, appNode);
                ((TreeNode)allNodeMap.get(cldId)).addChild(appNode);
                if ("menu".equals(leafType)) {
                    TreeNode menuNode;
                    String menuName;
                    String menuId;
                    if (isRuntime) {
                        List appMenus = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
                        if (appMenus == null) continue;
                        for (AppMenuInfo appMenu : appMenus) {
                            menuId = appMenu.getId();
                            menuName = appMenu.getName().toString();
                            menuNode = new TreeNode(appId, menuId, menuName, (Object)"menu");
                            allNodeMap.put(menuId, menuNode);
                            ((TreeNode)allNodeMap.get(appId)).addChild(menuNode);
                        }
                        continue;
                    }
                    appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)isRuntime);
                    if (appMeta == null) continue;
                    for (AppMenuInfo appMenu : appMeta.getAppMenus()) {
                        menuId = appMenu.getId();
                        menuName = appMenu.getName().toString();
                        menuNode = new TreeNode(appId, menuId, menuName, (Object)"menu");
                        allNodeMap.put(menuId, menuNode);
                        ((TreeNode)allNodeMap.get(appId)).addChild(menuNode);
                    }
                    continue;
                }
                if (!"func".equals(leafType) || (appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)isRuntime)) == null) continue;
                for (AppFunctionPacketElement appFunc : appMeta.getAppFunctionPackets()) {
                    String funcId = appFunc.getId();
                    String funcName = appFunc.getName().toString();
                    TreeNode funcNode = new TreeNode(appId, funcId, funcName, (Object)"func");
                    allNodeMap.put(funcId, funcNode);
                    ((TreeNode)allNodeMap.get(appId)).addChild(funcNode);
                }
            }
        }
        return root;
    }

    public static TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime) {
        return TreeListBizApps.getSubsysTree(bizCloudIds, bizAppIds, industryId, leafType, isRuntime, true, true);
    }

    public static Map<String, Object> getAppListInfo(QFilter[] filters, String industryId, boolean isRuntime, boolean onlyVisible, String orderBy, int pageIndex, int limit) {
        List<DynamicObject> apps;
        QFilter[] filter;
        HashMap<String, Object> rt = new HashMap<String, Object>();
        ArrayList<Object> filterList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filter.and(new QFilter("deploystatus", "=", (Object)"2"));
            filterList.add(filter);
        }
        if (filters != null) {
            for (QFilter f : filters) {
                filterList.add(f);
            }
        }
        if (filterList.size() > 0) {
            filters = filterList.toArray(new QFilter[filterList.size()]);
        }
        if ((apps = TreeListBizApps.getApps(filters, orderBy, isRuntime, onlyVisible)) != null && apps.size() > 0) {
            rt.put("datacount", apps.size());
            DynamicObjectCollection col = new DynamicObjectCollection();
            for (int i = pageIndex * limit; i < (pageIndex + 1) * limit && i < apps.size(); ++i) {
                col.add((Object)apps.get(i));
            }
            rt.put("data", col);
        }
        return rt;
    }

    public static Map<String, Object> getAppListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
        return TreeListBizApps.getAppListInfo(filters, industryId, isRuntime, false, orderBy, pageIndex, limit);
    }

    public static Map<String, Object> getRuntimeAppListInfo(QFilter[] filters, String industryId, String orderBy, int pageIndex, int limit) {
        return TreeListBizApps.getAppListInfo(filters, industryId, true, true, orderBy, pageIndex, limit);
    }

    public static int getCountByFilter(QFilter[] filters, String entityName) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(entityName + "_getCount"), (String)entityName, (String)"id", (QFilter[])filters, null);){
            int n = ds.count("id", true);
            return n;
        }
    }

    public static Map<String, Object> getFormListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        QFilter[] filter;
        HashMap<String, Object> rt = new HashMap<String, Object>();
        ArrayList<Object> filterList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filterList.add(filter);
        }
        if (filters != null) {
            for (QFilter f : filters) {
                filterList.add(f);
            }
        }
        if (filterList.size() > 0) {
            filters = filterList.toArray(new QFilter[filterList.size()]);
        }
        int count = TreeListBizApps.getCountByFilter(filters, BOS_FORMMETA);
        rt.put("datacount", count);
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject[] formArray = BusinessDataServiceHelper.load((String)BOS_FORMMETA, (String)"id,name,number,type,modeltype,bizappid", (QFilter[])filters, (String)orderBy, (int)pageIndex, (int)limit);
        HashSet<String> extendedFormPks = new HashSet<String>();
        if (isRuntime && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_FORMMETA, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)true), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                extendedFormPks.add(obj.getString(MASTERID));
            }
        }
        if (formArray != null) {
            for (DynamicObject obj : formArray) {
                FormConfig cfg;
                String id = obj.getString("id");
                String formNum = obj.getString(NUMBER);
                String modelType = obj.getString("modeltype");
                if (isRuntime && !"PrintModel".equals(modelType) && extendedFormPks.contains(id) && (cfg = FormMetadataCache.getFormConfig((String)formNum)) != null) {
                    obj.set("name", (Object)cfg.getCaption());
                }
                col.add((Object)obj);
            }
        }
        rt.put("data", col);
        return rt;
    }

    public static Map<String, Object> getRuntimeFormListInfo(QFilter[] filters, String industryId, String orderBy, int start, int limit) {
        return TreeListBizApps.getFormListInfo(filters, industryId, true, orderBy, start, limit);
    }

    public static String autoExtendedNumber(String number) {
        String isv = TreeListBizApps.getDeveloperInfo();
        number = number.toLowerCase(Locale.ENGLISH);
        if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && !number.startsWith(isv.toLowerCase(Locale.ENGLISH) + "_")) {
            number = isv.toLowerCase(Locale.ENGLISH) + "_" + number;
        }
        return number + "_ext";
    }

    public static String autoAppNumber(String bizCloudId, String appNumber, String tag) {
        if (appNumber.length() <= 25) {
            if (TreeListBizApps.checkAppNumber(bizCloudId, appNumber)) {
                int i = 1;
                String number = appNumber + i;
                while (TreeListBizApps.checkAppNumber(bizCloudId, number)) {
                    number = appNumber + ++i;
                }
                appNumber = number;
            }
        } else {
            int tag_len = tag.length();
            appNumber = appNumber.substring(0, 25 - tag_len) + tag;
            int i = 0;
            while (TreeListBizApps.checkAppNumber(bizCloudId, appNumber)) {
                int i_len = String.valueOf(++i).length();
                appNumber = appNumber.substring(0, 25 - tag_len - i_len) + tag + i;
            }
        }
        return appNumber;
    }

    private static boolean checkAppNumber(String bizCloudId, String appNumber) {
        QFilter q1 = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter q2 = new QFilter(NUMBER, "=", (Object)appNumber);
        QFilter[] filters = new QFilter[]{q1, q2};
        boolean exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters);
        return exists;
    }
}

