/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;

public class WidgetTripRequestPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"labelap", "LabelAp2", "LabelAp3"});
    }

    public void click(EventObject evt) {
        this.openFormListPlugin();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.labelText();
    }

    public void labelText() {
        String sql = String.format("select count(*) from %s where fstate < '4'", "T_EP_TripRequest");
        Integer count = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                Integer iRet = 0;
                try {
                    if (rs.next()) {
                        iRet = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return iRet;
            }
        });
        if (StringUtils.isBlank((Object)count)) {
            count = 0;
        }
        Label image = (Label)this.getView().getControl("labelap");
        image.setText(count + "");
    }

    public void openFormListPlugin() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fin_ep_triprequest_edit");
        parameter.setFormId("bos_list");
        LocaleString caption = FormMetadataCache.getFormConfig((String)"fin_ep_triprequest_edit").getCaption();
        parameter.setCaption(caption.toString());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("isOpenNewTab", (Object)true);
        parameter.getOpenStyle().setTargetKey("tabap");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

